#!/usr/global/bin/perl -i.ORIG

while(<>) {
    if( /^class +([a-zA-Z0-9]+) *:/ ) {
	$class = $1;
	$desc  = $class;
	$desc  =~ s/^CN//;
	$desc  =~ tr/[a-z]/[A-Z]/;
	$desc  = "CN_$desc";
    }

    if( /^[ \t]*static $class \*cast_from_object\(/ ) {
	print "    static $class *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return ($class *)obj;
#   else
	return ($class *)( obj->is_a($desc)
	       ? obj : fatal_type(obj->class_desc(), $desc) );
#   endif
    }
";
	next;
    }

    if( /^[ \t]*\/\/ (CN)?Object creat/ ) {
	next;
    }

    if( /^[ \t]*static CNObject \*new_object\(/ ) {
	print "    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new $class(param) : new $class; }
";
	next;
    }

    print;
}
