/*     @(#)func_tbl.c	1.4 9/23/92  */

/**********************************************************************
FILE   : func_tbl.c
PURPOSE: SNNS-Kernel Function table
NOTES  : 
AUTHOR : Niels Mache
DATE   : 25.06.90
VERSION : 1.4  9/23/92

 Copyright (c) 1990,1991,1992 by Niels Mache and the SNNS Group

**********************************************************************/

#include <stdio.h>

#include "kr_typ.h"	    /*	Kernel Types and Constants  */
#include "kr_const.h"       /*  Constant Declarators for SNNS-Kernel  */


/*  The function table contains 5 entries:
     - the XGUI-Identifier of this function (a pointer to a string constant),
       note that the identifier have to match [A-Za-z]^[|, ]* (i.e. the first
       character of the symbol must be a letter and all other characters must
       not match [|, ])

     - an integer constant that determine the class of the function.
       7 different classes are possible:
       OUT_FUNC, ACT_FUNC, ACT_DERIV_FUNC, SITE_FUNC, UPDATE_FUNC, LEARN_FUNC
       and INIT_FUNC

     - the number of input parameters for this function (only needed for Update,
       Init and Learning functions)

     - the number of output parameters returned by this function (only needed
       for Update and Learning functions)

     - a pointer to the (user defined) function.
*/



/*  Some of the following functions are default functions of the SNNS-Kernel.
    If you want to change the default presettings, modify the constants
    defined in "kr_const.h".
*/


/*  Declare all functions as external functions !
*/
/*  Output functions  */
extern FlintType  OUT_Threshold05();
extern FlintType  OUT_Clip_01();
extern FlintType  OUT_Clip_11();

/*  Activation functions  */
extern FlintType  ACT_Logistic();
extern FlintType  ACT_BSBFunction();
extern FlintType  ACT_TanHFunction();
extern FlintType  ACT_Perceptron();
extern FlintType  ACT_Signum();
extern FlintType  ACT_Signum0();
extern FlintType  ACT_StepFunction();
extern FlintType  ACT_BAMFunction();
extern FlintType  ACT_LogisticI();
extern FlintType  ACT_MinOutPlusWeight();
extern FlintType  ACT_Linear();
extern FlintType  ACT_LogisticTbl();
extern FlintType  ACT_RBF_Gaussian();
extern FlintType  ACT_RBF_Multiquadratic();
extern FlintType  ACT_RBF_Thinplatespline();
extern FlintType  ACT_Linear_bias();

/*  Derivation functions of the activation functions
*/
extern FlintType  ACT_DERIV_Logistic();
extern FlintType  ACT_DERIV_BSBFunction();
extern FlintType  ACT_DERIV_TanHFunction();
extern FlintType  ACT_DERIV_Dummy();
extern FlintType  ACT_DERIV_Identity();
extern FlintType  ACT_DERIV_Logistic();
extern FlintType  ACT_DERIV_RBF_Gaussian();
extern FlintType  ACT_DERIV_RBF_Multiquadratic();
extern FlintType  ACT_DERIV_RBF_Thinplatespline();

/*  Site functions  */
extern FlintType  SITE_WeightedSum();
extern FlintType  SITE_ProductA();
extern FlintType  SITE_Product();
extern FlintType  SITE_Max();
extern FlintType  SITE_Min();

/*  Update functions  */
extern krui_err  UPDATE_serialPropagate();
extern krui_err  UPDATE_syncPropagate();
extern krui_err  UPDATE_randomOrderPropagate();
extern krui_err  UPDATE_randomPermutPropagate();
extern krui_err  UPDATE_topologicalPropagate();
extern krui_err  UPDATE_CPNPropagate();

/*  Leaning Functions  */
extern krui_err  LEARN_backprop();
extern krui_err  LEARN_backpropBatch();
extern krui_err  LEARN_backpropMomentum();
extern krui_err  LEARN_perc();
extern krui_err  LEARN_quickprop();
extern krui_err  LEARN_CPN();
extern krui_err  LEARN_RBF();

/*  Initialisation Functions  */
extern krui_err  INIT_randomizeWeights();
extern krui_err  INIT_Weights_CPN();
extern krui_err  INIT_RBF_Weights();
extern krui_err  INIT_RBF_Weights_redo();
extern krui_err  INIT_RBF_Weights_kohonen();

/*  *********************************************************************  */

/*  Here is the function table
*/
struct FuncTable  kernel_func_table[]	=
  {

/*  Output functions  */
/*  In 'kr_const.h' is defined that the NULL-pointer presents the
    identity function. So the "Out_Identity" function is represented
    by the NULL-pointer instead of the function pointer.
*/
/*  This is the DEFAULT FUNCTION  */
"Out_Identity",     OUT_FUNC | DEFAULT_FUNC, 0, 0, (FunctionPtr) OUT_IDENTITY,

"Out_Threshold05",  OUT_FUNC, 0, 0, (FunctionPtr) OUT_Threshold05,
"Out_Clip_01",      OUT_FUNC, 0, 0, (FunctionPtr) OUT_Clip_01,
"Out_Clip_11",      OUT_FUNC, 0, 0, (FunctionPtr) OUT_Clip_11,

/*  Activation functions  */
/*  This is the DEFAULT FUNCTION  */
"Act_Logistic",     ACT_FUNC | DEFAULT_FUNC, 0, 0, (FunctionPtr) ACT_Logistic,
"Act_BSB",          ACT_FUNC, 0, 0, (FunctionPtr) ACT_BSBFunction,
"Act_TanH",         ACT_FUNC, 0, 0, (FunctionPtr) ACT_TanHFunction,
"Act_Perceptron",   ACT_FUNC, 0, 0, (FunctionPtr) ACT_Perceptron,
"Act_Signum",       ACT_FUNC, 0, 0, (FunctionPtr) ACT_Signum,
"Act_Signum0",      ACT_FUNC, 0, 0, (FunctionPtr) ACT_Signum0,
"Act_StepFunc",     ACT_FUNC, 0, 0, (FunctionPtr) ACT_StepFunction,
"Act_BAM",          ACT_FUNC, 0, 0, (FunctionPtr) ACT_BAMFunction,
"Logistic_notInhibit" , ACT_FUNC, 0, 0, (FunctionPtr) ACT_LogisticI,
"Act_MinOutPlusWeight", ACT_FUNC, 0, 0, (FunctionPtr) ACT_MinOutPlusWeight,
"Act_Identity",     ACT_FUNC, 0, 0, (FunctionPtr) ACT_Linear,
"Act_IdentityPlusBias", ACT_FUNC, 0, 0, (FunctionPtr) ACT_Linear_bias,
"Act_LogisticTbl",  ACT_FUNC, 0, 0, (FunctionPtr) ACT_LogisticTbl,
"Act_RBF_Gaussian", ACT_FUNC, 0, 0, (FunctionPtr) ACT_RBF_Gaussian,
"Act_RBF_MultiQuadratic", ACT_FUNC, 0, 0, (FunctionPtr) ACT_RBF_Multiquadratic,
"Act_RBF_ThinPlateSpline", ACT_FUNC, 0, 0, (FunctionPtr) ACT_RBF_Thinplatespline,

/*  Derivation functions of the activation functions
    NOTE: The derivative function of the activation function MUST have
	  the same name as the belonging activation function.
*/
"Act_Logistic",     ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Logistic,
"Act_BSB",          ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_BSBFunction,
"Act_TanH",         ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_TanHFunction,
"Act_Perceptron",   ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy,
"Act_Signum",       ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy,
"Act_Signum0",      ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy,
"Act_StepFunc",     ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy,
"Act_BAM",          ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy,
"Logistic_notInhibit",  ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy,
"Act_MinOutPlusWeight", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Dummy,
"Act_Identity",     ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Identity,
"Act_IdentityPlusBias", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Identity,
"Act_LogisticTbl",  ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_Logistic,
"Act_RBF_Gaussian", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_RBF_Gaussian,
"Act_RBF_MultiQuadratic", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_RBF_Multiquadratic,
"Act_RBF_ThinPlateSpline", ACT_DERIV_FUNC, 0, 0, (FunctionPtr) ACT_DERIV_RBF_Thinplatespline,

/*  Site functions  */
"Site_WeightedSum", SITE_FUNC | DEFAULT_FUNC, 0, 0, (FunctionPtr) SITE_WeightedSum,
"Site_Pi",          SITE_FUNC, 0, 0, (FunctionPtr) SITE_ProductA,
"Site_Produkt",     SITE_FUNC, 0, 0, (FunctionPtr) SITE_Product,
"Site_Max",         SITE_FUNC, 0, 0, (FunctionPtr) SITE_Max,
"Site_Min",         SITE_FUNC, 0, 0, (FunctionPtr) SITE_Min,

/*  Update functions  */
/*  This is the DEFAULT FUNCTION  */
"Serial_Order",        UPDATE_FUNC | DEFAULT_FUNC, 0, 0, (FunctionPtr) UPDATE_serialPropagate,

"Synchonous_Order",    UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_syncPropagate,
"Random_Order",        UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_randomOrderPropagate,
"Random_Permutation",  UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_randomPermutPropagate,
"Topological_Order",   UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_topologicalPropagate,
"CPN_Order",           UPDATE_FUNC, 0, 0, (FunctionPtr) UPDATE_CPNPropagate,

/*  Leaning Functions  */
/*  This is the DEFAULT FUNCTION  */
"Std_Backpropagation", LEARN_FUNC | DEFAULT_FUNC, 2, 1, (FunctionPtr) LEARN_backprop,

"BackpropBatch",       LEARN_FUNC, 4, 1, (FunctionPtr) LEARN_backpropBatch,
"BackpropMomentum",    LEARN_FUNC, 4, 1, (FunctionPtr) LEARN_backpropMomentum,
"BackPercolation",     LEARN_FUNC, 2, 1, (FunctionPtr) LEARN_perc,
"Quickprop",           LEARN_FUNC, 4, 1, (FunctionPtr) LEARN_quickprop,
"Counterpropagation",  LEARN_FUNC, 3, 1, (FunctionPtr) LEARN_CPN,
"RadialBasisLearning", LEARN_FUNC, 4, 1, (FunctionPtr) LEARN_RBF,

/*  Initialisation Functions  */
/*  This is the DEFAULT FUNCTION  */
"Randomize_Weights",   INIT_FUNC | DEFAULT_FUNC, 2, 0, (FunctionPtr) INIT_randomizeWeights,

"CPN_Weights",         INIT_FUNC, 2, 0, (FunctionPtr) INIT_Weights_CPN,
"RBF_Weights",               INIT_FUNC, 5, 0, (FunctionPtr) INIT_RBF_Weights,
"RBF_Weights_Redo",    INIT_FUNC, 5, 0, (FunctionPtr) INIT_RBF_Weights_redo,
"RBF_Weights_Kohonen", INIT_FUNC, 4, 0, (FunctionPtr) INIT_RBF_Weights_kohonen

  };


/*  Define the function table size
*/
#ifdef __STDC__
const int  NoOfKernelFuncs = (sizeof (kernel_func_table) / sizeof (struct FuncTable));
#else
int  NoOfKernelFuncs = (sizeof (kernel_func_table) / sizeof (struct FuncTable));
#endif

/*  **********************************************************************  */
