/*     @(#)glob_typ.h	1.2 7/21/92  */

/**********************************************************************
FILE   : glob_typ.h
PURPOSE: SNNS-Kernel: Global Datatypes and Constants
NOTES  : For User's Application Programs, User-Interface and Kernel
AUTHOR : Niels Mache
DATE   : 14.02.90
VERSION : 1.2  7/21/92

 Copyright (c) 1990,1991,1992 by Niels Mache and the SNNS Group

**********************************************************************/

#ifndef KR_GLOBAL_TYPES

#define KR_GLOBAL_TYPES


#ifndef __BORLANDC__

/*  define KERNEL3D to build a 3D-Version of the kernel
*/

#define KERNEL3D


/*  define MASPAR_KERNEL to build the parallel MasPar Kernel
*/
/*
#define MASPAR_KERNEL
*/

#endif

#ifdef MASPAR_KERNEL

/*  define MASPAR_KERNEL_EMULATION to build a (sequentiel) kernel that simulates
    the MasPar interface
*/
/*
#define  MASPAR_KERNEL_EMULATION
*/

/*
#define  KERNEL_VERBOSE
*/

#endif


/* ******************************************   */

#ifndef TRUE
#define     TRUE    1
#endif
#ifndef FALSE
#define     FALSE   0
#endif

/*#################################################

GROUP: Public Constants

#################################################*/

/*  Kernel user interface error codes
*/
#define  KRERR_NO_ERROR         0
#define  KRERR_INSUFFICIENT_MEM -1
#define  KRERR_UNIT_NO          -2
#define  KRERR_OUTFUNC          -3
#define  KRERR_ACTFUNC          -4
#define  KRERR_SITEFUNC         -5
#define  KRERR_CREATE_SITE      -6
#define  KRERR_ALREADY_CONNECTED  -7
#define  KRERR_CRITICAL_MALLOC  -8
#define  KRERR_FTYPE_NAME       -9
#define  KRERR_FTYPE_ENTRY      -10
#define  KRERR_COPYMODE         -11
#define  KRERR_NO_SITES         -12
#define  KRERR_FROZEN           -13
#define  KRERR_REDEF_SITE_NAME  -14
#define  KRERR_UNDEF_SITE_NAME  -15
#define  KRERR_NOT_3D           -16
#define  KRERR_DUPLICATED_SITE  -17
#define  KRERR_INUSE_SITE       -18
#define  KRERR_FTYPE_SITE       -19
#define  KRERR_FTYPE_SYMBOL     -20
#define  KRERR_IO               -21
#define  KRERR_SAVE_LINE_LEN    -22
#define  KRERR_FEW_LAYERS       -23
#define  KRERR_NO_UNITS         -24
#define  KRERR_EOF              -25
#define  KRERR_LINE_LENGTH      -26
#define  KRERR_FILE_FORMAT      -27
#define  KRERR_FILE_OPEN        -28
#define  KRERR_FILE_SYNTAX      -29
#define  KRERR_MALLOC1          -30
#define  KRERR_TTYPE            -31
#define  KRERR_SYMBOL           -32
#define  KRERR_NO_SUCH_SITE     -33
#define  KRERR_NO_HIDDEN_UNITS  -34
#define  KRERR_CYCLES           -35
#define  KRERR_DEAD_UNITS       -36
#define  KRERR_INPUT_PATTERNS   -37
#define  KRERR_OUTPUT_PATTERNS  -38
#define  KRERR_CHANGED_I_UNITS  -39
#define  KRERR_CHANGED_O_UNITS  -40
#define  KRERR_NO_INPUT_UNITS   -41
#define  KRERR_NO_OUTPUT_UNITS  -42
#define  KRERR_NO_PATTERNS      -43
#define  KRERR_INCORE_PATTERNS  -44
#define  KRERR_PATTERN_NO       -45
#define  KRERR_LEARNING_FUNC    -46
#define  KRERR_PARAMETERS       -47
#define  KRERR_UPDATE_FUNC      -48
#define  KRERR_INIT_FUNC        -49
#define  KRERR_DERIV_FUNC       -50
#define  KRERR_I_UNITS_CONNECT	-51
#define  KRERR_O_UNITS_CONNECT	-52
#define  KRERR_TOPOMODE 	-53
#define  KRERR_LEARNING_SITES   -54
#define  KRERR_SITES_NO_SUPPORT -55
#define  KRERR_NO_MASPAR_KERNEL -56
#define  KRERR_NOT_NEIGHBOUR_LAYER -57
#define  KRERR_MUCH_LAYERS      -58
#define  KRERR_NOT_FULLY_CONNECTED -59
#define  KRERR_MODE_FF1_INVALID_OP -60
#define  KRERR_NET_TRANSFORM    -61
#define  KRERR_NO_CURRENT_LINK	-62
#define  KRERR_NO_CURRENT_UNIT	-63
#define  KRERR_UNIT_NO_INPUTS	-64
#define  KRERR_TOPO_DEFINITION	-65
#define  KRERR_BAD_CONNECTION   -66
#define  KRERR_MASPAR_NO_RESPOND -67
#define  KRERR_NOT_IMPEMENTED_YET -68
#define  KRERR_NOT_PARALLEL_MODE  -69
#define  KRERR_MASPAR_OUT_OF_PE_MEM -70
#define  KRERR_MASPAR_COMMUNICATE -71
#define  KRERR_MASPAR_OUT_OF_PE   -72
#define  KRERR_MISSING_DEFAULT_FUNC  -73
#define  KRERR_MASPAR_MULTI_OUT_FUNC -74
#define  KRERR_MASPAR_MULTI_ACT_FUNC -75
#define  KRERR_NET_DEPTH        -76



/*  Function types
*/
#define  OUT_FUNC        1
#define  ACT_FUNC        2
#define  SITE_FUNC       3
#define  LEARN_FUNC      4
#define  UPDATE_FUNC     5
#define  INIT_FUNC       6
#define  ACT_DERIV_FUNC  7
#define  JOG_WEIGHT_FUNC 8
#define  DEFAULT_FUNC    0x0100
#define  BENCH_FUNC      0x0200



/*   entry types for name table
*/
#define  UNUSED_SYM         0
#define  UNIT_SYM           1
#define  SITE_SYM           2
#define  FTYPE_UNIT_SYM     3


/*  Copy Modes
*/
#define  INPUTS_AND_OUTPUTS     1
#define  ONLY_INPUTS            2
#define  ONLY_OUTPUTS           3
#define  ONLY_UNIT              4


/*  Topological Unit Types
*/
#define  UNKNOWN    0
#define  INPUT      1
#define  OUTPUT     2
#define  HIDDEN     3
#define  DUAL       4
#define  SPECIAL    5

/*  Unit Input Types
*/
#define  NO_INPUTS      0
#define  SITES          1
#define  DIRECT_LINKS   2

/*  Pattern update modes
*/
#define  OUTPUT_NOTHING  1
#define  OUTPUT_ACT      2
#define  OUTPUT_OUT      3

/*  Maximum no. of learning parameters for learning functions
*/
#define     NO_OF_LEARN_PARAMS	4


/*#################################################

GROUP: Global Var's

#################################################*/

/*  Kernel Interface Error Code
*/
#ifndef SNNS_KERNEL
extern int  KernelErrorCode;
#endif

/*#################################################

GROUP: Global Datatypes

#################################################*/

typedef int     bool;
typedef float   FlintType;
typedef int     krui_err;


#ifdef __STDC__
typedef double  FlintTypeParam;
#else
typedef float  FlintTypeParam;
#endif


#ifndef KERNEL3D

struct   PosType  {
  short  x,
	 y;
};


#else

/*#################################################

GROUP: 3D-Kernel Definitions

#################################################*/


struct   PosType  {
  short  x,
	 y,
	 z;
};


#define  NO_OF_UNIT_CENTER_POS  1

struct   PositionVector  {
  float  x,
	 y,
	 z,
	 w;
};



#define TRANS_TABLE_SIZE 0x10000
#define TRANS_TABLE_OFFSET 0x8000

struct   TransTable  {
  short  x,
	 y;
};



#endif


/*#################################################

GROUP: Constants for the parallel kernel

#################################################*/

/*  Topologic network types
*/
#define  NET_TYPE_GENERAL  0   /*  normal network presentation, no limitations  */
#define  NET_TYPE_FF1      1   /*  feedforward net with limitations  */

/*  MasPar modes
*/
#define  MASPAR_DISCONNECT  0
#define  MASPAR_CONNECT  1


#endif
