/*     @(#)kr_funcs.h	1.2 7/21/92  */

/**********************************************************************
FILE   : kr_funcs.h
PURPOSE: SNNS-Kernel: Routines for User-Function Management
		      (Function Prototypes)
NOTES  : 
AUTHOR : Niels Mache
DATE   : 12.02.90
VERSION : 1.2  7/21/92

 Copyright (c) 1990,1991,1992 by Niels Mache and the SNNS Group

**********************************************************************/

#ifdef __STDC__

krui_err  krf_getFuncInfo( int  mode, struct FuncInfoDescriptor  *func_descr );

/*  Returns the number of functions in the function table
*/
int krf_getNoOfFuncs( void );

/*  seaches for the given function (name and type) and returns a pointer to
    this function. krf_funcSearch(...) returns TRUE if the given function was
    found, FALSE otherwise.
*/
bool krf_funcSearch( char *func_name, int  func_type, FunctionPtr  *func_ptr );

/*  Returns the name of the given function
*/
char *krf_getFuncName( FunctionPtr func_ptr );

/*  returns the name of the current network function
*/
char  *krf_getCurrentNetworkFunc( int  type );

/*  sets the current network function.
*/
krui_err  krf_setCurrentNetworkFunc( char  *function_name, int  type );


#else

krui_err  krf_getFuncInfo();
int  krf_getNoOfFuncs();
bool  krf_funcSearch();
char  *krf_getFuncName();
char  *krf_getCurrentNetworkFunc();
krui_err  krf_setCurrentNetworkFunc();

#endif
