/*****************************************************************************
  FILE     : krui_inversion.h
  SHORTNAME: --

  PURPOSE  : Header file of correspondent '.c' file
  NOTES    :

  AUTHOR   : Guenter Mamier
  VERSION  : 1.0
  DATE     : 29.02.92

             (c) 1992 by Guenter Mamier and the SNNS-Group
             
******************************************************************************/


/* required functions that are declared elsewhere */

extern int kr_topoCheck();
extern int kr_IOCheck();
extern int kr_topoSort();



/* required functions that are declared here */

int    krui_initInversion();
void   krui_inv_forwardPass();
double krui_inv_backwardPass();



/* global variables for snns */

extern bool NetModified,	 /*  TRUE, if the network topology was modified  */
	    PatternsValid,	 /*  TRUE, if In-Core patterns are valid         */
            NetInitialize,       /*  TRUE, if the network has been initialized   */
            LearnFuncHasChanged; /*  TRUE, if learning function has changed      */
extern int  NoOfUnits,		 /*  no. of units in the network                 */
	    MinUnitNo,		 /*  the first used unit number in the network   */
	    MaxUnitNo,		 /*  the last used unit number in the network    */
	    TopoSortID; 	 /*  topologic mode identifier	                 */
extern TopoPtrArray 
            topo_ptr_array;      /* stores pointers to topological sorted units, */
				 /* used by kr_topoSort()                        */
extern int  no_of_topo_units;    /*  no. of unit pointers in topo_ptr_array      */



/* global variables for inversion method */

typedef struct UnitList{
    int             no;
    FlintType       act;
    FlintType       i_act;
    FlintType       im_act;
    struct PosType  gridPos;
    struct UnitList *next;
    struct UnitList *prev;
};
extern struct UnitList *inputs, 
                       *outputs;


