/*     @(#)kr_io.h	1.2 7/21/92  */

/**********************************************************************
FILE   : kr_io.h
PURPOSE: SNNS-Kernel User Interface File I/O Function Prototypes
NOTES  : 
AUTHOR : Niels Mache
DATE   : 28.05.90
VERSION : 1.2  7/21/92

 Copyright (c) 1990,1991,1992 by Niels Mache and the SNNS Group

**********************************************************************/

#ifdef __STDC__

/*  write complete network to disk
*/
krui_err  krio_saveNet( char  *filename, char  *netname );

/*  load network form disk
*/
krui_err krio_loadNet( char  *filename, char  **netname, char  **netfile_version );

/*  loading pattern file from disk
*/
krui_err krio_loadPatterns( char  *filename );

/*  write patterns to disk
*/
krui_err krio_savePatterns( char  *filename );

#ifdef KERNEL3D
/*  Function for the 3D-Kernel	*/
/*  Return the base address of the XY-Translation Table
*/
struct TransTable  *krio_getXYTransTablePtr( void );
#endif

#else

krui_err krio_saveNet();
krui_err krio_loadNet();
krui_err krio_loadPatterns();
krui_err krio_savePatterns();

#ifdef KERNEL3D
struct TransTable  *krio_getXYTransTablePtr();
#endif

#endif
