/*     @(#)kr_mac.h	1.2 7/21/92  */

/**********************************************************************
FILE   : kr_mac.h
PURPOSE: SNNS-Kernel Macros
NOTES  : 
AUTHOR : Niels Mache
DATE   : 09.12.91
VERSION : 1.2  7/21/92

 Copyright (c) 1990,1991,1992 by Niels Mache and the SNNS Group

**********************************************************************/


/*  Macro Definitions  */
#ifndef numeric
#define numeric(c)	       (c >= '0' && c <= '9')
#endif
#ifndef Max
#define Max(a,b)	       (a<b ? b : a)
#endif
#ifndef Min
#define Min(a,b)	       (a>b ? b : a)
#endif
#ifndef abs
#define abs(x)		       (x>=0 ? x : -(x))
#endif


/*  Macros for stepping thru the unit array and the site/link lists
*/
#define FOR_ALL_UNITS( unit_ptr ) \
for ((unit_ptr) = unit_array + MinUnitNo; \
     (unit_ptr) <= unit_array + MaxUnitNo; (unit_ptr)++)

#define FOR_ALL_SITES( unit_ptr, site_ptr ) \
for ((site_ptr) = (unit_ptr)->sites; (site_ptr) != NULL; \
     (site_ptr) = (site_ptr)->next)

#define FOR_ALL_SITES_AND_LINKS( unit_ptr, site_ptr, link_ptr ) \
for ((site_ptr) = (unit_ptr)->sites; (site_ptr) != NULL; \
     (site_ptr) = (site_ptr)->next) \
  for ((link_ptr) = (site_ptr)->links; (link_ptr) != NULL; \
       (link_ptr) = (link_ptr)->next)

#define FOR_ALL_LINKS( unit_ptr, link_ptr ) \
for ((link_ptr) = (struct Link *) (unit_ptr)->sites; (link_ptr) != NULL; \
     (link_ptr) = (link_ptr)->next)

#define FOR_ALL_LINKS_AT_SITE( site_ptr, link_ptr ) \
for ((link_ptr) = (site_ptr)->links; (link_ptr) != NULL; \
     (link_ptr) = (link_ptr)->next)



/*  Some useful macros to determine the input type of a given unit
*/
#define UNIT_HAS_SITES( unit_ptr ) \
((unit_ptr)->flags & UFLAG_SITES)

#define UNIT_HAS_DIRECT_INPUTS( unit_ptr ) \
((unit_ptr)->flags & UFLAG_DLINKS)

#define UNIT_HAS_INPUTS( unit_ptr ) \
((unit_ptr)->flags & UFLAG_INPUT_PAT)

#define IS_INPUT_UNIT( unit_ptr ) \
((unit_ptr)->flags & UFLAG_TTYP_IN)

#define IS_OUTPUT_UNIT( unit_ptr ) \
((unit_ptr)->flags & UFLAG_TTYP_OUT)

#define IS_HIDDEN_UNIT( unit_ptr ) \
((unit_ptr)->flags & UFLAG_TTYP_HIDD)


/*  Macro to determine if a given unit is in use or not
*/
#define UNIT_IN_USE( unit_ptr ) \
((unit_ptr)->flags & UFLAG_IN_USE)

#define UNIT_REFRESHED( unit_ptr ) \
((unit_ptr)->flags & UFLAG_REFRESH)


/*  Some macros for determine the current kernel type
*/
#define  KERNEL_STANDARD  (specialNetworkType == NET_TYPE_GENERAL)



