/*     @(#)kr_mem.h	1.2 7/21/92  */

/**********************************************************************
FILE   : kr_mem.h
PURPOSE: SNNS-Kernel Memory Manager Function Prototypes
NOTES  : 
AUTHOR : Niels Mache
DATE   : 21.2.90
VERSION : 1.2  7/21/92

 Copyright (c) 1990,1991,1992 by Niels Mache and the SNNS Group

**********************************************************************/

#ifdef __STDC__

/*  get one link structure
*/
struct Link *krm_getLink( void );

/*  release one link structure
*/
void krm_releaseLink( struct Link * link_ptr);

/*  release the link and all following links
*/
void krm_releaseAllLinks( struct Link *first_link_ptr );

/*  get one unit-site structure
*/
struct Site *krm_getSite( void );

/*  release one unit-site structure
*/
void krm_releaseSite( struct Site *site_ptr );

/*  release the unit-site and all following sites (at this unit)
*/
void krm_releaseAllSites( struct Site *first_site_ptr );

/*  garbage collection of unit array  
*/
void  krm_unitArrayGC( void );

/*  allocate the unit array
*/
krui_err krm_allocUnits( int  N );

/*  get one unit structure
*/
int krm_getUnit( void );

/*  release unit
*/
void krm_releaseUnit( int  UnitNo );

/*  get information about memory usage
*/
void krm_getMemoryManagerInfo( int  *array_size, int info_array[] );

/*  allocate the array for topological sorting of the units in the network
*/
krui_err  krm_allocUnitTopoArray( int  N );

/*  release the topolocic array
*/
void  krm_releaseUnitTopoArray( void );

/*  allocate arrays for storing pattern pairs
*/
krui_err krm_allocPatternArrays( int  N );

/*  allocate one pattern pair
*/
krui_err krm_newPattern( void );

/*  delete one pattern pair
*/
krui_err krm_deletePatternPair( int  pat_no );

/*  release pattern arrays
*/
void krm_releasePatternArrays( void );

/*  allocate array for shuffeling pattern numbers
*/
krui_err krm_allocPatternNoArray( void );

/*  release pattern number array
*/
void krm_releasePatternNumbers( void );

/*  release one name-table entry
*/
void krm_NTableReleaseEntry( struct NameTable  *NTable_ptr );

/*  Searches for a given symbol and symbol-type in the name table.
    Returns symbol ptr if symbol was found, NULL otherwise. 
*/
struct NameTable *krm_NTableSymbolSearch( char  *symbol, int  sym_type );

/*  Creates a new symbol in the name-table.   Returns name-table ptr or NULL if
    memory alloc has failed.    
*/
struct NameTable *krm_NTableCreateEntry( char  *symbol_name, int  symbol_type );

/*  Inserts a symbol in the name-table. This function duplicates symbol ptrs
    if the symbol was found in the name-table.  Returns symbol ptr or NULL if
    memory alloc has failed.
*/
char *krm_NTableInsertSymbol( char  *symbol_name, int  symbol_type );

/*  release name-table entry if there is no other reference to this symbol
*/
void krm_NTableReleaseSymbol( char  *symbol_name, int  symbol_type );

/*  get the first name-table entry
*/
struct NameTable *krm_getNTableFirstEntry( void );

/*  get the next name-table entry
*/
struct NameTable *krm_getNTableNextEntry( void );

/*  create new site-table entry
*/
struct SiteTable *krm_STableCreateEntry( char  *site_symbol, SiteFuncPtr  site_func );

/*  change the properties of the given site-table entry
*/
struct SiteTable *krm_STableChangeEntry( struct  SiteTable  *stbl_ptr, char  *new_site_name,
                                         SiteFuncPtr  new_site_func );

/*  release a previosly defined site-table entry
*/
void krm_STableRemoveEntry( struct SiteTable  *STable_ptr );

/*  searches for a symbol in the site-table
*/
struct SiteTable *krm_STableSymbolSearch( char  *site_symbol );

/*  returns a pointer to the first used site-table entry
*/
struct SiteTable *krm_getSTableFirstEntry( void );

/*  returns a pointer to the next used site-table entry
*/
struct SiteTable *krm_getSTableNextEntry( void );

/*  allocate a new Ftype entry
*/
struct FtypeUnitStruct *krm_getFtypeEntry( void );

/*  free a previosly defined Ftype entry
*/
void krm_releaseFtypeEntry( struct FtypeUnitStruct  *Ftype_entry );

/*  create and define a Ftype entry
*/
struct FtypeUnitStruct *krm_FtypeCreateEntry( char *Ftype_symbol, OutFuncPtr out_func, 
                                              ActFuncPtr act_func, ActDerivFuncPtr act_deriv_func );

/*  add a site to a previosly defined Ftype entry
*/
struct Site *krm_FtypeAddSite( struct FtypeUnitStruct  *Ftype_entry, struct SiteTable  *STable_entry );

/*  returns a pointer to first Ftype entry
*/
struct FtypeUnitStruct *krm_getFtypeFirstEntry( void );

/*  returns a pointer to next Ftype entry
*/
struct FtypeUnitStruct *krm_getFtypeNextEntry( void );

/*  searches for a Ftype entry with the given name
*/
struct FtypeUnitStruct *krm_FtypeSymbolSearch( char  *Ftype_symbol );

/*  releases all Ftype entries
*/
void krm_releaseFtypeList( void );

/*  free all link arrays
*/
void  krm_releaseLinkArrays( void );


/*  Functions for the MasPar kernel  */
#ifdef MASPAR_KERNEL
#ifdef MASPAR_KERNEL_EMULATION

/*  release weight arrays from memory
*/
void  krm_releaseWeightArrays( void );

/*  creates arrays containing connection weights for feedforward networks
*/
krui_err  krm_createWeightArrays( void );

#endif
#endif


/*  frees all memory used for the internal representation of the network
*/
void krm_releaseMem( void );

#else

struct Link *krm_getLink();
void krm_releaseLink();
void krm_releaseAllLinks();
struct Site *krm_getSite();
void krm_releaseSite();
void krm_releaseAllSites();
void  krm_unitArrayGC();
krui_err krm_allocUnits();
int krm_getUnit();
void krm_releaseUnit();
void krm_getMemoryManagerInfo();
krui_err  krm_allocUnitTopoArray();
void  krm_releaseUnitTopoArray();

krui_err krm_allocPatternArrays();
krui_err krm_newPattern();
krui_err krm_deletePatternPair();
void krm_releasePatternArrays();
krui_err  krm_allocPatternNoArray();
void krm_releasePatternNumbers();

void krm_NTableReleaseEntry();
struct NameTable *krm_NTableSymbolSearch();
struct NameTable *krm_NTableCreateEntry();
char *krm_NTableInsertSymbol();
void krm_NTableReleaseSymbol();
struct NameTable *krm_getNTableFirstEntry();
struct NameTable *krm_getNTableNextEntry();
struct SiteTable *krm_STableCreateEntry();
struct SiteTable *krm_STableChangeEntry();
void krm_STableRemoveEntry();
struct SiteTable *krm_STableSymbolSearch();
struct SiteTable *krm_getSTableFirstEntry();
struct SiteTable *krm_getSTableNextEntry();
struct FtypeUnitStruct *krm_getFtypeEntry();
void krm_releaseFtypeEntry();
struct FtypeUnitStruct *krm_FtypeCreateEntry();
struct Site *krm_FtypeAddSite();
struct FtypeUnitStruct *krm_getFtypeFirstEntry();
struct FtypeUnitStruct *krm_getFtypeNextEntry();
struct FtypeUnitStruct *krm_FtypeSymbolSearch();
void krm_releaseFtypeList();
void  krm_releaseLinkArrays();

#ifdef MASPAR_KERNEL
#ifdef MASPAR_KERNEL_EMULATION

void  krm_releaseWeightArrays();
krui_err  krm_createWeightArrays();

#endif
#endif

void krm_releaseMem();

#endif
