/*     @(#)kr_ui.h	1.2 7/21/92  */

/**********************************************************************
FILE   : kr_ui.h
PURPOSE: SNNS-Kernel User Interface Function Prototypes
NOTES  : 
AUTHOR : Niels Mache
DATE   : 27.02.90
VERSION : 1.2  7/21/92

 Copyright (c) 1990,1991,1992 by Niels Mache and the SNNS Group

**********************************************************************/
/*
#ifdef __MSDOS__

#ifndef  int
#define  int long
#endif

#endif
*/

#ifdef __STDC__

#include "krui_typ.h"	/*  Interface function prototypes  */

#else

int krui_getNoOfUnits();
int krui_getFirstUnit();
int krui_getNextUnit();
int krui_getCurrentUnit();
krui_err  krui_setCurrentUnit();
char *krui_getUnitName();
krui_err  krui_setUnitName();
int krui_searchUnitName();
int krui_searchNextUnitName();
char *krui_getUnitOutFuncName();
krui_err  krui_setUnitOutFunc();
char *krui_getUnitActFuncName();
krui_err  krui_setUnitActFunc();
char *krui_getUnitFTypeName();
float krui_getUnitActivation();
void krui_setUnitActivation();
float krui_getUnitInitialActivation();
void krui_setUnitInitialActivation();
float krui_getUnitOutput();
krui_err  krui_setUnitOutput();
float krui_getUnitBias();
void krui_setUnitBias();
int krui_getUnitSubnetNo();
void krui_setUnitSubnetNo();
unsigned short krui_getUnitLayerNo();
void krui_setUnitLayerNo();
void krui_getUnitPosition();
void krui_setUnitPosition();
int krui_getUnitNoAtPosition();
int krui_getUnitNoNearPosition();
int krui_getUnitTType();
krui_err  krui_setUnitTType();
krui_err krui_freezeUnit();
krui_err krui_unfreezeUnit();
bool  krui_isUnitFrozen();
int krui_getUnitInputType();
int krui_createDefaultUnit();
int krui_createUnit();
krui_err  krui_deleteUnit();
int krui_createFTypeUnit();
krui_err  krui_setUnitFType();
int krui_copyUnit();
krui_err  krui_setFirstFTypeEntry();
krui_err  krui_setNextFTypeEntry();
krui_err  krui_setFTypeEntry();
char *krui_getFTypeName();
krui_err  krui_setFTypeName();
char *krui_getFTypeActFuncName();
krui_err  krui_setFTypeActFunc();
char *krui_getFTypeOutFuncName();
krui_err  krui_setFTypeOutFunc();
bool  krui_setFirstFTypeSite();
bool  krui_setNextFTypeSite();
char *krui_getFTypeSiteName();
krui_err  krui_setFTypeSiteName();
krui_err  krui_createFTypeEntry();
krui_err  krui_deleteFTypeEntry();
int krui_getNoOfFunctions();
void krui_getFuncInfo();
bool  krui_isFunction();
bool  krui_getFirstSiteTableEntry();
bool  krui_getNextSiteTableEntry();
char *krui_getSiteTableFuncName();
krui_err  krui_createSiteTableEntry();
krui_err  krui_changeSiteTableEntry();
krui_err  krui_deleteSiteTableEntry();
bool  krui_setFirstSite();
bool  krui_setNextSite();
krui_err  krui_setSite();
float krui_getSiteValue();
char *krui_getSiteName();
krui_err  krui_setSiteName();
char *krui_getSiteFuncName();
krui_err  krui_addSite();
bool krui_deleteSite();
int krui_getFirstPredUnit();
int krui_getNextPredUnit();
int krui_getCurrentPredUnit();
int krui_getFirstSuccUnit();
int krui_getNextSuccUnit();
int krui_getCurrentSuccUnit();
bool  krui_isConnected();
bool  krui_areConnected();
float krui_getLinkWeight();
void krui_setLinkWeight();
krui_err krui_createLink();
krui_err krui_deleteLink();
krui_err krui_deleteAllInputLinks();
krui_err krui_deleteAllOutputLinks();

void krui_jogWeights();
char  *krui_getUpdateFunc();
krui_err  krui_setUpdateFunc();
krui_err  krui_updateSingleUnit();
krui_err  krui_updateNet();
krui_err  krui_testNet();

char  *krui_getInitialisationFunc();
krui_err  krui_setInitialisationFunc();
krui_err  krui_initializeNet();

char *krui_getLearnFunc();
krui_err  krui_setLearnFunc();
krui_err  krui_learnAllPatterns();
krui_err  krui_learnSinglePattern();

krui_err  krui_showPattern();
krui_err  krui_newPattern();
krui_err  krui_setPatternNo();
krui_err  krui_deletePattern();
krui_err  krui_modifyPattern();
void krui_deleteAllPatterns();
krui_err  krui_shufflePatterns();
krui_err  krui_newVectorPatternPair();
krui_err  krui_getPatternArrays();
krui_err  krui_allocatePatterns();

krui_err  krui_saveNet();
krui_err  krui_loadNet();
krui_err  krui_loadPatterns();
krui_err  krui_savePatterns();
krui_err  krui_saveResult();
krui_err  krui_allocateUnits();
void krui_deleteNet();
bool  krui_getFirstSymbolTableEntry();
bool  krui_getNextSymbolTableEntry();
bool  krui_symbolSearch();
char *krui_getVersion();
void krui_getNetInfo();
void krui_getMemoryManagerInfo();
void krui_getUnitDefaults();
krui_err  krui_setUnitDefaults();
void krui_resetNet();
void krui_setSeedNo();
int krui_getNoOfInputUnits();
int krui_getNoOfOutputUnits();
int krui_getNoOfTTypeUnits();
int krui_getNoOfPatterns();

int krui_getXYTransTable();
int krui_getUnitCenters();
int krui_setUnitCenters();

char *krui_error();

#ifdef MASPAR_KERNEL

krui_err  krui_MasPar();
int  krui_getMasParStatus();

#endif

krui_err  krui_setSpecialNetworkType();
int  krui_getSpecialNetworkType();


#endif

/*
#ifdef __MSDOS__

#ifndef  KR_TYPES
#undef  int
#endif

#endif
*/
