/*     @(#)netperf.c	1.2 7/21/92  */

/**********************************************************************
FILE   : netperf.c
PURPOSE: SNNS-Kernel Performance Test Program
NOTES  : 
AUTHOR : Niels Mache
DATE   : 30.07.90
VERSION : 1.2  7/21/92

 Copyright (c) 1990,1991,1992 by Niels Mache and the SNNS Group

**********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#ifndef  __BORLANDC__
#include <sys/param.h>
#include <sys/types.h>
#include <sys/times.h>
#include <sys/utsname.h>
#endif


/*  SNNS-Kernel constants and data type definitions  */
#include "glob_typ.h"
/*  SNNS-Kernel User-Interface Function Prototypes   */
#include "kr_ui.h"



static void  errChk( err_code )
int  err_code;
{
  if (err_code != KRERR_NO_ERROR)  {
    printf( "%s\n", krui_error( err_code ));
    exit( 1 );
  }
}


int main()
{
  int	ret_code, N, i, j, no_of_sites, no_of_links, no_of_units,
	no_of_patterns, dummy, step, NoOfReturnVals, no_of_input_params,
	no_of_output_params, choose_me;
  double  cpu_time;
  char	*netname, file_name[80];
  float learn_parameters[5];
  float *return_values;
#ifdef  __BORLANDC__
  clock_t  init_time;
#else
  struct tms  tp;
  long  HZ_value;
  long init_time;
#endif


#ifndef  __BORLANDC__
  /*  get HZ value  */
  if ((getenv( "HZ" ) == NULL) ||
      (sscanf( getenv( "HZ" ), "%d", &HZ_value ) != 1))  {
#ifndef HZ
    fprintf( stderr, "****  WARNING: No HZ defined!\n" );
    HZ_value = 60;
#else
    HZ_value = HZ;
#endif
  }
#endif


  printf( "\n%s\n", krui_getVersion() );
  printf( "-----  Benchmark Test  -----\n\n" );

  printf("Filename of the network file: ");
  scanf("%s", file_name);

  printf( "Loading the network ...\n\n" );
  ret_code = krui_loadNet( file_name, &netname );
  errChk( ret_code );
  krui_getNetInfo( &no_of_sites, &no_of_links, &dummy, &dummy );
  no_of_units = krui_getNoOfUnits();
  printf( "Network name: %s\n", netname );
  printf( "No. of units       : %d\n", no_of_units );
  printf( "No. of input units : %d\n", krui_getNoOfTTypeUnits( INPUT ) );
  printf( "No. of output units: %d\n", krui_getNoOfTTypeUnits( OUTPUT ) );
  printf( "No. of sites: %d\n", no_of_sites );
  printf( "No. of links: %d\n\n", no_of_links );
  printf( "Learning function: %s\n", krui_getLearnFunc() );
  printf( "Update function  : %s\n", krui_getUpdateFunc() );

  printf("\nDo you want to benchmark\nPropagation [1] or\nBackpropagation [2] ?\nInput: ");
  scanf( "%d", &choose_me );
  
  if (choose_me == 1)  {
    printf( "\nChoose no. of cycles: " );
    scanf("%d", &N);
    if (N <= 0)  {
       printf( "\nInvalid no. of cycles !\n" );
       exit( 1 );
    }

    no_of_patterns = 1;
    printf( "\nBegin propagation ...\n" );

#ifdef  __BORLANDC__
    init_time = clock();
#else
    (void) times( &tp );
    init_time = tp.tms_utime;
#endif

    for (i = 0; i < N; i++)  {
      ret_code = krui_updateNet( learn_parameters, 0 );
      errChk( ret_code );
    }
  }
  else  {
    printf( "\nFilename of the pattern file: " );
    scanf( "%s", file_name );
    printf( "Loading the patterns ...\n\n" );
    ret_code = krui_loadPatterns( file_name );
    errChk( ret_code );

    no_of_patterns = krui_getNoOfPatterns();
    printf( "No. of patterns: %d\n", no_of_patterns );

    /*  determine the no. of parameters of the current learning function
    */
    (void) krui_getFuncParamInfo( krui_getLearnFunc(), LEARN_FUNC,
	  			&no_of_input_params, &no_of_output_params );
    printf( "\nThe learning function '%s' needs %d input parameters:\n",
	  krui_getLearnFunc(), no_of_input_params );
    for (i = 0; i < no_of_input_params; i++)  {
       printf( "Parameter [%d]: ", i + 1 );
       scanf( "%f", &learn_parameters[ i ] );
    }


    printf( "\nChoose no. of cycles: " );
    scanf("%d", &N);
    if (N <= 0)  {
       printf( "\nInvalid no. of cycles !\n" );
       exit( 1 );
    }

    printf( "\nBegin learning ...\n" );

    step = ((N - 1) / 10) + 1;

#ifdef  __BORLANDC__
    init_time = clock();
#else
    (void) times( &tp );
    init_time = tp.tms_utime;
#endif

    for (i = 0; i < N; i++)  {
/*  REMEMBER:  return_values[ 0 ] returns the current net error
               learn_parameters[ 0 ] contains the learning parameter (backpropagation)
*/
      ret_code = krui_learnAllPatterns( learn_parameters, 1, &return_values, &NoOfReturnVals );
      errChk( ret_code );

      /*  print the return values of the learning function  */
      if ((i % step == 0) || i == (N - 1))  {
        printf( "\nCycle: %d\nLearning function value(s): ", i + 1 );
        for (j = 0; j < NoOfReturnVals; j++ )
	  printf( "[%d]: %f  ", j + 1, return_values[ j ] );
        printf( "\n" );
      }
    }
  }


#ifdef  __BORLANDC__
  cpu_time = (double) (clock() - init_time) / (double) CLK_TCK;
#else
  (void) times( &tp );
  cpu_time = (double) (tp.tms_utime - init_time) / (double) HZ_value;
#endif

  printf( "\n\nNo. of units updated: %.0f\n", (double) no_of_units * (double) N * (double) no_of_patterns );
  printf( "No. of sites updated: %.0f\n", (double) no_of_sites * (double) N * (double) no_of_patterns);
  printf( "No. of links updated: %.0f\n", (double) no_of_links * (double) N * (double) no_of_patterns);
  printf( "CPU Time used: %.2f seconds\n", cpu_time );

  if (choose_me == 1)  {
    printf( "\nNo. of connection per second (CPS): %.4e\n",
           ((double) no_of_links * (double) N ) /
           cpu_time );
  }
  else  {
    printf( "\nNo. of connection updates per second (CUPS or WUPS): %.4e\n",
           ((double) no_of_links * (double) N * (double) no_of_patterns) / 
           cpu_time );
  }

  /*  before exiting: delete network  */
  krui_deleteNet();

  return( 0 );
}
