/*     @(#)strdup.c	1.2 7/21/92  */

/**********************************************************************
FILE   : strdup.c
PURPOSE: System V Library Function strdup.
NOTES  : The strdup function is missing in the ULTRIX-32 operating system
         environment.
AUTHOR : Niels Mache
DATE   : 30.07.90
VERSION : 1.2  7/21/92

 Copyright (c) 1990,1991,1992 by Niels Mache and the SNNS Group

**********************************************************************/

#ifdef __BORLANDC__
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#ifndef strdup
#define  strdup  bsd_strdup
#endif

#else

#include <sys/types.h>
#include <stddef.h>
#include <string.h>
#include <memory.h>

#endif

static char *strdup( str )
char *str;
{
	int len;
	char *copy;

        len = strlen( str ) + 1;
#ifdef  __BORLANDC__
        if (!(copy = malloc((size_t)len)))
                return((char *)NULL);
        memcpy(copy, str, (size_t)len);
#else
	if (!(copy = malloc((u_int)len)))
                return((char *)NULL);
	bcopy(str, copy, len);
#endif
	return(copy);
}
