/*****************************************************************************
  FILE     : bn_bignet.c

  PURPOSE  : Creates the BIGNET-window.
  FUNCTIONS: 
  NOTES    : Part of the program bignet.

  AUTHOR   : Michael Schmalzl
  DATE     : 20.12.1991

             (c) 1992 by Michael Schmalzl and the SNNS-Group
             
******************************************************************************/



#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Scrollbar.h>

#include "ui_xWidgets.h"


#include "enter.xbm"
#include "delete.xbm"
#include "insert.xbm"
#include "plane_to_edit.xbm"
#include "type.xbm"
#include "pos.xbm"
#include "overwrite.xbm"
#include "link_to_edit.xbm"
#include "create_net.xbm"
#include "full_connection.xbm"
#include "shortcut_connection.xbm"
#include "cancel.xbm"
#include "next.xbm"
#include "prev.xbm"
#include "first.xbm"
#include "last.xbm"
#include "done.xbm"


#define bn_fontWidth 8

int bignet_widget_open = 0;

int bn_intWidth = 6 * bn_fontWidth;

extern Widget ui_toplevel;
extern Display *ui_display;


Widget baseWidget;
Widget z1s1,z1s2,z1s3,z2s1,z3s1,z4s1,z5s1,z6s1,z7s1;

Widget z2s2,z2s3,z3s2,z3s3,z4s2,z4s3,
       z5s2,z5s3,z6s2,z6s3,z7s2,z7s3;


Widget z8s2,z8s3,z9s1,z9s2,z9s3,z9s4,z10s1,z11s1,z12s1,z13s1,z14s1,z15s1,z16s1,z17s1;
Widget z18s1,z19s1,z20s1,z21s1,z22s1,z23s1;

Widget z10s2,z10s3,z10s4,z10s5,z13s2,z13s3,z13s4,z13s5,z14s2,z14s3,z14s4,z14s5;
Widget z15s2,z15s3,z15s4,z15s5,z16s2,z16s3,z16s4,z16s5,z17s2,z17s3,z17s4,z17s5;
Widget z18s2,z18s3,z18s4,z18s5,z19s2,z19s3,z19s4,z19s5,z20s2,z20s3,z20s4,z20s5;
Widget z22s2,z22s3,z22s4,z22s5,z23s2,z23s3,z23s4,z23s5;

#include "glob_typ.h"

#ifdef ANSI_CC
#include "krui_typ"
#else
#include "kr_ui.h"
#endif

#include "bn_types.c"
#include "bn_plane.c"
#include "bn_link.c"
#include "bn_create_net.c"


/*****************************************************************************
  FUNCTION : bn_xCreateButtonItem

  PURPOSE  : create a command widget
  NOTES    :

  UPDATE   : 20.12.1991
******************************************************************************/


Widget bn_xCreateButtonItem (name, parent, left, top)

    char       *name;
    Widget     parent;
    Widget     left, top;
    
{
    int n;
    Widget   w;
    Arg	     arg[15];
    
    n = 0;
    if (strcmp (name, "enter") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   enter_bits, enter_width, enter_height)); n++;
      } 
    if (strcmp (name, "prev") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   prev_bits, prev_width, prev_height)); n++;
      } 
    if (strcmp (name, "next") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   next_bits, next_width, next_height)); n++;
      } 
    if (strcmp (name, "first") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   first_bits,first_width,first_height)); n++;
      } 
    if (strcmp (name, "last") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   last_bits,last_width,last_height)); n++;
      } 
    if (strcmp (name, "delete") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   delete_bits,delete_width,delete_height)); n++;
      } 
    if (strcmp (name, "insert") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   insert_bits,insert_width,insert_height)); n++;
      } 
    if (strcmp (name, "overwrite") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   overwrite_bits,overwrite_width,overwrite_height)); n++;
      } 
    if (strcmp (name, "plane_to_edit") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   plane_to_edit_bits,plane_to_edit_width,plane_to_edit_height)); n++;
      } 
    if (strcmp (name, "type") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   type_bits,type_width,type_height)); n++;
      } 
    if (strcmp (name, "pos") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   pos_bits,pos_width,pos_height)); n++;
      } 
    if (strcmp (name, "link_to_edit") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   link_to_edit_bits,link_to_edit_width,link_to_edit_height)); n++;
      } 
    if (strcmp (name, "full_connection") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   full_connection_bits,full_connection_width,full_connection_height)); n++;
      } 
    if (strcmp (name, "shortcut_connection") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   shortcut_connection_bits,shortcut_connection_width,shortcut_connection_height)); n++;
      } 
    if (strcmp (name, "done") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   done_bits,done_width,done_height)); n++;
      } 
    if (strcmp (name, "cancel") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   cancel_bits,cancel_width,cancel_height)); n++;
      } 
    if (strcmp (name, "create_net") == 0)
      {  
        XtSetArg(arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   create_net_bits,create_net_width,create_net_height)); n++;
      } 
    XtSetArg(arg[n], XtNborderWidth, 0); n++;
    XtSetArg(arg[n], XtNinternalHeight, 1); n++;
    XtSetArg(arg[n], XtNinternalWidth , 1); n++;

    XtSetArg(arg[n], XtNfromVert , top);  n++;
    XtSetArg(arg[n], XtNfromHoriz, left);  n++;
    XtSetArg(arg[n], XtNleft  , XtChainLeft); n++;
    XtSetArg(arg[n], XtNright , XtChainLeft); n++;
    XtSetArg(arg[n], XtNtop   , XtChainTop); n++;
    w = XtCreateManagedWidget(name, commandWidgetClass, parent, arg, n);
    return(w);

}




/*****************************************************************************
  FUNCTION : bn_createPlanePanel

  PURPOSE  : creates the plane panel, which is part of the bignet-window
  NOTES    :

  UPDATE   : 20.12.1991
******************************************************************************/



void bn_createPlanePannel (parent)

    Widget parent;

{
    Widget box,pannel;
    Widget plane_edit,current_plane;
    Widget plane_enter,plane_delete,plane_insert,plane_overwrite,plane_to_edit,type,pos;
    Widget plane_first,plane_last,plane_prev,plane_next;
    Widget       dummy;
    Arg          arg[25];
    Cardinal     n;
    char         buf[40];
    int colom1 = 25, colom2 = 13, colom3 = 10;
    
    n = 0;  

    pannel = XtCreateManagedWidget ("pannel", formWidgetClass, parent, arg, n);

    z1s1 = ui_xCreateLabelItem ("           Plane           ", pannel, colom1 * bn_fontWidth, NULL, NULL); 
    z1s2 = ui_xCreateLabelItem ("Current Plane  ", pannel, colom2 * bn_fontWidth, z1s1, NULL); 
    z1s3 = ui_xCreateLabelItem ("Edit Plane  ", pannel, colom3 * bn_fontWidth, z1s2, NULL); 

    z2s1   = ui_xCreateLabelItem ("Plane: ", pannel, colom1 * bn_fontWidth, NULL, z1s1); 
    dummy = ui_xCreateLabelItem (" ", pannel, 3 * bn_fontWidth, z2s1, z1s1); 
    z2s2   = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z1s1);

    z3s1  = ui_xCreateLabelItem ("Type: ",pannel,colom1 * bn_fontWidth,NULL,z2s1); 
    dummy = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z3s1,z2s1); 
    z3s2  = ui_xCreateFrameLabelItem ("",pannel,bn_intWidth,dummy,z2s1);
    dummy = ui_xCreateLabelItem (" ",pannel,5 * bn_fontWidth,z3s2,z2s1);
    z3s3  = ui_xCreateFrameLabelItem (plane_type[PLANE_type],pannel,bn_intWidth,dummy,z2s1);

    z4s1  = ui_xCreateLabelItem ("No. of units in x-direction: ",pannel,colom1 * bn_fontWidth,NULL,z3s1); 
    dummy = ui_xCreateLabelItem (" ", pannel, 3 * bn_fontWidth,z4s1,z3s1); 
    z4s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z3s1);
    dummy = ui_xCreateLabelItem (" ", pannel, 5 * bn_fontWidth,z4s2,z3s1); 
    z4s3  = ui_xCreateDialogItem ("z4s3", pannel,"",bn_intWidth,dummy,z3s1);
 
    z5s1  = ui_xCreateLabelItem ("No. of units in y-direction: ",pannel,colom1 * bn_fontWidth,NULL,z4s1); 
    dummy = ui_xCreateLabelItem (" ", pannel, 3 * bn_fontWidth,z5s1,z4s1); 
    z5s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z4s1);
    dummy = ui_xCreateLabelItem (" ", pannel, 5 * bn_fontWidth,z5s2,z4s1); 
    z5s3  = ui_xCreateDialogItem ("z4s3", pannel, "",bn_intWidth,dummy,z4s1);
 

    z6s1  = ui_xCreateLabelItem ("z-coordinates of the plane: ",pannel,colom1 * bn_fontWidth,NULL,z5s1); 
    dummy = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z6s1,z5s1); 
    z6s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z5s1);
    dummy = ui_xCreateLabelItem (" ",pannel,5 * bn_fontWidth,z6s2,z5s1); 
    z6s3  = ui_xCreateDialogItem ("z4s3",pannel,"",bn_intWidth,dummy,z5s1);
 
    z7s1  = ui_xCreateLabelItem ("Rel. Position: ",pannel,colom1 * bn_fontWidth,NULL,z6s1); 
    dummy = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z7s1,z6s1); 
    z7s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z6s1);
    dummy = ui_xCreateLabelItem (" ",pannel,5 * bn_fontWidth,z7s2,z6s1);
    z7s3  = ui_xCreateFrameLabelItem (plane_pos[PLANE_pos],pannel,bn_intWidth,dummy,z6s1);

    dummy         = ui_xCreateLabelItem (" ",pannel,15 * bn_fontWidth,NULL,z7s1); 
    
    plane_edit = ui_xCreateLabelItem ("Edit Plane: ",pannel,15 * bn_fontWidth,NULL,dummy); 
    plane_enter      = bn_xCreateButtonItem ("enter",pannel,plane_edit,dummy);
      XtAddCallback(plane_enter,XtNcallback,enter_plane_PROC,NULL);
    plane_insert     = bn_xCreateButtonItem ("insert",pannel,plane_enter,dummy);
      XtAddCallback(plane_insert,XtNcallback,insert_plane_PROC,NULL);
    plane_overwrite  = bn_xCreateButtonItem ("overwrite",pannel,plane_insert,dummy);
      XtAddCallback(plane_overwrite,XtNcallback,overwrite_plane_PROC,NULL);
    plane_delete     = bn_xCreateButtonItem ("delete",pannel,plane_overwrite,dummy);
      XtAddCallback(plane_delete,XtNcallback,delete_plane_PROC,NULL);

    dummy         = ui_xCreateLabelItem (" ",pannel,15 * bn_fontWidth,NULL,plane_edit); 
    plane_to_edit = bn_xCreateButtonItem ("plane_to_edit",pannel,dummy,plane_edit);
      XtAddCallback(plane_to_edit,XtNcallback,current_plane_to_editor_PROC,NULL);
    type          = bn_xCreateButtonItem ("type",pannel,plane_to_edit,plane_edit);
      XtAddCallback(type,XtNcallback,type_PROC,NULL);
    pos           = bn_xCreateButtonItem ("pos",pannel,type,plane_edit);
      XtAddCallback(pos,XtNcallback,pos_PROC,NULL);

    current_plane = ui_xCreateLabelItem ("Current plane: ",pannel,15 * bn_fontWidth,NULL,dummy); 
    plane_first         = bn_xCreateButtonItem ("first",pannel,current_plane,dummy);
      XtAddCallback(plane_first,XtNcallback,beginning_plane_PROC,NULL);
    plane_prev          = bn_xCreateButtonItem ("prev",pannel,plane_first,dummy);
      XtAddCallback(plane_prev,XtNcallback,backward_plane_PROC,NULL);
    plane_next          = bn_xCreateButtonItem ("next",pannel,plane_prev,dummy);
      XtAddCallback(plane_next,XtNcallback,forward_plane_PROC,NULL);
    plane_last          = bn_xCreateButtonItem ("last",pannel,plane_next,dummy);
      XtAddCallback(plane_last,XtNcallback,end_plane_PROC,NULL);
}



/*****************************************************************************
  FUNCTION : bn_createLinkPanel

  PURPOSE  : creates the link panel, which is part of the bignet-window
  NOTES    :

  UPDATE   : 20.12.1991
******************************************************************************/


void bn_createLinkPannel (parent)

    Widget parent;

{
    Arg		args[10];
    Widget pannel,box;
    Widget dummy,dummy1,dummy2;
    Widget link_edit,current_link;
    Widget link_enter,link_delete,link_overwrite,link_to_edit,full_connection,shortcut_connection;
    Widget link_first,link_last,link_prev,link_next;
    Widget create_net,exit,cancel;
    Arg          arg[25];
    Cardinal     n;
    char         buf[20];
  
    n = 0;  

    pannel = XtCreateManagedWidget ("pannel", formWidgetClass, parent, arg, n);



    dummy1 = ui_xCreateLabelItem (" ",pannel,15 * bn_fontWidth,NULL,NULL); 
    z8s2   = ui_xCreateLabelItem (" Current Link ", pannel,14*bn_fontWidth,dummy1,NULL); 
    z8s3   = ui_xCreateLabelItem ("       Edit Link", pannel,16*bn_fontWidth,z8s2,NULL); 

    dummy2 = ui_xCreateLabelItem (" ",pannel,15 * bn_fontWidth,NULL,dummy1); 
    z9s1   = ui_xCreateLabelItem ("Source", pannel,8*bn_fontWidth,dummy2,dummy1); 
    z9s2   = ui_xCreateLabelItem ("Target", pannel,8*bn_fontWidth,z9s1,dummy1); 
    z9s3   = ui_xCreateLabelItem ("  Source", pannel,8*bn_fontWidth,z9s2,dummy1); 
    z9s4   = ui_xCreateLabelItem (" Target", pannel,8*bn_fontWidth,z9s3,dummy1); 

    z10s1  = ui_xCreateLabelItem ("Plane", pannel,15*bn_fontWidth,NULL,dummy2); 
    z10s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,z10s1,dummy2);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z10s2,dummy2); 
    z10s3  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,dummy2);
    dummy  = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z10s3,dummy2); 
    z10s4  = ui_xCreateDialogItem ("z10s4", pannel,"",bn_intWidth,dummy,dummy2);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z10s4,dummy2); 
    z10s5  = ui_xCreateDialogItem ("z10s5", pannel, "",bn_intWidth,dummy,dummy2);

    z11s1  = ui_xCreateLabelItem ("Cluster", pannel,15*bn_fontWidth,NULL,z10s1); 

    z12s1  = ui_xCreateLabelItem ("  Coordinates", pannel,15*bn_fontWidth,NULL,z11s1); 

    z13s1  = ui_xCreateLabelItem ("        x:", pannel,15*bn_fontWidth,NULL,z12s1); 
    z13s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,z13s1,z12s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z13s2,z12s1); 
    z13s3  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z12s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z13s3,z12s1); 
    z13s4  = ui_xCreateDialogItem ("z13s4", pannel, "",bn_intWidth,dummy,z12s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z13s4,z12s1); 
    z13s5  = ui_xCreateDialogItem ("z13s5", pannel, "",bn_intWidth,dummy,z12s1);

    z14s1  = ui_xCreateLabelItem ("        y:", pannel,15*bn_fontWidth,NULL,z13s1); 
    z14s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,z14s1,z13s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z14s2,z13s1); 
    z14s3  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z13s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z14s3,z13s1); 
    z14s4  = ui_xCreateDialogItem ("z14s4", pannel, "",bn_intWidth,dummy,z13s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z14s4,z13s1); 
    z14s5  = ui_xCreateDialogItem ("z14s5", pannel, "",bn_intWidth,dummy,z13s1);

    z15s1  = ui_xCreateLabelItem ("   width :", pannel,15*bn_fontWidth,NULL,z14s1); 
    z15s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,z15s1,z14s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z15s2,z14s1); 
    z15s3  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z14s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z15s3,z14s1); 
    z15s4  = ui_xCreateDialogItem ("z15s4", pannel, "",bn_intWidth,dummy,z14s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z15s4,z14s1); 
    z15s5  = ui_xCreateDialogItem ("z15s5", pannel, "",bn_intWidth,dummy,z14s1);

    z16s1  = ui_xCreateLabelItem ("   height:", pannel,15*bn_fontWidth,NULL,z15s1); 
    z16s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,z16s1,z15s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z16s2,z15s1); 
    z16s3  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z15s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z16s3,z15s1); 
    z16s4  = ui_xCreateDialogItem ("z16s4", pannel, "",bn_intWidth,dummy,z15s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z16s4,z15s1); 
    z16s5  = ui_xCreateDialogItem ("z16s5", pannel, "",bn_intWidth,dummy,z15s1);

    z17s1  = ui_xCreateLabelItem ("Unit", pannel,15*bn_fontWidth,NULL,z16s1); 

    z18s1  = ui_xCreateLabelItem ("  Coordinates", pannel,15*bn_fontWidth,NULL,z17s1); 

    z19s1  = ui_xCreateLabelItem ("        x:", pannel,15*bn_fontWidth,NULL,z18s1); 
    z19s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,z19s1,z18s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z19s2,z18s1); 
    z19s3  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z18s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z19s3,z18s1); 
    z19s4  = ui_xCreateDialogItem ("z19s4", pannel, "",bn_intWidth,dummy,z18s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z19s4,z18s1); 
    z19s5  = ui_xCreateDialogItem ("z19s5", pannel, "",bn_intWidth,dummy,z18s1);

    z20s1  = ui_xCreateLabelItem ("        y:", pannel,15*bn_fontWidth,NULL,z19s1); 
    z20s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,z20s1,z19s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z20s2,z19s1); 
    z20s3  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z19s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z20s3,z19s1); 
    z20s4  = ui_xCreateDialogItem ("z20s4", pannel, "",bn_intWidth,dummy,z19s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z20s4,z19s1); 
    z20s5  = ui_xCreateDialogItem ("z20s5", pannel, "",bn_intWidth,dummy,z19s1);

    z21s1  = ui_xCreateLabelItem ("Move", pannel,15*bn_fontWidth,NULL,z20s1); 


    z22s1  = ui_xCreateLabelItem ("       dx:", pannel,15*bn_fontWidth,NULL,z21s1); 
    z22s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,z22s1,z21s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z22s2,z21s1); 
    z22s3  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z21s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z22s3,z21s1); 
    z22s4  = ui_xCreateDialogItem ("z22s4", pannel, "",bn_intWidth,dummy,z21s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z22s4,z21s1); 
    z22s5  = ui_xCreateDialogItem ("z22s5", pannel, "",bn_intWidth,dummy,z21s1);

    z23s1  = ui_xCreateLabelItem ("       dy:", pannel,15*bn_fontWidth,NULL,z22s1); 
    z23s2  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,z23s1,z22s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z23s2,z22s1); 
    z23s3  = ui_xCreateFrameLabelItem ("", pannel,bn_intWidth,dummy,z22s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,3 * bn_fontWidth,z23s3,z22s1); 
    z23s4  = ui_xCreateDialogItem ("z23s4", pannel, "",bn_intWidth,dummy,z22s1);
    dummy  = ui_xCreateLabelItem (" ",pannel,1 * bn_fontWidth,z23s4,z22s1); 
    z23s5  = ui_xCreateDialogItem ("z23s5", pannel, "",bn_intWidth,dummy,z22s1);


    dummy           = ui_xCreateLabelItem (" ",pannel,15 * bn_fontWidth,NULL,z23s1); 

    link_edit       = ui_xCreateLabelItem ("Edit Link: ",pannel,15 * bn_fontWidth,NULL,dummy); 
    link_enter      = bn_xCreateButtonItem ("enter",pannel,link_edit,dummy);
      XtAddCallback(link_enter,XtNcallback,enter_link_PROC,NULL);
    link_overwrite  = bn_xCreateButtonItem ("overwrite",pannel,link_enter,dummy);
      XtAddCallback(link_overwrite,XtNcallback,overwrite_link_PROC,NULL);
    link_to_edit    = bn_xCreateButtonItem ("link_to_edit",pannel,link_overwrite,dummy);
      XtAddCallback(link_to_edit,XtNcallback,current_link_to_editor_PROC,NULL);
    link_delete     = bn_xCreateButtonItem ("delete",pannel,link_to_edit,dummy);
      XtAddCallback(link_delete,XtNcallback,delete_link_PROC,NULL);

    dummy           = ui_xCreateLabelItem (" ",pannel,15 * bn_fontWidth,NULL,link_edit); 

    full_connection = bn_xCreateButtonItem ("full_connection",pannel,dummy,link_edit);
      XtAddCallback(full_connection,XtNcallback,full_connection_PROC,NULL);
    shortcut_connection = bn_xCreateButtonItem ("shortcut_connection",pannel,full_connection,link_edit);
      XtAddCallback(shortcut_connection,XtNcallback,shortcut_connection_PROC,NULL);

    current_link  = ui_xCreateLabelItem ("Current Link: ",pannel,15 * bn_fontWidth,NULL,dummy); 
    link_first    = bn_xCreateButtonItem ("first",pannel,current_link,dummy);
      XtAddCallback(link_first,XtNcallback,beginning_link_PROC,NULL);
    link_prev     = bn_xCreateButtonItem ("prev",pannel,link_first,dummy);
      XtAddCallback(link_prev,XtNcallback,backward_link_PROC,NULL);
    link_next     = bn_xCreateButtonItem ("next",pannel,link_prev,dummy);
      XtAddCallback(link_next,XtNcallback,forward_link_PROC,NULL);
    link_last     = bn_xCreateButtonItem ("last",pannel,link_next,dummy);
      XtAddCallback(link_last,XtNcallback,end_link_PROC,NULL);

  }


/*****************************************************************************
  FUNCTION : exit_PROC

  PURPOSE  : callback function of the exit-buttom. You are leaving bignet.
  NOTES    :

  UPDATE   : 20.12.1991
******************************************************************************/



void exit_PROC ()

{
    XtDestroyWidget (baseWidget);
    bignet_widget_open = 0;
}

/*****************************************************************************
  FUNCTION : bn_createBignet

  PURPOSE  : creates the bignet-window.
  NOTES    :

  UPDATE   : 20.12.1991
******************************************************************************/


void bn_createBignet ()

{
    Widget       frameWidget, box, enter;
    Widget       create_net,exit,cancel;
    Arg          arg[25];
    Cardinal     n;
    char         buf[40];

    int number = 10;

    if(! bignet_widget_open)
      {
       sprintf (buf, "bignet");
       n = 0;  

       baseWidget = XtCreatePopupShell (buf, topLevelShellWidgetClass, ui_toplevel, arg, n); 
       n = 0;  
       box = XtCreateManagedWidget ("box", boxWidgetClass, baseWidget, arg, n);
       bn_createPlanePannel (box); 
       bn_createLinkPannel(box);

       create_net = bn_xCreateButtonItem ("create_net",box,NULL,NULL);
         XtAddCallback(create_net,XtNcallback,create_net_PROC,NULL);
       exit = bn_xCreateButtonItem ("done",box,create_net,NULL);
         XtAddCallback(exit,XtNcallback,exit_PROC,NULL);
       cancel     = bn_xCreateButtonItem ("cancel",box,exit,NULL);
         XtAddCallback(cancel,XtNcallback,cancel_net_PROC,NULL);

       XtPopup (baseWidget, XtGrabNone);
       bignet_widget_open = 1;
       if(PLANE_length != 0){
         write_current_plane();
         if(LINK_length != 0) {
           write_current_link();
         }
       }
     }
}


   









/* end of file */
/* lines: 607 */
