extern char   ui_filenameNET[];
extern char   ui_filenameSLNET[];
extern struct Ui_DisplayType  *ui_currentDisplay;
extern Display *ui_display; /* X display */
extern struct PosType ui_gridPosMouse; /* current mouse position */



void create_net_PROC()
{
 LINK  *LINK_element=LINK_first_element;
 PLANE *source_plane,*target_plane;
 int move,type_of_connection=1;
 int create=1;

 BN_ERROR = 0;

 if(krui_getNoOfUnits() != 0) {
   if(! ui_confirmYes("Create will erase current network. Create?")) {
     create = 0;
   }
 }
 
 if(create && (PLANE_length != 0)) {

   krui_deleteNet();

   calculate_first_snns_unit_no_of_plane();
   create_snns_unit(); 

   while((LINK_element != NULL) && (! BN_ERROR)) {

     move               = (*LINK_element).move;
     type_of_connection = (*LINK_element).type_of_connection;
     source_plane       =  get_plane((*LINK_element).SOURCE.plane);
     target_plane       =  get_plane((*LINK_element).TARGET.plane);
   
     switch(type_of_connection) {
       case PLANE_TO_PLANE: {
                             make_link(source_plane,0,0,
                                       (*source_plane).width,(*source_plane).height,
                                       target_plane,0,0,
                                       (*target_plane).width,(*target_plane).height);
                             break;
                            }
       case PLANE_TO_CLUSTER: {
                             make_link(source_plane,0,0,
                                       (*source_plane).width,(*source_plane).height,
                                       target_plane,(*LINK_element).TARGET.CLUSTER.x-1,(*LINK_element).TARGET.CLUSTER.y-1,
                                       (*LINK_element).TARGET.CLUSTER.width,(*LINK_element).TARGET.CLUSTER.height);
                             break;
                            }
       case PLANE_TO_UNIT: {
                             make_link(source_plane,0,0,
                                       (*source_plane).width,(*source_plane).height,
                                       target_plane,(*LINK_element).TARGET.UNIT.x-1,(*LINK_element).TARGET.UNIT.y-1,
                                       1,1);
                             break;
                            }  
       case CLUSTER_TO_PLANE: {
                               make_link(source_plane,(*LINK_element).SOURCE.CLUSTER.x-1,(*LINK_element).SOURCE.CLUSTER.y-1,
                                         (*LINK_element).SOURCE.CLUSTER.width,(*LINK_element).SOURCE.CLUSTER.height,
                                         target_plane,0,0,
                                         (*target_plane).width,(*target_plane).height);

                                break;
                               }
       case CLUSTER_TO_CLUSTER: {
                              if(move) {
                                make_move_link(source_plane,(*LINK_element).SOURCE.CLUSTER.x-1,(*LINK_element).SOURCE.CLUSTER.y-1,
                                               (*LINK_element).SOURCE.CLUSTER.width,(*LINK_element).SOURCE.CLUSTER.height,
                                               target_plane,(*LINK_element).TARGET.CLUSTER.x-1,(*LINK_element).TARGET.CLUSTER.y-1,
                                               (*LINK_element).TARGET.CLUSTER.width,(*LINK_element).TARGET.CLUSTER.height,
                                               (*LINK_element).SOURCE.MOVE.delta_x,(*LINK_element).SOURCE.MOVE.delta_y,
                                               (*LINK_element).TARGET.MOVE.delta_x,(*LINK_element).TARGET.MOVE.delta_y);
                                 }
                                 else {
                                   make_link(source_plane,(*LINK_element).SOURCE.CLUSTER.x-1,(*LINK_element).SOURCE.CLUSTER.y-1,
                                             (*LINK_element).SOURCE.CLUSTER.width,(*LINK_element).SOURCE.CLUSTER.height,
                                             target_plane,(*LINK_element).TARGET.CLUSTER.x-1,(*LINK_element).TARGET.CLUSTER.y-1,
                                             (*LINK_element).TARGET.CLUSTER.width,(*LINK_element).TARGET.CLUSTER.height);
                                 }
                                 break;
                                }
       case CLUSTER_TO_UNIT: {
                              if(move) {
                                make_move_link(source_plane,(*LINK_element).SOURCE.CLUSTER.x-1,(*LINK_element).SOURCE.CLUSTER.y-1,
                                               (*LINK_element).SOURCE.CLUSTER.width,(*LINK_element).SOURCE.CLUSTER.height,
                                               target_plane,(*LINK_element).TARGET.UNIT.x-1,(*LINK_element).TARGET.UNIT.y-1,
                                               1,1,
                                               (*LINK_element).SOURCE.MOVE.delta_x,(*LINK_element).SOURCE.MOVE.delta_y,
                                               (*LINK_element).TARGET.MOVE.delta_x,(*LINK_element).TARGET.MOVE.delta_y);
                                 }
                                 else {
                                   make_link(source_plane,(*LINK_element).SOURCE.CLUSTER.x-1,(*LINK_element).SOURCE.CLUSTER.y-1,
                                             (*LINK_element).SOURCE.CLUSTER.width,(*LINK_element).SOURCE.CLUSTER.height,
                                             target_plane,(*LINK_element).TARGET.UNIT.x-1,(*LINK_element).TARGET.UNIT.y-1,
                                             1,1);
                                 }
                                 break;
                                }
       case UNIT_TO_PLANE: {
                            make_link(source_plane,(*LINK_element).SOURCE.UNIT.x-1,(*LINK_element).SOURCE.UNIT.y-1,
                                      1,1,
                                      target_plane,0,0,
                                      (*target_plane).width,(*target_plane).height);
                            break;
         		   }
       case UNIT_TO_CLUSTER: {
                              if(move) {
                                make_move_link(source_plane,(*LINK_element).SOURCE.UNIT.x-1,(*LINK_element).SOURCE.UNIT.y-1,
                                               1,1,
                                               target_plane,(*LINK_element).TARGET.CLUSTER.x-1,(*LINK_element).TARGET.CLUSTER.y-1,
                                               (*LINK_element).TARGET.CLUSTER.width,(*LINK_element).TARGET.CLUSTER.height,
                                               (*LINK_element).SOURCE.MOVE.delta_x,(*LINK_element).SOURCE.MOVE.delta_y,
                                               (*LINK_element).TARGET.MOVE.delta_x,(*LINK_element).TARGET.MOVE.delta_y);
			        }
                              else {
                                make_link(source_plane,(*LINK_element).SOURCE.UNIT.x-1,(*LINK_element).SOURCE.UNIT.y-1,
                                          1,1,
                                          target_plane,(*LINK_element).TARGET.CLUSTER.x-1,(*LINK_element).TARGET.CLUSTER.y-1,
                                          (*LINK_element).TARGET.CLUSTER.width,(*LINK_element).TARGET.CLUSTER.height);
                            }
                              break;
            		     }
       case UNIT_TO_UNIT: {
                           if(move) {
                             make_move_link(source_plane,(*LINK_element).SOURCE.UNIT.x-1,(*LINK_element).SOURCE.UNIT.y-1,
                                            1,1,
                                            target_plane,(*LINK_element).TARGET.UNIT.x-1,(*LINK_element).TARGET.UNIT.y-1,
                                            1,1,
                                            (*LINK_element).SOURCE.MOVE.delta_x,(*LINK_element).SOURCE.MOVE.delta_y,
                                            (*LINK_element).TARGET.MOVE.delta_x,(*LINK_element).TARGET.MOVE.delta_y);
			   }
                           else {
                              make_link(source_plane,(*LINK_element).SOURCE.UNIT.x-1,(*LINK_element).SOURCE.UNIT.y-1,
                                        1,1,
                                        target_plane,(*LINK_element).TARGET.UNIT.x-1,(*LINK_element).TARGET.UNIT.y-1,
                                        1,1);
                           }
                           break;
            		  }
       } /* switch */
     LINK_element = (*LINK_element).next;
   } /* while */    
   bn_display_net();
 }/* if */ 
}

void calculate_first_snns_unit_no_of_plane()
{
 PLANE *PLANE_element = PLANE_first_element;

 (*PLANE_element).begin = 1;  
 PLANE_element = (*PLANE_element).next;

 while(PLANE_element != NULL) {
   (*PLANE_element).begin = (*(*PLANE_element).before).width *
                                (*(*PLANE_element).before).height +
				  (*(*PLANE_element).before).begin;
   PLANE_element = (*PLANE_element).next; 
 }
}
       
void create_snns_unit()
{
 struct PosType unit_pos;

 PLANE *PLANE_element = PLANE_first_element; 
 int x_max=1,y_max=1,x_before=1,y_before=1,
     x,y,width,height,unit_no,ret,first=1;

 ret = krui_allocateUnits((*PLANE_last_element).width * 
                             (*PLANE_last_element).height +
                               (*PLANE_last_element).begin-1);
 if(ret != 0){
   ui_checkError(ret);
   BN_ERROR = 1;
 }

 while((! BN_ERROR) && (PLANE_element != NULL)) {

   height = (*PLANE_element).height;
   width  = (*PLANE_element).width;
    
   for(y=0;y<height;y++){
     for(x=0;x<width;x++){
       unit_no = krui_createDefaultUnit();
       if(unit_no<0) ui_checkError(unit_no);
       ret = krui_setUnitTType(unit_no,(*PLANE_element).type+1);
       if(ret != 0){
         ui_checkError(ret);
         BN_ERROR = 1;
       }
      
/*     krui_setUnitSubnetNo(unit_no,layer);*/
       
       if((*PLANE_element).pos == BN_RIGHT) {
         unit_pos.x = x_max + x;
         unit_pos.y = 1 + y;
       }
       else {
         unit_pos.x = x_before + x;
         unit_pos.y = y_max + y;
       }

      krui_setUnitPosition(unit_no,&unit_pos);

     }/*for*/
   }/*for*/

   if(first) {
     x_max = x_max + width + 2;
     y_max = y_max + height + 2;
     first = 0;
   }
   else if((*PLANE_element).pos == BN_RIGHT) {
     x_before = x_max;
     x_max = x_max + width + 2;
     y_max = height + 3;
   }
   else {
     y_max = y_max + height +2;
   }
   
   PLANE_element = (*PLANE_element).next;
 }/*while*/
}


void make_link(LINK_source_plane,LINK_source_cluster_x,LINK_source_cluster_y,
               LINK_source_cluster_width,LINK_source_cluster_height,
               LINK_target_plane,LINK_target_cluster_x,LINK_target_cluster_y,
               LINK_target_cluster_width,LINK_target_cluster_height)


PLANE *LINK_source_plane,*LINK_target_plane;

int LINK_source_cluster_y,LINK_source_cluster_x,LINK_source_cluster_width,LINK_source_cluster_height;
int LINK_target_cluster_y,LINK_target_cluster_x,LINK_target_cluster_width,LINK_target_cluster_height;


{
 int i,j,k,l,ret,target_unit,source_unit;

 
 static int counter = 0;

 for(i = LINK_target_cluster_y;i < LINK_target_cluster_height+LINK_target_cluster_y;i++)
   for(j = LINK_target_cluster_x;j < LINK_target_cluster_width+LINK_target_cluster_x;j++)
      {
       target_unit = (*LINK_target_plane).begin + 
                       (*LINK_target_plane).width * i + j;
       ret = krui_setCurrentUnit(target_unit);
       if(ret != 0){
         ui_checkError(ret);
         BN_ERROR = 1;
         krui_deleteNet();
         goto disaster;
       }
       for(k = LINK_source_cluster_y;k < LINK_source_cluster_height+LINK_source_cluster_y;k++)
         for(l = LINK_source_cluster_x;l < LINK_source_cluster_width+LINK_source_cluster_x;l++)
           {
            source_unit = (*LINK_source_plane).begin + 
                             (*LINK_source_plane).width * k + l;
            if((ret = krui_createLink(source_unit,0.0)) != 0){
              ui_checkError(ret);
              BN_ERROR = 1;
              krui_deleteNet();
              goto disaster;
            }
            /*printf("Source: %d --> Target: %d\n",source_unit,target_unit);*/
           } 
      }             
 disaster: ;
}



void make_move_link(LINK_source_plane,LINK_source_cluster_x,LINK_source_cluster_y,LINK_source_cluster_width,LINK_source_cluster_height,
                    LINK_target_plane,LINK_target_cluster_x,LINK_target_cluster_y,LINK_target_cluster_width,LINK_target_cluster_height,
                    LINK_source_move_delta_x,LINK_source_move_delta_y,
                    LINK_target_move_delta_x,LINK_target_move_delta_y)


PLANE *LINK_source_plane,*LINK_target_plane;

int LINK_source_cluster_y,LINK_source_cluster_x,LINK_source_cluster_width,LINK_source_cluster_height;
int LINK_target_cluster_y,LINK_target_cluster_x,LINK_target_cluster_width,LINK_target_cluster_height;

int LINK_source_move_delta_x,LINK_source_move_delta_y;
int LINK_target_move_delta_x,LINK_target_move_delta_y;

{
 int xs_pivot=LINK_source_cluster_x;
 int xt_pivot=LINK_target_cluster_x;

 do {
   make_link(LINK_source_plane,LINK_source_cluster_x,LINK_source_cluster_y,LINK_source_cluster_width,LINK_source_cluster_height,
             LINK_target_plane,LINK_target_cluster_x,LINK_target_cluster_y,LINK_target_cluster_width,LINK_target_cluster_height);
 }
 while(! BN_ERROR &&
       move_p(LINK_source_plane,&LINK_source_cluster_y,&LINK_source_cluster_x,
              LINK_source_cluster_width,LINK_source_cluster_height,
              xs_pivot,LINK_source_move_delta_x,LINK_source_move_delta_y)           &&
       move_p(LINK_target_plane,&LINK_target_cluster_y,&LINK_target_cluster_x,
              LINK_target_cluster_width,LINK_target_cluster_height,
              xt_pivot,LINK_target_move_delta_x,LINK_target_move_delta_y));
}
    

int move_p(plane_no,y,x,width,height,x_pivot,x_step,y_step)

PLANE *plane_no;

int width,height,x_pivot,x_step,y_step;
int *y,*x;

{ 
 if(x_step > 0 && ((*x)+width+x_step<=(*plane_no).width))
   (*x)+= x_step;
 else
    if(y_step > 0 && ((*y)+height+y_step<=(*plane_no).height))
      {
       (*y) += y_step;
       (*x) = x_pivot;
      }
    else
      return 0;

 return 1;
}






void bn_display_net()
{
 ui_sel_resetList();
 ui_net_completeRefresh(ui_currentDisplay,2);
 ui_stat_displayStatus(ui_gridPosMouse);
 strcpy(ui_filenameNET,"SNNS_NET");
 strcpy(ui_filenameSLNET,"SNNS_NET");
 ui_file_updateShellLabels();
 ui_info_makeUnitInfoPanelConsistent();
}






/* end of file */
/* lines: 356 */
