/*****************************************************************************
  FILE     : bn_link.c

  PURPOSE  : Functions of the link editor.
  FUNCTIONS: 
  NOTES    : Part of the program bignet.

  AUTHOR   : Michael Schmalzl
  DATE     : 20.12.1991

  COPYRIGHT: (c) 1991 by Michael Schmalzl and the SNNS-Group
             
******************************************************************************/


/*****************************************************************************
  FUNCTION : read_link_elements

  PURPOSE  : reads the input datas of the link editor (Edit Link).

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


int read_link_elements()
{
 LINK_source_plane = ui_xIntFromAsciiWidget(z10s4);
 LINK_source_cluster_x = ui_xIntFromAsciiWidget(z13s4);
 LINK_source_cluster_y = ui_xIntFromAsciiWidget(z14s4);
 LINK_source_cluster_width = ui_xIntFromAsciiWidget(z15s4);
 LINK_source_cluster_height = ui_xIntFromAsciiWidget(z16s4);
 LINK_source_unit_x = ui_xIntFromAsciiWidget(z19s4);
 LINK_source_unit_y = ui_xIntFromAsciiWidget(z20s4);
 LINK_source_move_delta_x = ui_xIntFromAsciiWidget(z22s4);
 LINK_source_move_delta_y = ui_xIntFromAsciiWidget(z23s4);

 LINK_target_plane = ui_xIntFromAsciiWidget(z10s5);
 LINK_target_cluster_x = ui_xIntFromAsciiWidget(z13s5);
 LINK_target_cluster_y = ui_xIntFromAsciiWidget(z14s5);
 LINK_target_cluster_width = ui_xIntFromAsciiWidget(z15s5);
 LINK_target_cluster_height = ui_xIntFromAsciiWidget(z16s5);
 LINK_target_unit_x = ui_xIntFromAsciiWidget(z19s5);
 LINK_target_unit_y = ui_xIntFromAsciiWidget(z20s5);
 LINK_target_move_delta_x = ui_xIntFromAsciiWidget(z22s5);
 LINK_target_move_delta_y = ui_xIntFromAsciiWidget(z23s5);

 return correct_link_input();
}

/*****************************************************************************
  FUNCTION : write_current_link

  PURPOSE  : writes the datas of the current_element to the control part 
             (Current Link) of the link editor.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/
 

void write_current_link()
 {
  char buf[10];
  
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.plane);
    ui_xSetLabel(z10s2,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.CLUSTER.x);
    ui_xSetLabel(z13s2,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.CLUSTER.y);
    ui_xSetLabel(z14s2,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.CLUSTER.width);
    ui_xSetLabel(z15s2,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.CLUSTER.height);
    ui_xSetLabel(z16s2,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.UNIT.x);
    ui_xSetLabel(z19s2,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.UNIT.y);
    ui_xSetLabel(z20s2,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.MOVE.delta_x);
    ui_xSetLabel(z22s2,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.MOVE.delta_y);
    ui_xSetLabel(z23s2,bn_widget_output(buf));

  sprintf(buf,"%d",(*LINK_current_element).TARGET.plane);
    ui_xSetLabel(z10s3,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.CLUSTER.x);
    ui_xSetLabel(z13s3,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.CLUSTER.y);
    ui_xSetLabel(z14s3,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.CLUSTER.width);
    ui_xSetLabel(z15s3,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.CLUSTER.height);
    ui_xSetLabel(z16s3,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.UNIT.x);
    ui_xSetLabel(z19s3,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.UNIT.y);
    ui_xSetLabel(z20s3,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.MOVE.delta_x);
    ui_xSetLabel(z22s3,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.MOVE.delta_y);
    ui_xSetLabel(z23s3,bn_widget_output(buf));
}


/*****************************************************************************
  FUNCTION : clear_current_link

  PURPOSE  : Deletes the datas standing in Current Link.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


void clear_current_link()
 {
  ui_xSetLabel(z10s2,"");
  ui_xSetLabel(z13s2,"");
  ui_xSetLabel(z14s2,"");
  ui_xSetLabel(z15s2,"");
  ui_xSetLabel(z16s2,"");
  ui_xSetLabel(z19s2,"");
  ui_xSetLabel(z20s2,"");
  ui_xSetLabel(z22s2,"");
  ui_xSetLabel(z23s2,"");

  ui_xSetLabel(z10s3,"");
  ui_xSetLabel(z13s3,"");
  ui_xSetLabel(z14s3,"");
  ui_xSetLabel(z15s3,"");
  ui_xSetLabel(z16s3,"");
  ui_xSetLabel(z19s3,"");
  ui_xSetLabel(z20s3,"");
  ui_xSetLabel(z22s3,"");
  ui_xSetLabel(z23s3,"");
}

/*****************************************************************************
  FUNCTION : write_current_link_to_editor

  PURPOSE  : writes the datas of Current Link to Edit Link

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


void write_current_link_to_editor()
 {
  char buf[10];

  sprintf(buf,"%d",(*LINK_current_element).SOURCE.plane);
    ui_xSetString(z10s4,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.CLUSTER.x);
    ui_xSetString(z13s4,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.CLUSTER.y);
    ui_xSetString(z14s4,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.CLUSTER.width);
    ui_xSetString(z15s4,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.CLUSTER.height);
    ui_xSetString(z16s4,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.UNIT.x);
    ui_xSetString(z19s4,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.UNIT.y);
    ui_xSetString(z20s4,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.MOVE.delta_x);
    ui_xSetString(z22s4,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).SOURCE.MOVE.delta_y);
    ui_xSetString(z23s4,bn_widget_output(buf));

  sprintf(buf,"%d",(*LINK_current_element).TARGET.plane);
    ui_xSetString(z10s5,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.CLUSTER.x);
    ui_xSetString(z13s5,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.CLUSTER.y);
    ui_xSetString(z14s5,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.CLUSTER.width);
    ui_xSetString(z15s5,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.CLUSTER.height);
    ui_xSetString(z16s5,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.UNIT.x);
    ui_xSetString(z19s5,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.UNIT.y);
    ui_xSetString(z20s5,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.MOVE.delta_x);
    ui_xSetString(z22s5,bn_widget_output(buf));
  sprintf(buf,"%d",(*LINK_current_element).TARGET.MOVE.delta_y);
    ui_xSetString(z23s5,bn_widget_output(buf));

}


/*****************************************************************************
  FUNCTION : clear_edit_link

  PURPOSE  : Deletes the datas standing in Edit Link.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


void clear_edit_link()
{
 ui_xSetString(z10s4,"");
 ui_xSetString(z13s4,"");
 ui_xSetString(z14s4,"");
 ui_xSetString(z15s4,"");
 ui_xSetString(z16s4,"");
 ui_xSetString(z19s4,"");
 ui_xSetString(z20s4,"");
 ui_xSetString(z22s4,"");
 ui_xSetString(z23s4,"");

 ui_xSetString(z10s5,"");
 ui_xSetString(z13s5,"");
 ui_xSetString(z14s5,"");
 ui_xSetString(z15s5,"");
 ui_xSetString(z16s5,"");
 ui_xSetString(z19s5,"");
 ui_xSetString(z20s5,"");
 ui_xSetString(z22s5,"");
 ui_xSetString(z23s5,"");
}


/*****************************************************************************
  FUNCTION : enter_link_PROC
 
  PURPOSE  : callback function, which enters a link element at the end of the 
             link list.

  NOTES    : the link list contains all datas entered by the link editor.
             Every link element is a struct (see bn_types.c)

  UPDATE   : 20.12.1991
******************************************************************************/



void enter_link_PROC()
{
 if(read_link_elements()){
   enter_link();
   write_current_link();
   clear_edit_link();
 }
}

/*****************************************************************************
  FUNCTION : full_connection_PROC
 
  PURPOSE  : callback function, which creates links between planes (see docu)

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


void full_connection_PROC()
{
 while(LINK_length) {
   delete_current_link();
 }
 if(full_connection()) {
   write_current_link();
 }
}

/*****************************************************************************
  FUNCTION : shortcut_connection_PROC
 
  PURPOSE  : callback function, which creates links between planes (see docu)

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


void shortcut_connection_PROC()
{
 while(LINK_length) {
   delete_current_link();
 }
 if(shortcut_connection()) {
   write_current_link();
 }
}

/*****************************************************************************
  FUNCTION : overwrite_link_PROC
 
  PURPOSE  : callback function, which overwrites the current link element
             (Current Link) with the datas of the link editor (Edit Link).

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


void overwrite_link_PROC()
{
 if(read_link_elements()) {
  overwrite_link();
  write_current_link();
  clear_edit_link();
 }
}

/*****************************************************************************
  FUNCTION : delete_link_PROC
 
  PURPOSE  : callback function, which deletes the Currenrt Link out of
             the link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


void delete_link_PROC()
{
 delete_current_link();
 if(LINK_length == 0) {
   clear_current_link();
 }
 else {
   write_current_link();
 }
}

/*****************************************************************************
  FUNCTION : forward_link_PROC
 
  PURPOSE  : callback function, which moves forward one list element in the
             link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


void forward_link_PROC()
{
 if(forward_link()){
   write_current_link();
 }
}

/*****************************************************************************
  FUNCTION : backward_link_PROC
 
  PURPOSE  : callback function, which moves backward one list element in the
             link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void backward_link_PROC()
{
 if(backward_link()) {
   write_current_link();
 }
}

/*****************************************************************************
  FUNCTION : end_link_PROC
 
  PURPOSE  : callback function, which jumps to the end of the link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void end_link_PROC()
{
 if(end_link()) {
   write_current_link();
 }
}

/*****************************************************************************
  FUNCNCTION : beginning_link_PROC
 
  PURPOSE  : callback function, which jumps to the beginning of the link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


void beginning_link_PROC()
{
 if(beginning_link()) {
   write_current_link();
 }
}

/*****************************************************************************
  FUNCNCTION : current_link_to_editor_PROC
 
  PURPOSE  : callback function, which writes the Current Link to Edit Link

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


void current_link_to_editor_PROC()
{
 if(LINK_length != 0) {
   write_current_link_to_editor();
 }
 else {
   clear_edit_link();
 }
}

/*****************************************************************************
  FUNCNCTION : correct_link_input
 
  PURPOSE  : tests whether the input datas of Edit Link are correct and decides
             what kind of link (PLANE_TO_PLANE, PLANE_TO_LINK...) we have.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


int correct_link_input()
{
 PLANE *PLANE_source_no,*PLANE_target_no;

 int link_type;
 int target_plane=0,source_plane=0;
 int target_cluster=0,source_cluster=0;
 int target_unit=0,source_unit=0;
 int a,b,c,d;

 PLANE_source_no = get_plane(LINK_source_plane);
 PLANE_target_no = get_plane(LINK_target_plane);

 LINK_move = 0;

 if((PLANE_source_no != PLANE_target_no) &&

     PLANE_source_no != NULL &&
     PLANE_target_no != NULL &&

    (LINK_source_cluster_x + LINK_source_cluster_width  <= (*PLANE_source_no).width + 1) &&
    (LINK_source_cluster_y + LINK_source_cluster_height <= (*PLANE_source_no).height + 1) &&
    (LINK_source_unit_x <= (*PLANE_source_no).width) &&
    (LINK_source_unit_y <= (*PLANE_source_no).height) &&
    
    (LINK_target_cluster_x + LINK_target_cluster_width  <= (*PLANE_target_no).width + 1) &&
    (LINK_target_cluster_y + LINK_target_cluster_height <= (*PLANE_target_no).height + 1) &&
    (LINK_target_unit_x <= (*PLANE_target_no).width) &&
    (LINK_target_unit_y <= (*PLANE_target_no).height)) {
   
   target_plane = TARGET_PLANE;
   source_plane = SOURCE_PLANE;

   a=b=c=d=0;

   if(((a=LINK_source_cluster_x) >= 1) &&
      ((b=LINK_source_cluster_y) >= 1) &&
      ((c=LINK_source_cluster_width) >= 1) &&
      ((d=LINK_source_cluster_height) >= 1)) {
     source_cluster = SOURCE_CLUSTER;
   }

   if((! source_cluster) && a+b+c+d) {
      return 0;
    }

   a=b=0;

   if(((a=LINK_source_unit_x) >= 1) &&
      ((b=LINK_source_unit_y) >= 1)) {
     source_unit = SOURCE_UNIT;
   }

   if((! source_unit) && a+b) {
      return 0;
    }

   a=b=c=d=0;

   if(((a=LINK_target_cluster_x) >= 1) &&
      ((b=LINK_target_cluster_y) >= 1) &&
      ((c=LINK_target_cluster_width) >= 1) &&
      ((d=LINK_target_cluster_height) >= 1)) {
     target_cluster = TARGET_CLUSTER;
   }

   if((! target_cluster) && a+b+c+d) {
      return 0;
    }

   a=b=0;

   if(((a=LINK_target_unit_x) >= 1) &&
      ((b=LINK_target_unit_y) >= 1)) {
     target_unit = TARGET_UNIT;
   }

   if((! target_unit) && a+b) {
      return 0;
    }

   link_type =  target_plane+source_plane+target_cluster+source_cluster+target_unit+source_unit;

   if((link_type == PLANE_TO_PLANE) ||
      (link_type == PLANE_TO_CLUSTER) ||
      (link_type == PLANE_TO_UNIT) ||
      (link_type == CLUSTER_TO_PLANE) ||
      (link_type == CLUSTER_TO_CLUSTER) ||
      (link_type == CLUSTER_TO_UNIT) ||
      (link_type == UNIT_TO_PLANE) ||
      (link_type == UNIT_TO_CLUSTER) ||
      (link_type == UNIT_TO_UNIT)) {

      LINK_type_of_connection = link_type;

      if((LINK_source_move_delta_x || LINK_source_move_delta_y ||
         LINK_target_move_delta_x || LINK_target_move_delta_y) &&
         ((link_type == CLUSTER_TO_CLUSTER) ||
          (link_type == CLUSTER_TO_UNIT)    ||
          (link_type == UNIT_TO_CLUSTER)    ||
          (link_type == UNIT_TO_UNIT))) {
        LINK_move = 1;
      }
      else {
        LINK_source_move_delta_x = LINK_source_move_delta_y = LINK_target_move_delta_x = LINK_target_move_delta_y = 0;
      }
      return 1;
    }/* if */
 }
 return 0;
}


/*****************************************************************************
  FUNCTION : enter_link
 
  PURPOSE  : enters a link element at the end of the link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void enter_link()
{
 LINK *LINK_element;

 LINK_element = (LINK *)malloc(sizeof(LINK)); 
 
 (*LINK_element).SOURCE.plane          = LINK_source_plane;
 (*LINK_element).SOURCE.CLUSTER.x      = LINK_source_cluster_x;
 (*LINK_element).SOURCE.CLUSTER.y      = LINK_source_cluster_y;
 (*LINK_element).SOURCE.CLUSTER.width  = LINK_source_cluster_width;
 (*LINK_element).SOURCE.CLUSTER.height = LINK_source_cluster_height;
 (*LINK_element).SOURCE.UNIT.x         = LINK_source_unit_x;
 (*LINK_element).SOURCE.UNIT.y         = LINK_source_unit_y;
 (*LINK_element).SOURCE.MOVE.delta_x   = LINK_source_move_delta_x;
 (*LINK_element).SOURCE.MOVE.delta_y   = LINK_source_move_delta_y;

 (*LINK_element).TARGET.plane          = LINK_target_plane;
 (*LINK_element).TARGET.CLUSTER.x      = LINK_target_cluster_x;
 (*LINK_element).TARGET.CLUSTER.y      = LINK_target_cluster_y;
 (*LINK_element).TARGET.CLUSTER.width  = LINK_target_cluster_width;
 (*LINK_element).TARGET.CLUSTER.height = LINK_target_cluster_height;
 (*LINK_element).TARGET.UNIT.x         = LINK_target_unit_x;
 (*LINK_element).TARGET.UNIT.y         = LINK_target_unit_y;
 (*LINK_element).TARGET.MOVE.delta_x   = LINK_target_move_delta_x;
 (*LINK_element).TARGET.MOVE.delta_y   = LINK_target_move_delta_y;

 (*LINK_element).move                  = LINK_move;
 (*LINK_element).type_of_connection    = LINK_type_of_connection;

 (*LINK_element).next   = NULL;
 (*LINK_element).before = LINK_last_element;
   
 if(LINK_last_element != NULL) {
   (*LINK_last_element).next = LINK_element;
 }

 if(LINK_first_element == NULL) {
   LINK_first_element = LINK_element;
 }

 LINK_last_element = LINK_element;
 LINK_current_element = LINK_last_element;
   
 LINK_length++;
}/* enter_link */

/*****************************************************************************
  FUNCTION : full_connection
 
  PURPOSE  : creates links between planes (see docu).

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

int full_connection()
{
 PLANE *PLANE_element;

 if(PLANE_length >= 2) { 

   PLANE_element = (*PLANE_first_element).next;

   LINK_source_plane = 0;
   LINK_target_plane = 1;
   
   LINK_source_cluster_x =  LINK_source_cluster_y = LINK_source_cluster_width = LINK_source_cluster_height = 0;
   LINK_source_unit_x = LINK_source_unit_y = 0;
   LINK_source_move_delta_x = LINK_source_move_delta_y = 0;

   LINK_target_cluster_x = LINK_target_cluster_y = LINK_target_cluster_width = LINK_target_cluster_height = 0;
   LINK_target_unit_x = LINK_target_unit_y = 0;
   LINK_target_move_delta_x = LINK_target_move_delta_y = 0;

   LINK_move = 0;
   LINK_type_of_connection = PLANE_TO_PLANE;

   while(PLANE_element != NULL) {
 
     LINK_source_plane++;
     LINK_target_plane++;
     enter_link();

     PLANE_element = (*PLANE_element).next;
   }
   return 1;
 }
 return 0;
}

/*****************************************************************************
  FUNCTION : shortcut_connection
 
  PURPOSE  : creates links between planes(see docu).

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

int shortcut_connection()
{
 PLANE *PLANE_source_element,*PLANE_target_element;

 if(PLANE_length >= 2) { 

   PLANE_source_element = (*PLANE_first_element).next;
   PLANE_target_element = PLANE_source_element;

   LINK_source_plane = 0;
   
   LINK_source_cluster_x =  LINK_source_cluster_y = LINK_source_cluster_width = LINK_source_cluster_height = 0;
   LINK_source_unit_x = LINK_source_unit_y = 0;
   LINK_source_move_delta_x = LINK_source_move_delta_y = 0;

   LINK_target_cluster_x = LINK_target_cluster_y = LINK_target_cluster_width = LINK_target_cluster_height = 0;
   LINK_target_unit_x = LINK_target_unit_y = 0;
   LINK_target_move_delta_x = LINK_target_move_delta_y = 0;

   LINK_move = 0;
   LINK_type_of_connection = PLANE_TO_PLANE;

   while(PLANE_source_element != NULL){
     LINK_source_plane++;
     LINK_target_plane = LINK_source_plane;
     while(PLANE_target_element != NULL) {
       LINK_target_plane++;
       enter_link();
       PLANE_target_element = (*PLANE_target_element).next;
     }
     PLANE_source_element = (*PLANE_source_element).next;
     PLANE_target_element = PLANE_source_element;
   }
   return 1;
 }
 return 0;
}

/*****************************************************************************
  FUNCTION : overwrite_link
 
  PURPOSE  : overwrites the current link element (Current Link) with the 
             datas of the link editor (Edit Link).

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void overwrite_link()
{
 if(LINK_length == 0) {
   enter_link();
 }
 else {
   (*LINK_current_element).SOURCE.plane          = LINK_source_plane;
   (*LINK_current_element).SOURCE.CLUSTER.x      = LINK_source_cluster_x;
   (*LINK_current_element).SOURCE.CLUSTER.y      = LINK_source_cluster_y;
   (*LINK_current_element).SOURCE.CLUSTER.width  = LINK_source_cluster_width;
   (*LINK_current_element).SOURCE.CLUSTER.height = LINK_source_cluster_height;
   (*LINK_current_element).SOURCE.UNIT.x         = LINK_source_unit_x;
   (*LINK_current_element).SOURCE.UNIT.y         = LINK_source_unit_y;
   (*LINK_current_element).SOURCE.MOVE.delta_x   = LINK_source_move_delta_x;
   (*LINK_current_element).SOURCE.MOVE.delta_y   = LINK_source_move_delta_y;
  
   (*LINK_current_element).TARGET.plane          = LINK_target_plane;
   (*LINK_current_element).TARGET.CLUSTER.x      = LINK_target_cluster_x;
   (*LINK_current_element).TARGET.CLUSTER.y      = LINK_target_cluster_y;
   (*LINK_current_element).TARGET.CLUSTER.width  = LINK_target_cluster_width;
   (*LINK_current_element).TARGET.CLUSTER.height = LINK_target_cluster_height;
   (*LINK_current_element).TARGET.UNIT.x         = LINK_target_unit_x;
   (*LINK_current_element).TARGET.UNIT.y         = LINK_target_unit_y;
   (*LINK_current_element).TARGET.MOVE.delta_x   = LINK_target_move_delta_x;
   (*LINK_current_element).TARGET.MOVE.delta_y   = LINK_target_move_delta_y;

   (*LINK_current_element).move                  = LINK_move;
   (*LINK_current_element).type_of_connection    = LINK_type_of_connection;


 }/* if */
}/* overwrite_link */


/*****************************************************************************
  FUNCTION : delete_current_link
 
  PURPOSE  : deletes  Currenrt Link out of the link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


void delete_current_link()
{
 LINK *LINK_element;

 LINK_element = LINK_current_element;

 /* Delete the element "LINK_element" out of the plane-list */

 if(LINK_length != 0) {
   if((*LINK_element).before != NULL) {
     (*(*LINK_element).before).next = (*LINK_element).next;
   }
   if((*LINK_element).next != NULL) {
     (*(*LINK_element).next).before = (*LINK_element).before;
   }

   LINK_length--;

   /* Update the three pointers 
                  LINK_current_element,
                  LINK_first_element,
                  LINK_last_element.
   */

   if(LINK_length == 0){
     LINK_current_element = NULL;
     LINK_first_element   = NULL;
     LINK_last_element    = NULL;
   }
   else if((*LINK_element).next == NULL) {
     LINK_current_element = (*LINK_element).before;
     LINK_last_element    = LINK_current_element;
   }
   else if((*LINK_element).before == NULL) {
     LINK_current_element = (*LINK_element).next;
     LINK_first_element   = LINK_current_element;
   }
   else {
     LINK_current_element = (*LINK_element).next;
   }  

   free(LINK_element);
 }
}

/*****************************************************************************
  FUNCTION : get_links_and_delete_them(plane_no)
 
  PURPOSE  : deletes all the links which are connected with the plane 
             "plane_no"

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void get_links_and_delete_them(plane_no)
int plane_no;

{
 LINK *LINK_element = LINK_first_element;

 while(LINK_element != NULL) {
   if(((*LINK_element).SOURCE.plane != plane_no) &&
      ((*LINK_element).TARGET.plane != plane_no)) {
     LINK_element = (*LINK_element).next;
   }
   else {
     LINK_current_element = LINK_element;
     LINK_element = (*LINK_element).next;
     delete_current_link();
   }
 }/* while */
}


/*****************************************************************************
  FUNCTION : forward_link
 
  PURPOSE  : moves forward one list element in the link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


int forward_link()
{
 if(LINK_length != 0) {
   if((*LINK_current_element).next != NULL) {
     LINK_current_element = (*LINK_current_element).next;
   }
   return 1;
 }
 return 0;
}

/*****************************************************************************
  FUNCTION : backward_link
 
  PURPOSE  : moves backward one list element in the link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

int backward_link()
{
 if(LINK_length != 0) {
   if((*LINK_current_element).before != NULL) {
     LINK_current_element = (*LINK_current_element).before;
   }
   return 1;
 }
 return 0;
}

/*****************************************************************************
  FUNCTION : beginning_link
 
  PURPOSE  : jumps to the beginning of the link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

int beginning_link()
{
 if(LINK_length != 0){
   LINK_current_element = LINK_first_element;
   return 1;
 }
 return 0;
}

/*****************************************************************************
  FUNCTION : end_link
 
  PURPOSE  : jumps to the end of the link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

int end_link()
{
 if(LINK_length != 0) {
   LINK_current_element = LINK_last_element;
   return 1;
 }
 return 0;
}






/* end of file */
/* lines: 928 */
