/*****************************************************************************
  FILE     : bn_plane.c

  PURPOSE  : Functions of the plane editor.
  FUNCTIONS: 
  NOTES    : Part of the program bignet.

  AUTHOR   : Michael Schmalzl
  DATE     : 20.12.1991

  COPYRIGHT: (c) 1991 by Michael Schmalzl and the SNNS-Group
             
******************************************************************************/






/*****************************************************************************
  FUNCTION : read_plane_elements

  PURPOSE  : reads the input datas of the plane editor (Edit Plane).

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

int read_plane_elements()
{
 PLANE_width = ui_xIntFromAsciiWidget(z4s3);
 PLANE_height = ui_xIntFromAsciiWidget(z5s3);
 if((PLANE_width > 0) && (PLANE_height > 0)) {
   return 1;
 }
 else {
   return 0;
 }
}
  
/*****************************************************************************
  FUNCTION : write_current_plane

  PURPOSE  : writes the datas of the current_element to the control part 
             (Current Plane) of the plane editor.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void write_current_plane()
 {
  char buf[10];

  sprintf(buf,"%d",PLANE_no);
  ui_xSetLabel(z2s2,bn_widget_output(buf));
  ui_xSetLabel(z3s2,plane_type[(*PLANE_current_element).type]);
  sprintf(buf,"%d",(*PLANE_current_element).width);
  ui_xSetLabel(z4s2,bn_widget_output(buf));
  sprintf(buf,"%d",(*PLANE_current_element).height);
  ui_xSetLabel(z5s2,bn_widget_output(buf));
  sprintf(buf,"%d",0);
  ui_xSetLabel(z6s2,bn_widget_output(buf));
  ui_xSetLabel(z7s2,plane_pos[(*PLANE_current_element).pos]);
}

/*****************************************************************************
  FUNCTION : clear_current_plane

  PURPOSE  : Deletes the datas standing in Current Plane.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void clear_current_plane()
 {
  ui_xSetLabel(z2s2,"");
  ui_xSetLabel(z3s2,"");
  ui_xSetLabel(z4s2,"");
  ui_xSetLabel(z5s2,"");
  ui_xSetLabel(z6s2,"");
  ui_xSetLabel(z7s2,"");
}

/*****************************************************************************
  FUNCTION : write_current_plane_to_editor

  PURPOSE  : writes the datas of Current Plane to Edit Plane

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void write_current_plane_to_editor()
 {
  char buf[10];

  PLANE_type = (*PLANE_current_element).type;
  ui_xSetLabel(z3s3,plane_type[PLANE_type]);
  sprintf(buf,"%d",(*PLANE_current_element).width);
  ui_xSetString(z4s3,bn_widget_output(buf));
  sprintf(buf,"%d",(*PLANE_current_element).height);
  ui_xSetString(z5s3,bn_widget_output(buf));
  sprintf(buf,"%d",0);
  ui_xSetString(z6s3,bn_widget_output(buf));
  PLANE_pos = (*PLANE_current_element).pos;
  ui_xSetLabel(z7s3,plane_pos[PLANE_pos]);
}

/*****************************************************************************
  FUNCTION : clear_edit_plane

  PURPOSE  : Deletes the datas standing in Edit Link.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void clear_edit_plane()
{
 ui_xSetString(z4s3,"");
 ui_xSetString(z5s3,"");
 ui_xSetString(z6s3,"");
} 


/*****************************************************************************
  FUNCTION : cancel_net_PROC

  PURPOSE  : callback function, which deletes all the datas in the link 
             editor and in the plane editor.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void cancel_net_PROC()
{
 while(PLANE_length){
  delete_current_plane();
 }
 clear_current_plane();
 clear_current_link();
}

/*****************************************************************************
  FUNCTION : enter_plane_PROC
 
  PURPOSE  : callback function, which enters a plane element at the end of the 
             plane list.

  NOTES    : the plane list contains all datas entered by the plane editor.
             Every plane element is a struct (see bn_types.c)

  UPDATE   : 20.12.1991
******************************************************************************/

void enter_plane_PROC()
{
 if(read_plane_elements()){
   enter_plane();
   write_current_plane();
   clear_edit_plane();
 }
}

/*****************************************************************************
  FUNCTION : insert_plane_PROC
 
  PURPOSE  : callback function, which inserts the the input datas of the
             plane editor (Edit Plane) in front of Current Plane.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void insert_plane_PROC()
{
 if(read_plane_elements()) {
   insert_plane();
   write_current_plane();
   clear_edit_plane();
   if(LINK_length == 0) {
     clear_current_link();
   }
   else {
     write_current_link();
   }
 }
}

/*****************************************************************************
  FUNCTION : overwrite_plane_PROC
 
  PURPOSE  : callback function, which overwrites the current plane element
             (Current Plane) with the datas of the plane editor (Edit plane).

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void overwrite_plane_PROC()
{
 if(read_plane_elements()) {
  overwrite_plane();
  write_current_plane();
  clear_edit_plane();
  if(LINK_length == 0) {
    clear_current_link();
  }
  else {
    write_current_link();
  }
 }
}

/*****************************************************************************
  FUNCTION : delete_plane_PROC
 
  PURPOSE  : callback function, which deletes the Currenrt Plane out of
             the plane list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void delete_plane_PROC()
{
 delete_current_plane();
 if(PLANE_length == 0) {
   clear_current_plane();
 }
 else {
   write_current_plane();
 }
 if(LINK_length == 0) {
   clear_current_link();
 }
 else {
  write_current_link();
 }
}

/*****************************************************************************
  FUNCTION : forward_plane_PROC
 
  PURPOSE  : callback function, which moves forward one list element in the
             plane list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void forward_plane_PROC()
{
 if(forward_plane()){
   write_current_plane();
 }
}

/*****************************************************************************
  FUNCTION : backward_plane_PROC
 
  PURPOSE  : callback function, which moves backward one list element in the
             plane list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void backward_plane_PROC()
{
 if(backward_plane()) {
   write_current_plane();
 }
}

/*****************************************************************************
  FUNCTION : end_plane_PROC
 
  PURPOSE  : callback function, which jumps to the end of the plane list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void end_plane_PROC()
{
 if(end_plane()) {
   write_current_plane();
 }
}

/*****************************************************************************
  FUNCNCTION : beginning_plane_PROC
 
  PURPOSE  : callback function, which jumps to the beginning of the plane list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void beginning_plane_PROC()
{
 if(beginning_plane()) {
   write_current_plane();
 }
}

/*****************************************************************************
  FUNCNCTION : pos_PROC
 
  PURPOSE  : callback function, which defines the position of the plane in the
             display window.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void pos_PROC()
{
 if(PLANE_pos == BN_RIGHT) {
   PLANE_pos = BN_BELOW;
 }
 else if(PLANE_pos == BN_BELOW) {
   PLANE_pos = BN_LEFT;
 } 
 else {
   PLANE_pos = BN_RIGHT;
 }
 ui_xSetLabel(z7s3,plane_pos[PLANE_pos]);
}

/*****************************************************************************
  FUNCNCTION : current_plane_to_editor_PROC
 
  PURPOSE  : callback function, which writes the Current Plane to Edit Plane

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void current_plane_to_editor_PROC()
{
 if(PLANE_length != 0) {
   write_current_plane_to_editor();
 }
 else {
   clear_edit_plane();
 }
}

/*****************************************************************************
  FUNCNCTION : type_PROC
 
  PURPOSE  : callback function, which defines the unit type of a plane.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void type_PROC()
{
 switch(PLANE_type){
   case BN_INPUT : {PLANE_type = BN_HIDDEN; break;}
   case BN_HIDDEN: {PLANE_type = BN_OUTPUT; break;}
   case BN_OUTPUT: {PLANE_type = BN_INPUT ; break;}
 }
 ui_xSetLabel(z3s3,plane_type[PLANE_type]);
}

/*****************************************************************************
  FUNCTION : enter_plane
 
  PURPOSE  : enters a plane element at the end of the plane list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void enter_plane()

{
 PLANE *PLANE_element;

 PLANE_element = (PLANE *)malloc(sizeof(PLANE));
 (*PLANE_element).width      = PLANE_width;                                    
 (*PLANE_element).height      = PLANE_height;
 (*PLANE_element).pos    = PLANE_pos;
 (*PLANE_element).type   = PLANE_type;                                    
 (*PLANE_element).next   = NULL;                            
 (*PLANE_element).before = PLANE_last_element;         

 if(PLANE_last_element != NULL) {
   (*PLANE_last_element).next = PLANE_element;
 }

 if(PLANE_first_element == NULL) {
   PLANE_first_element = PLANE_element;
 }

 PLANE_last_element = PLANE_element;
 PLANE_current_element = PLANE_last_element;

 PLANE_no = ++PLANE_length;
}/* enter_plane */

/*****************************************************************************
  FUNCTION : insert_plane
 
  PURPOSE  : inserts the the input datas of the plane editor (Edit Plane) in 
             front of Current Plane.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void insert_plane()
{
 PLANE *PLANE_element;

 if(PLANE_length == 0) {
   enter_plane();
 }
 else {
   PLANE_element = (PLANE *)malloc(sizeof(PLANE));
   
   (*PLANE_element).width      = PLANE_width;                                    
   (*PLANE_element).height      = PLANE_height;
   (*PLANE_element).pos    = PLANE_pos;
   (*PLANE_element).type   = PLANE_type;                                    
   (*PLANE_element).next   = PLANE_current_element;                            
   (*PLANE_element).before = (*PLANE_current_element).before;

   if((*PLANE_current_element).before != 0) {
     (*(*PLANE_current_element).before).next = PLANE_element;
   }
   (*PLANE_current_element).before = PLANE_element;         

   PLANE_current_element = PLANE_element;
   
   if((*PLANE_element).before == NULL) {
     PLANE_first_element = PLANE_element;
   } 

   PLANE_length++;

   LINK_current_element = LINK_first_element; 

   while(LINK_current_element) {
     if((*LINK_current_element).SOURCE.plane >= PLANE_no) {
       (*LINK_current_element).SOURCE.plane++;
     }
     if((*LINK_current_element).TARGET.plane >= PLANE_no) {
       (*LINK_current_element).TARGET.plane++;
     }
     LINK_current_element = (*LINK_current_element).next;
   }

   LINK_current_element = LINK_last_element;

 }
}

/*****************************************************************************
  FUNCTION : overwrite_plane
 
  PURPOSE  : overwrites the current plane element (Current Plane) with the 
             datas of the plane editor (Edit Plane).

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void overwrite_plane()
{
 if(PLANE_length == 0) {
   enter_plane();
 }
 else {
   (*PLANE_current_element).width = PLANE_width;
   (*PLANE_current_element).height = PLANE_height;
   (*PLANE_current_element).pos = PLANE_pos;
   (*PLANE_current_element).type = PLANE_type;

   get_links_and_delete_them(PLANE_no);

   LINK_current_element = LINK_first_element;

 }
}

/*****************************************************************************
  FUNCTION : delete_current_plane
 
  PURPOSE  : deletes Currenrt Plane out of the plane list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

void delete_current_plane()
{
 PLANE *PLANE_element;

 PLANE_element = PLANE_current_element;

 /* Delete the element "PLANE_element" out of the plane-list */

 if(PLANE_length != 0) {
   if((*PLANE_element).before != NULL) {
     (*(*PLANE_element).before).next = (*PLANE_element).next;
   }
   if((*PLANE_element).next != NULL) {
     (*(*PLANE_element).next).before = (*PLANE_element).before;
   }

   /* Delete all the links which are connected with the deleted plane */
   
   get_links_and_delete_them(PLANE_no);

   LINK_current_element = LINK_first_element;

   /* Decrement the number of the Planes */

   while(LINK_current_element) {
     if((*LINK_current_element).SOURCE.plane > PLANE_no) {
       (*LINK_current_element).SOURCE.plane--;
     }
     if((*LINK_current_element).TARGET.plane > PLANE_no) {
       (*LINK_current_element).TARGET.plane--;
     }
     LINK_current_element = (*LINK_current_element).next;
   }

   LINK_current_element = LINK_last_element;

   PLANE_length--;

   /* Update the three pointers "PLANE_current_element", "PLANE_first_element"
      "PLANE_last_element."  */

   if(PLANE_length == 0){
     PLANE_current_element = NULL;
     PLANE_first_element   = NULL;
     PLANE_last_element    = NULL;
     PLANE_no--;
   }
   else if((*PLANE_element).next == NULL) {
     PLANE_current_element = (*PLANE_element).before;
     PLANE_last_element    = PLANE_current_element;
     PLANE_no--;
   }
   else if((*PLANE_element).before == NULL) {
     PLANE_current_element = (*PLANE_element).next;
     PLANE_first_element   = PLANE_current_element;
   }
   else {
     PLANE_current_element = (*PLANE_element).next;
   }

   free(PLANE_element);
 }
}

/*****************************************************************************
  FUNCTION : forward_plane
 
  PURPOSE  : moves forward one list element in the plane list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

int forward_plane()
{
 if(PLANE_length != 0) {
   if((*PLANE_current_element).next != NULL) {
     PLANE_current_element = (*PLANE_current_element).next;
     PLANE_no++;
   }
   return 1;
 }
 else {
  return 0;
 }
}

/*****************************************************************************
  FUNCTION : backward_link
 
  PURPOSE  : moves backward one plane element in the link list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

int backward_plane()
{
 if(PLANE_length != 0) {
   if((*PLANE_current_element).before != NULL) {
     PLANE_current_element = (*PLANE_current_element).before;
     PLANE_no--;
   }
   return 1;
 }
 else {
   return 0;
 }
}

/*****************************************************************************
  FUNCTION : beginning_plane
 
  PURPOSE  : jumps to the beginning of the plane list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/


int beginning_plane()
{
 if(PLANE_length != 0){
   PLANE_current_element = PLANE_first_element;
   PLANE_no = 1;
   return 1;
 }
 else {
  return 0;
 }
}

/*****************************************************************************
  FUNCTION : end_plane
 
  PURPOSE  : jumps to the end of the plane list.

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

int end_plane()
{
 if(PLANE_length != 0) {
   PLANE_current_element = PLANE_last_element;
   PLANE_no = PLANE_length;
   return 1;
 }
 else {
   return 0;
 }
}

/*****************************************************************************
  FUNCTION : get_plane
 
  PURPOSE  : returns a pointer to the plane element "plane_no"

  NOTES    : 

  UPDATE   : 20.12.1991
******************************************************************************/

PLANE *get_plane(plane_no)
int plane_no;

{
 PLANE *PLANE_element = PLANE_first_element;
 int counter = 1;

 while((PLANE_element != NULL) &&
       (counter != plane_no)) {
   counter++;
   PLANE_element = (*PLANE_element).next;
          
 }/*while*/
 return PLANE_element;
}/*get_plane*/




/* end of file */
/* lines: 710 */
