/*****************************************************************************
  FILE     : bn_types.c

  PURPOSE  : Global types of bignet.
  FUNCTIONS: 
  NOTES    : Part of the program bignet.

  AUTHOR   : Michael Schmalzl
  DATE     : 20.12.1991

  COPYRIGHT: (c) 1991 by Michael Schmalzl and the SNNS-Group
             
******************************************************************************/


#define BN_RIGHT  0
#define BN_BELOW  1
#define BN_LEFT   2

#define BN_INPUT 0
#define BN_OUTPUT 1
#define BN_HIDDEN 2

#define SOURCE_PLANE 1
#define SOURCE_CLUSTER 3
#define SOURCE_UNIT 5

#define TARGET_PLANE 8
#define TARGET_CLUSTER 17
#define TARGET_UNIT 33

#define PLANE_TO_PLANE 9
#define PLANE_TO_CLUSTER 26
#define PLANE_TO_UNIT 42
#define CLUSTER_TO_PLANE 12
#define CLUSTER_TO_CLUSTER 29
#define CLUSTER_TO_UNIT 45
#define UNIT_TO_PLANE 14
#define UNIT_TO_CLUSTER 31
#define UNIT_TO_UNIT 47

#define bn_widget_output(string) ((strcmp("0",string)==0) ? ("") : (string))

int BN_ERROR=0;

typedef struct plane {
  int width;
  int height;
  int pos;
  int type;
  int begin;
  struct plane *next;
  struct plane *before;
} PLANE;

void  current_plane_to_editor();
int  forward_plane();
int  backward_plane();
int  beginning_plane();
int  end_plane();
void  enter_plane();
void  insert_plane();
void  overwrite_plane();
void  delete_current_plane();
void  write_current_plane();
void  clear_edit_plane();
PLANE *get_plane();
int   read_plane_input();


char *plane_pos[] = {"right","below","left"};
char *plane_type[] = {"input","output","hidden"};

PLANE *PLANE_current_element = NULL;
PLANE *PLANE_first_element = NULL;
PLANE *PLANE_last_element = NULL;

int   PLANE_length = 0;
int   PLANE_no = 0;
int   PLANE_pos = BN_RIGHT;
int   PLANE_type = BN_INPUT;

int PLANE_width,PLANE_height;

typedef struct link {
  struct {
    int plane;
    struct {
      int x;
      int y;
      int width;
      int height;
    } CLUSTER;
    struct {
      int x;
      int y;
    } UNIT;
    struct {
      int delta_x;
      int delta_y;
    } MOVE;
  } SOURCE;
  struct {
    int plane;
    struct {
      int x;
      int y;
      int width;
      int height;
    } CLUSTER;
    struct {
      int x;
      int y;
    } UNIT;
    struct {
      int delta_x;
      int delta_y;
    } MOVE;
  } TARGET;
  int type_of_connection;
  int move;
  struct link *before;
  struct link *next;
} LINK;


void  current_link_to_editor();
int  forward_link();
int  backward_link();
int  beginning_link();
int  end_link();
void  enter_link();
void  overwrite_link();
void  delete_current_link();
void get_links_and_delete_them();
void clear_current_link();
void  write_current_link();
int  full_connection();
int  shortcut_connection();







LINK *LINK_current_element = NULL;
LINK *LINK_first_element = NULL;
LINK *LINK_last_element = NULL;

int LINK_length=0;

int LINK_move,LINK_type_of_connection;

int LINK_source_move_delta_x,LINK_source_move_delta_y,LINK_target_move_delta_x,LINK_target_move_delta_y;

int LINK_source_plane,LINK_source_cluster_x,LINK_source_cluster_y,LINK_source_cluster_width,
    LINK_source_cluster_height,LINK_source_unit_x,LINK_source_unit_y;

int LINK_target_plane,LINK_target_cluster_x,LINK_target_cluster_y,LINK_target_cluster_width,
    LINK_target_cluster_height,LINK_target_unit_x,LINK_target_unit_y;





void bn_display_net();
void make_move_link();
void make_link();
void calculate_first_snns_unit_no_of_plane();
void create_snns_unit();





/* end of file */
/* lines: 178 */
