/*****************************************************************************
  FILE     : d3_disp.c
  SHORTNAME: disp.c

  PURPOSE  : event handler and creation of the display window
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Ralf Huebner
  DATE     : 1.12.1991

             (c) 1992 by Ralf Huebner and the SNNS-Group
             
******************************************************************************/



#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Cardinals.h>

#include "ui.h"
#include "ui_xGraphic.h"


extern Widget ui_toplevel;
extern Display *ui_display;
extern XtAppContext ui_appContext;

extern Display *d3_display;
extern Window d3_window;
extern GC d3_gc;
extern int d3_screen;

Widget d3_displayMainWidget;

extern bool d3_displayIsReady;
extern int d3_displayXsize;
extern int d3_displayYsize;

extern unsigned d3_textColor;




/*****************************************************************************
  FUNCTION : d3_eventProc

  PURPOSE  : this is the event handler of the display window
  RETURNS  : 
  NOTES    :

******************************************************************************/


void d3_eventProc (w, display, event)

    Widget w;
    Display *display;
    XEvent *event;

{

    static int doExpose = TRUE;

    switch (event->type)
      {
        case MapNotify:
               break;    
        case UnmapNotify:
               break;
        case Expose:
               if (event->xexpose.count == 0)
                 {
                   if (doExpose)
                     {
                       d3_drawNet ();
                     }
                   else
                     { 
                       doExpose = TRUE;
                     }
                 }
               break;
        case VisibilityNotify:
               break;
        case ConfigureNotify:
               d3_recenter_window (event->xconfigure.width, 
                                  event->xconfigure.height);
               d3_drawNet ();
               doExpose = FALSE;
               break;
        case CirculateNotify:
               break;
        
      }
}





/*****************************************************************************
  FUNCTION : d3_createDisplayWindow

  PURPOSE  : creates the display window
  RETURNS  : 
  NOTES    :

******************************************************************************/



void d3_createDisplayWindow ()

{
    Widget       d3_frameWidget, d3_displayWidget;
    Arg          arg[25];
    Cardinal     n;
    char         buf[40];
    unsigned long foreground, background;

    if (d3_displayIsReady)
        return;

    sprintf (buf, "3D-display");

    n = 0;  
    d3_displayMainWidget = XtCreatePopupShell (buf, topLevelShellWidgetClass, 
                                               ui_toplevel, NULL, ZERO); 
    d3_frameWidget = XtCreateManagedWidget ("form", formWidgetClass, 
                                            d3_displayMainWidget, NULL, ZERO);

    n = 0;  
    XtSetArg (arg[n], XtNwidth, d3_displayXsize); n++;
    XtSetArg (arg[n], XtNheight, d3_displayYsize); n++;
    d3_displayWidget = XtCreateManagedWidget("display", boxWidgetClass, 
                                             d3_frameWidget, arg, n);

    XtAddEventHandler (d3_displayWidget, StructureNotifyMask | ExposureMask, 
                       FALSE, d3_eventProc, ui_display);

    XtPopup (d3_displayMainWidget, XtGrabNone);
    XtAddEventHandler (d3_displayWidget, StructureNotifyMask | ExposureMask, 
                       FALSE, d3_eventProc, ui_display);

    d3_display = ui_display; 
    d3_window = XtWindow (d3_displayWidget);
    d3_gc = XCreateGC (d3_display, d3_window, ZERO, NULL);
    d3_screen = DefaultScreen (d3_display);

    background = WhitePixel (d3_display, d3_screen);
    foreground = BlackPixel (d3_display, d3_screen);
    XSetBackground (d3_display, d3_gc, background);
    XSetForeground (d3_display, d3_gc, foreground);
    d3_textColor = foreground;

    ui_xToggleBackingStore (TRUE, d3_display, d3_window);

    d3_displayIsReady = TRUE;



}















/* end of file */
/* lines: 190 */
