/*****************************************************************************
  FILE     : d3_dither.c
  SHORTNAME: dither.c

  PURPOSE  : dithering of graylevels on a monochrome display
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Ralf Huebner
  DATE     : 1.12.1991

             (c) 1992 by Ralf Huebner and the SNNS-Group
             
******************************************************************************/


#define DITHER8x8

#ifdef DITHER8x8

static int size = 8;

static int dither_matrix[] = {
       0,  48,  12,  60,   3,  51,  15,  63,
      32,  16,  44,  28,  35,  19,  47,  31,
       8,  56,   4,  52,  11,  59,   7,  55,
      40,  24,  36,  20,  43,  27,  39,  23,
       2,  50,  14,  62,   1,  49,  13,  61,
      34,  18,  46,  30,  33,  17,  45,  29,
      10,  58,   6,  54,   9,  57,   5,  53,
      42,  26,  38,  22,  41,  25,  37,  21
};

#else

static int size = 4;

static int dither_matrix[] = {
       0,  12,   3,  15,
       8,   4,  11,   7,
       2,  14,   1,  13,
      10,   6,   9,   5
};

#endif




/*****************************************************************************
  FUNCTION : dither

  PURPOSE  : calculate the dither value
  RETURNS  : 0 if black or 1 if white
  NOTES    :

******************************************************************************/


int dither (x, y, level)

    int x, y;
    float level;

{
    return (level * size*size > dither_matrix[(x % size) + size * (y % size)]);
}


/* end of file */
/* lines: 71 */
