/*****************************************************************************
  FILE     : d3_fonts.c
  SHORTNAME: fonts.c

  PURPOSE  : font selection and character drawing
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Ralf Huebner
  DATE     : 1.12.1991

             (c) 1992 by Ralf Huebner and the SNNS-Group
             
******************************************************************************/



#include <stdio.h>

#include "d3_global.h"
#include "d3_fonts.h"
#include "d3_point.h"
#include "d3_zgraph.h"

#include "d3_font5x7.c"
#include "d3_font5x8.c"
#include "d3_font8x14.c"


extern d3_state_type d3_state;
extern unsigned d3_textColor;

static int width, height;
static char *font;



/*****************************************************************************
  FUNCTION : d3_select_font

  PURPOSE  : select a font
  RETURNS  : 
  NOTES    : set width and height of the font

******************************************************************************/


void d3_select_font (selected_font)

    int selected_font;

{
    switch (selected_font) {
       case fnt5x7:  font = font5x7; 
                     width = font5x7_width;
                     height = font5x7_height;
                     break;
       case fnt5x8:  font = font5x8; 
                     width = font5x8_width;
                     height = font5x8_height;
                     break;
       default:      font = font8x14; 
                     width = font8x14_width;
                     height = font8x14_height;
                     break;
    }

}





/*****************************************************************************
  FUNCTION : d3_get_font_size

  PURPOSE  : gets the width and height of the current font
  RETURNS  : width and height
  NOTES    :

******************************************************************************/


void d3_get_font_size (x, y)

    int *x, *y;

{
    *x = width;
    *y = height;
}



/*****************************************************************************
  FUNCTION : draw_char

  PURPOSE  : draws the charcter c at (xpos, ypos)
  RETURNS  : 
  NOTES    :

******************************************************************************/


static void draw_char (xpos, ypos, ch)

     int xpos, ypos;
     unsigned char ch;

{
     int xsize, ysize, index, dx, dy;
     unsigned char b;


     xsize = width - 1;
     ysize = height - 1;
     index = height * ch;

     for (dy=0; dy<=ysize; dy++) {
         b = font[index];
         for (dx=0; dx<=xsize; dx++) {
             if ((b >> (7-dx)) & 0x01)
                 d3_putPixel (xpos+dx, ypos+dy);
         }
         index++;
     }
}



/*****************************************************************************
  FUNCTION : draw_zbuffered_char

  PURPOSE  : draws the z-bufferd charcter c at (xpos, ypos, zpos)
  RETURNS  : 
  NOTES    :

******************************************************************************/



static draw_zbuffered_char (xpos, ypos, zpos, ch)

     int xpos, ypos;
     float zpos;
     unsigned char ch;

{
     int xsize, ysize, index, dx, dy, xp, yp;
     float zp;
     unsigned char b;


     xsize = width - 1;
     ysize = height - 1;
     index = height * ch;

     for (dy=0; dy<=ysize; dy++) {
         b = font[index];
         for (dx=0; dx<=xsize; dx++) {
             if ((b >> (7-dx)) & 0x01) {
                 xp = xpos + dx;
                 yp = ypos + dy;
                 d3_readZbuffer (xp, yp, &zp);
                 if (zpos < zp) {
                     d3_putPixel(xp, yp);
                    d3_writeZbuffer (xp, yp, zpos);
                 }
	     }
         }
         index++;
     }
}



/*****************************************************************************
  FUNCTION : d3_draw_string

  PURPOSE  : draws a string
  RETURNS  : 
  NOTES    : check wether z buffering is active

******************************************************************************/



void d3_draw_string (xpos, ypos, zpos, s)

    int xpos, ypos;
    float zpos; 
    char *s;

{
    d3_setBlackColor ();
    if (d3_state.model_mode == solid)
        for (; *s!=NULL; s++) {
           draw_zbuffered_char (xpos, ypos, zpos, (char) *s);
           xpos += width + 1;
	}
    else
        for (; *s!=NULL; s++) {
           draw_char (xpos, ypos, (char) *s);
           xpos += width + 1;
	}
    
}



/* end of file */
/* lines: 212 */
