/*****************************************************************************
  FILE     : d3_global.c
  SHORTNAME: global.c

  PURPOSE  : global variables declaration  
  FUNCTIONS: 
  NOTES    : this is the only module for global variables
           : most varaibles are initilized
           : the default values could be changed here

  AUTHOR   : Ralf Huebner
  DATE     : 1.12.1991

             (c) 1992 by Ralf Huebner and the SNNS-Group
             
******************************************************************************/


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/Xutil.h>


#include "ui.h"
#include "d3_global.h"



/* Xlib and Xaw Variables */

Display      *d3_display;
Window        d3_window;
GC            d3_gc;
int           d3_screen;




/* Varibles to control the Windows */

int d3_displayXsize = 400;
int d3_displayYsize = 400;

bool d3_displayIsReady = FALSE;
bool d3_controlIsReady = FALSE;

bool d3_freeze = FALSE;

int d3_fontXsize, d3_fontYsize;

int d3_numberWidth = d3_fontWidth * 9;
int d3_shortNumberWidth = d3_fontWidth * 6;

unsigned d3_textColor;
float d3_intens;




/* the 2d -> 3d mapping table */

int d3_transOffset;

struct TransTable *d3_xyTransTable;




/* the initial state structure */


d3_state_type  d3_state = {
    {0.0, 0.0, 0.0},               /* trans_vec         */
    {0.0, 0.0, 0.0},               /* rot_vec           */
    {1.0, 1.0, 1.0},               /* scale_vec         */
    {10.0, 10.0, 10.0},            /* trans_step        */
    {rad(10), rad(10), rad(10)},   /* rot_step          */
    {1.1, 1.1, 1.1},               /* scale_step        */
    {0.0, 0.0, -1000},             /* viewpoint         */
    0.5,                           /* unit_aspect       */
    1.0,                           /* link_scale        */
    fnt8x14,                       /* font              */
    parallel,                      /* projection_mode   */
    wire_frame,                    /* model_mode        */
    rgb_mode,                      /* color_mode        */ 
    links_off,                     /* link_mode         */
    {                              /* unit_mode         */
         nothing_on,
         nothing_on,
         nothing_on,
         nothing_on
    },             
    {                              /* light_mode        */
         shade_constant,
         {0.0, 0.0, -1000.0, 1.0},
         0.2,      /* Ia */
         1.0,      /* Ka */
         0.7,      /* Ip */
         1.0       /* Kd */
    }
};



/* unit cube  */



cube d3_e_cube = {
    { 0.5,  0.5, -0.5,  0.5},
    { 0.5,  0.5,  0.5,  0.5},
    {-0.5,  0.5,  0.5,  0.5},
    {-0.5,  0.5, -0.5,  0.5},
    { 0.5, -0.5, -0.5,  0.5},
    { 0.5, -0.5,  0.5,  0.5},
    {-0.5, -0.5,  0.5,  0.5},
    {-0.5, -0.5, -0.5,  0.5},
    { 0.0,  0.0,  0.0,  0.5}
};
			         



/* indices for all lines in a cube */


int d3_cube_lines [ANZ_LINES][ANZ_PKT_LINE] = {
    {0, 1},
    {0, 3},
    {1, 2},
    {3, 2},
    {4, 5},
    {4, 7},
    {5, 6},
    {7, 6},
    {0, 4},
    {1, 5},
    {2, 6},
    {3, 7}
};



/* indices for the surface */

int d3_vertex_index[ANZ_FACETS][ANZ_PKT_FACETS] = {
    {0, 1, 2, 3},
    {0, 4, 5, 1},
    {1, 5, 6, 2},
    {7, 6, 5, 4},
    {2, 6, 7, 3},
    {0, 3, 7, 4}
};






/* end of file */
/* lines: 162 */
