/*****************************************************************************
  FILE     : d3_lists.c
  SHORTNAME: lists.c

  PURPOSE  : create a linear list
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Ralf Huebner
  DATE     : 1.12.1991

             (c) 1992 by Ralf Huebner and the SNNS-Group
             
******************************************************************************/

#include <stdio.h>
#include <malloc.h>

#include "d3_global.h"
#include "d3_lists.h"



/*****************************************************************************
  FUNCTION : d3_insertUnit

  PURPOSE  : creates a new list entry
  RETURNS  : a pointer to the new list
  NOTES    :

******************************************************************************/


void d3_insertUnit (list, num)

    d3_unitPtrType **list;
    int num;

{
    d3_unitPtrType *new_elem;

    new_elem = (d3_unitPtrType *) malloc (sizeof (d3_unitPtrType));
    if (new_elem == NULL)
      {
         fprintf (stdout, "D3-Error: Not Enough Memory\n\n");
         return;
      }
    new_elem->unitNo = num;
    new_elem->next = *list;
    *list = new_elem;
}



/*****************************************************************************
  FUNCTION : d3_displayUnitList

  PURPOSE  : writes a list to stdout
  RETURNS  : 
  NOTES    :

******************************************************************************/


void d3_displayUnitList (list)

    d3_unitPtrType *list;

{
    while (list != NULL)
      {
        fprintf (stdout, "%7d", list->unitNo);
        list = list->next;
      }
    fprintf (stdout, "\n");
}


    


/* end of file */
/* lines: 83 */
