/*****************************************************************************
  FILE     : d3_model.c
  SHORTNAME: model.c

  PURPOSE  : controls the model pannel
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Ralf Huebner
  DATE     : 1.12.1991

             (c) 1992 by Ralf Huebner and the SNNS-Group
             
******************************************************************************/



#include <stdio.h>
#include <memory.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Toggle.h>

#include "ui_xWidgets.h"
#include "d3_global.h"
#include "d3_xUtils.h"

extern d3_state_type d3_state;


static Widget solidButton, wireButton;

static d3_state_type temp_state;





/*****************************************************************************
  FUNCTION : setModelToggleState

  PURPOSE  : sets the toggles in the model pannel
  RETURNS  : 
  NOTES    :

******************************************************************************/


static void setModelToggleState ()


{
    switch (temp_state.model_mode) {
        case wire_frame: ui_xSetToggleState (wireButton, TRUE);
                         ui_xSetToggleState (solidButton, FALSE);
                         break;
        case solid     : ui_xSetToggleState (wireButton, FALSE);
                         ui_xSetToggleState (solidButton, TRUE);
                         break;
      }
}




/*****************************************************************************
  FUNCTION : d3_closeModelPannel

  PURPOSE  : closes the model pannel
  RETURNS  : 
  NOTES    :

******************************************************************************/


static void d3_closeModelPannel (w, pannel, call_data)

    Widget w;
    Widget pannel;
    caddr_t call_data;

{
    XtDestroyWidget (pannel);
    if (memcmp (&d3_state, &temp_state, 
                sizeof (d3_state_type)) != 0) {
         memcpy (&d3_state, &temp_state, 
                 sizeof (d3_state_type)); 
         d3_drawNet ();
    }
}




/*****************************************************************************
  FUNCTION : setModelWire

  PURPOSE  : sets mode to draw a wireframe net
  RETURNS  : 
  NOTES    :

******************************************************************************/


static void setModelWire ()

{
    temp_state.model_mode = wire_frame;
    setModelToggleState (); 
    d3_freeZbuffer ();
}





/*****************************************************************************
  FUNCTION : setModelSolid

  PURPOSE  : sets mode to draw a solid net
  RETURNS  : 
  NOTES    :

******************************************************************************/


static void setModelSolid ()

{
    if (d3_initZbuffer ()) {
        temp_state.model_mode = solid;
        setModelToggleState ();
    }
}





/*****************************************************************************
  FUNCTION : d3_createModelPannel

  PURPOSE  : creates the model pannel
  RETURNS  : 
  NOTES    :

******************************************************************************/


void d3_createModelPannel (w, button, call_data)

    Widget w;
    Widget button;
    caddr_t call_data;

{
    int n;
    Arg arg[10];
    char buf[20];
    Position xPos, yPos;
    Dimension width, height;
    Widget modelPannel, border, pannel, doneButton;


    n = 0;
    XtSetArg (arg[n], XtNwidth, &width);   n++;
    XtSetArg (arg[n], XtNheight, &height); n++;
    XtGetValues (button, arg, n);
    XtTranslateCoords (button, (Position) (width / 2), (Position) (height / 2), 
                       &xPos, &yPos);

    n = 0;
    XtSetArg(arg[n], XtNx, xPos); n++;
    XtSetArg(arg[n], XtNy, yPos); n++;
    modelPannel = XtCreatePopupShell ("model", transientShellWidgetClass, 
                                      button, arg, n);

    border = XtCreateManagedWidget("border", boxWidgetClass, 
                                   modelPannel, NULL, ZERO);
    pannel = XtCreateManagedWidget("pannel", boxWidgetClass, 
                                   border, NULL, ZERO);

    wireButton = d3_xCreateToggleItem ("wire", pannel, NULL, NULL, NULL);
    solidButton = d3_xCreateToggleItem ("solid", pannel, NULL, NULL, wireButton);
    doneButton = d3_xCreateButtonItem ("done", border, NULL, NULL, NULL);

    XtAddCallback (wireButton, XtNcallback, setModelWire, NULL);
    XtAddCallback (solidButton, XtNcallback, setModelSolid, NULL);
    XtAddCallback (doneButton, XtNcallback, d3_closeModelPannel, 
                   (Widget) modelPannel);

    memcpy (&temp_state, &d3_state, sizeof (d3_state_type)); 

    setModelToggleState ();

    XtPopup (modelPannel, XtGrabExclusive);
}


/* end of file */
/* lines: 208 */
