/*****************************************************************************
  FILE     : d3_move.c
  SHORTNAME: move.c

  PURPOSE  : create the pannels for rotation, translation and scale
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Ralf Huebner
  DATE     : 1.12.1991

             (c) 1992 by Ralf Huebner and the SNNS-Group
             
******************************************************************************/


#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Toggle.h>

#include "ui_xWidgets.h"
#include "d3_global.h"
#include "d3_xUtils.h"

extern d3_state_type d3_state;

extern int d3_numberWidth;

extern int d3_freeze;


static int border = 10;
static int button_size = 16;





/*****************************************************************************
  FUNCTION : d3_transform

  PURPOSE  : sets the state vectors to a new movement
  RETURNS  : new state variable
  NOTES    : callback for all procedures in this module

******************************************************************************/



static void d3_transform  (w, transformation, call_data)

    Widget w;
    int transformation;
    caddr_t call_data;

{
    int i;

    if (d3_freeze) 
        return;
    switch (transformation) {
        case ROT_X_LEFT    : d3_state.rot_vec [0] -= d3_state.rot_step [0];
                             break;
        case ROT_X_RIGHT   : d3_state.rot_vec [0] += d3_state.rot_step [0];
                             break;
        case ROT_Y_LEFT    : d3_state.rot_vec [1] -= d3_state.rot_step [1];
                             break;
        case ROT_Y_RIGHT   : d3_state.rot_vec [1] += d3_state.rot_step [1];
                             break;
        case ROT_Z_LEFT    : d3_state.rot_vec [2] -= d3_state.rot_step [2];
                             break;
        case ROT_Z_RIGHT   : d3_state.rot_vec [2] += d3_state.rot_step [2];
                              break;
        case TRANS_X_LEFT  : d3_state.trans_vec [0] -= d3_state.trans_step [0];
                             break;
        case TRANS_X_RIGHT : d3_state.trans_vec [0] += d3_state.trans_step [0];
                             break;
        case TRANS_Y_LEFT  : d3_state.trans_vec [1] -= d3_state.trans_step [1];
                             break;
        case TRANS_Y_RIGHT : d3_state.trans_vec [1] += d3_state.trans_step [1];
                             break;
        case TRANS_Z_LEFT  : d3_state.trans_vec [2] -= d3_state.trans_step [2];
                             break;
        case TRANS_Z_RIGHT : d3_state.trans_vec [2] += d3_state.trans_step [2];
                             break;
        case SCALE_PLUS    : for (i=0; i<3; i++) {
                                 d3_state.scale_vec [i] *= d3_state.scale_step [0]; 
			     }
                             break;
        case SCALE_MINUS   : for (i=0; i<3; i++) {
                                 d3_state.scale_vec [i] /= d3_state.scale_step [0]; 
			     }
                             break;
    }
    d3_drawNet ();
}






/*****************************************************************************
  FUNCTION : create_box_item

  PURPOSE  : creates the border box for the move pannels
  RETURNS  : the box widget
  NOTES    :

******************************************************************************/


static void create_box_item (height, width, parent, left, top, box)

    int height, width;
    Widget parent, left, top;
    Widget *box;

{
    int n;
    Arg arg[20];
  
    n = 0;
    XtSetArg(arg[n], XtNx, border);                        n++;
    XtSetArg(arg[n], XtNy, border);                        n++;
    XtSetArg(arg[n], XtNfromVert , left);                  n++;
    XtSetArg(arg[n], XtNfromHoriz, top);                   n++;
    XtSetArg(arg[n], XtNheight, height);                   n++;
    XtSetArg(arg[n], XtNwidth, width);                     n++;
    XtSetArg(arg[n], XtNleft  , XtChainLeft);              n++;
    XtSetArg(arg[n], XtNright , XtChainRight);             n++;
    XtSetArg(arg[n], XtNtop   , XtChainTop);               n++;
    XtSetArg(arg[n], XtNbottom, XtChainBottom);            n++;
    *box = XtCreateManagedWidget("box", boxWidgetClass, parent, arg, n);
}





/*****************************************************************************
  FUNCTION : create_scale_button

  PURPOSE  : creates a single scale button
  RETURNS  : scale widget
  NOTES    :

******************************************************************************/


static void create_scale_button (label, parent, xsize, ysize, button)

    char *label;
    Widget parent;
    int xsize, ysize;
    Widget *button;
    
{
    int n;
    Arg arg[10];

    n = 0;
    XtSetArg(arg[n], XtNx, border);                        n++;
    XtSetArg(arg[n], XtNy, border);                        n++;
    XtSetArg(arg[n], XtNheight, ysize);                       n++;
    XtSetArg(arg[n], XtNwidth, xsize);                        n++;
    XtSetArg(arg[n], XtNlabel, label);                       n++;
    *button = XtCreateManagedWidget("button", commandWidgetClass, parent, arg, n);

}




/*****************************************************************************
  FUNCTION : create_move_label

  PURPOSE  : creates a label for a single pannel
  RETURNS  : 
  NOTES    :

******************************************************************************/


static void create_move_label (label, parent)

    char *label;
    Widget parent;

{
    Widget label_widget;
    int n;
    Arg arg[10];
    int xwdth = 78;

    n = 0;
    XtSetArg(arg[n], XtNborderWidth, 0); n++;
    XtSetArg(arg[n], XtNwidth, xwdth);                       n++;  
    XtSetArg(arg[n], XtNlabel, label);                       n++;

    XtSetArg(arg[n], XtNfromVert , NULL);  n++;
    XtSetArg(arg[n], XtNfromHoriz, NULL);  n++;

    XtSetArg(arg[n], XtNleft  , XtChainLeft); n++;
    XtSetArg(arg[n], XtNright , XtChainRight); n++;
    XtSetArg(arg[n], XtNtop   , XtChainTop); n++;
    XtSetArg(arg[n], XtNbottom, XtChainBottom); n++;

    label_widget = XtCreateManagedWidget("label", labelWidgetClass, parent, arg, n);

}



/*****************************************************************************
  FUNCTION : create_move_item

  PURPOSE  : creates a single entry for the trans and rotate pannels
  RETURNS  : the 'greater' and 'smaller' widgets
  NOTES    :

******************************************************************************/


static void create_move_item (label, parent, le_widget, ge_widget)

    char *label;
    Widget parent;
    Widget *le_widget, *ge_widget;

{
    Widget label_widget;
    int n;
    Arg arg[10];

    n = 0;
    XtSetArg(arg[n], XtNx, border);                        n++;
    XtSetArg(arg[n], XtNy, border);                        n++;
    XtSetArg(arg[n], XtNheight, button_size);              n++;
    XtSetArg(arg[n], XtNwidth, button_size);               n++;
    XtSetArg(arg[n], XtNlabel, "-");                       n++;
    *le_widget = XtCreateManagedWidget("le", commandWidgetClass, parent, arg, n);

    n = 0;
    XtSetArg(arg[n], XtNx, border);                        n++;
    XtSetArg(arg[n], XtNy, border);                        n++;
    XtSetArg(arg[n], XtNheight, button_size );             n++;
    XtSetArg(arg[n], XtNwidth, 2 * button_size);           n++;
    XtSetArg(arg[n], XtNlabel, label);                     n++;
    label_widget = XtCreateManagedWidget("hot", labelWidgetClass, parent, arg, n);

    n = 0;
    XtSetArg(arg[n], XtNx, border);                        n++;
    XtSetArg(arg[n], XtNy, border);                        n++;
    XtSetArg(arg[n], XtNheight, button_size);              n++;
    XtSetArg(arg[n], XtNwidth, button_size);               n++;
    XtSetArg(arg[n], XtNlabel, "+");                       n++;
    *ge_widget = XtCreateManagedWidget("ge", commandWidgetClass, parent, arg, n);

}






/*****************************************************************************
  FUNCTION : create_rotatePannel

  PURPOSE  : creates the pannel and callbacks for the rotation
  RETURNS  : 
  NOTES    :

******************************************************************************/




static void create_rotatePannel (rotate_widget)

    Widget rotate_widget;

{
    Widget label, ge_widget, le_widget;


    create_move_label ("rotate", rotate_widget);

    create_move_item (" X ", rotate_widget, &le_widget, &ge_widget);
    XtAddCallback(le_widget, XtNcallback, d3_transform, (int) ROT_X_LEFT);
    XtAddCallback(ge_widget, XtNcallback, d3_transform, (int) ROT_X_RIGHT);
 
    create_move_item (" Y ", rotate_widget, &le_widget, &ge_widget);
    XtAddCallback(le_widget, XtNcallback, d3_transform, (int) ROT_Y_LEFT);
    XtAddCallback(ge_widget, XtNcallback, d3_transform, (int) ROT_Y_RIGHT);

    create_move_item (" Z ", rotate_widget, &le_widget, &ge_widget);
    XtAddCallback(le_widget, XtNcallback, d3_transform, (int) ROT_Z_LEFT);
    XtAddCallback(ge_widget, XtNcallback, d3_transform, (int) ROT_Z_RIGHT);

}  




/*****************************************************************************
  FUNCTION : create_transPannel

  PURPOSE  : creates the pannel and callbacks for the translation
  RETURNS  : 
  NOTES    :

******************************************************************************/


static void create_transPannel (trans_widget)

    Widget trans_widget;

{
    Widget label, ge_widget, le_widget;


    create_move_label ("trans", trans_widget);

    create_move_item (" X ", trans_widget, &le_widget, &ge_widget);
    XtAddCallback(le_widget, XtNcallback, d3_transform, (int) TRANS_X_LEFT);
    XtAddCallback(ge_widget, XtNcallback, d3_transform, (int) TRANS_X_RIGHT);
 
    create_move_item (" Y ", trans_widget, &le_widget, &ge_widget);
    XtAddCallback(le_widget, XtNcallback, d3_transform, (int) TRANS_Y_LEFT);
    XtAddCallback(ge_widget, XtNcallback, d3_transform, (int) TRANS_Y_RIGHT);

    create_move_item (" Z ", trans_widget, &le_widget, &ge_widget);
    XtAddCallback(le_widget, XtNcallback, d3_transform, (int) TRANS_Z_LEFT);
    XtAddCallback(ge_widget, XtNcallback, d3_transform, (int) TRANS_Z_RIGHT);

}  





/*****************************************************************************
  FUNCTION : create_scalePannel

  PURPOSE  : creates the pannel for scale
  RETURNS  : 
  NOTES    :

******************************************************************************/



static void create_scalePannel (scale_widget)

    Widget scale_widget;

{
    Widget ge_widget, le_widget;
    int xsize = 35, ysize = 60;

    
    create_move_label ("scale", scale_widget);

    create_scale_button ("-", scale_widget, xsize, ysize, &le_widget);
    create_scale_button ("+", scale_widget, xsize, ysize, &ge_widget);

    XtAddCallback(ge_widget, XtNcallback, d3_transform, (int) SCALE_PLUS);
    XtAddCallback(le_widget, XtNcallback, d3_transform, (int) SCALE_MINUS);
}






/*****************************************************************************
  FUNCTION : d3_createMovePannel

  PURPOSE  : creates the pannels for for rotation, translation and scale
  RETURNS  : 
  NOTES    :

******************************************************************************/



void d3_createMovePannel (parent)

    Widget parent;

{
    Widget scale, rotate, trans;
    int height = 70;
    int width = 100;

    create_box_item (height, width, parent, NULL, NULL, &rotate);
    create_rotatePannel (rotate);

    create_box_item (height, width, parent, rotate, NULL, &trans);
    create_transPannel (trans);

    create_box_item (height, width, parent, trans, NULL, &scale);
    create_scalePannel (scale);
}  





/* end of file */
/* lines: 421 */
