/*****************************************************************************
  FILE     : d3_point.c
  SHORTNAME: point.c

  PURPOSE  : low level pixel IO
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Ralf Huebner
  DATE     : 1.12.1991

             (c) 1992 by Ralf Huebner and the SNNS-Group
             
******************************************************************************/



#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

#include "d3_global.h"

extern Display      *d3_display;
extern Window        d3_window;
extern GC            d3_gc;
extern int           d3_screen;

extern d3_state_type  d3_state;
extern float d3_intens;

#undef BUFFERED_IO

#define POINT_BLOCK_SIZE  1024

static XPoint points[POINT_BLOCK_SIZE];
static int point_count = 0;



#ifdef BUFFERED_IO



/*****************************************************************************
  FUNCTION : d3_putPixel

  PURPOSE  : draw a pixel
  RETURNS  : 
  NOTES    : the pixels are buffered in the points array

******************************************************************************/


void d3_putPixel (xp, yp)

    int xp, yp;


{
    unsigned long color;

    points[point_count].x = (short) xp;
    points[point_count].y = (short) yp;
    point_count++;
    if (point_count == POINT_BLOCK_SIZE) {
        XDrawPoints (d3_display, d3_window, d3_gc, points, 
                     point_count, 0);
        point_count = 0;
    }
}



/*****************************************************************************
  FUNCTION : d3_flushPixels

  PURPOSE  : draw the remaining pixels
  RETURNS  : 
  NOTES    :

******************************************************************************/



void d3_flushPixels ()

{
    XDrawPoints (d3_display, d3_window, d3_gc, points, 
                 point_count, 0);
    point_count = 0;
}



#else




/*****************************************************************************
  FUNCTION : d3_putPixel

  PURPOSE  : draw a pixel
  RETURNS  : 
  NOTES    :

******************************************************************************/


void d3_putPixel (xp, yp)

    int xp, yp;


{
    XDrawPoint (d3_display, d3_window, d3_gc, xp, yp);
}




/*****************************************************************************
  FUNCTION : d3_putColPixel

  PURPOSE  : draw a color pixel
  RETURNS  : 
  NOTES    : dither if monchrome mode

******************************************************************************/



void d3_putColPixel (xp, yp)

    int xp, yp;


{
    unsigned long color;

    if (d3_state.color_mode == mono_mode) {
        if (dither (xp, yp, d3_intens))
            color = WhitePixel (d3_display, d3_screen);
        else
            color = BlackPixel (d3_display, d3_screen);
        XSetForeground(d3_display, d3_gc, color); 
    }
    XDrawPoint (d3_display, d3_window, d3_gc, xp, yp);
}



/*****************************************************************************
  FUNCTION : d3_flushPixels

  PURPOSE  :
  RETURNS  : 
  NOTES    :

******************************************************************************/




void d3_flushPixels ()

{
}


#endif



/* end of file */
/* lines: 178 */
