/*****************************************************************************
  FILE     : d3_shade.c
  SHORTNAME: shade.c

  PURPOSE  : illumination of an unit
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Ralf Huebner
  DATE     : 1.12.1991

             (c) 1992 by Ralf Huebner and the SNNS-Group
             
******************************************************************************/


#include <math.h>

#include "d3_global.h"
#include "d3_anageo.h"



extern d3_state_type d3_state;



/*****************************************************************************
  FUNCTION : d3_shadeIntens

  PURPOSE  : calculate the light intensity for a given polygon
  RETURNS  : -1.0 <= intensity <= 1.0
  NOTES    : 

******************************************************************************/



void d3_shadeIntens (intens, v1, normal, lp)

     float *intens;
     vector v1, normal, lp;

{
     vector lv;
     float cos_a;
     int i;

     for (i=0; i<3; i++)
         lv[i] = v1[i] + lp[i];
     lv[3] = sqrt (lv[0]*lv[0] + lv[1]*lv[1] + lv[2]*lv[2]);

     cos_a = (normal[0] * lv[0] + normal[1] * lv[1] + normal[2] * lv[2]) /
             (normal[3] * lv[3]);

     *intens = d3_state.light.Ia * d3_state.light.Ka;
     if (cos_a < 0.0)
         *intens -= d3_state.light.Ip * d3_state.light.Kd * cos_a;
     if (*intens > 1.0)
         *intens = 1.0;
     if (*intens < -1.0)
         *intens = -1.0;
}



/* end of file */
/* lines: 68 */
