/*****************************************************************************
  FILE     : d3_zValue.c
  SHORTNAME: zValue.c

  PURPOSE  : creates the Z-value pannel
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Ralf Huebner
  DATE     : 1.12.1991

             (c) 1992 by Ralf Huebner and the SNNS-Group
             
******************************************************************************/


#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Toggle.h>

#include "ui_xWidgets.h"
#include "d3_global.h"
#include "d3_xUtils.h"

extern d3_state_type d3_state;
extern short ui_actualZvalue;
extern XtAppContext ui_appContext;

extern int d3_shortNumberWidth;




static Widget z_valueWidget;



/*****************************************************************************
  FUNCTION : d3_readZvalue

  PURPOSE  : read the current z-value form the widget
  RETURNS  : 
  NOTES    :

******************************************************************************/


static void d3_readZvalue (w, pannel, call_data)

    Widget w;
    Widget pannel;
    caddr_t call_data;

{
    ui_actualZvalue = (short) ui_xIntFromAsciiWidget (z_valueWidget);
}




/*****************************************************************************
  FUNCTION : d3_incZvalue

  PURPOSE  : increments the z-value in the dialog widget
  RETURNS  : 
  NOTES    :

******************************************************************************/


static void d3_incZvalue (w, pannel, call_data)

    Widget w;
    Widget pannel;
    caddr_t call_data;

{
    int n;
    Arg arg[10];
    char buf[10];

    ui_actualZvalue++;
    sprintf (buf, "%d", ui_actualZvalue);
    n = 0;
    XtSetArg (arg[n], XtNstring, buf); n++;
    XtSetValues (pannel, arg, n);
}




/*****************************************************************************
  FUNCTION : d3_decZvalue

  PURPOSE  : decrements the z-value in the dialog widget
  RETURNS  : 
  NOTES    :

******************************************************************************/


static void d3_decZvalue (w, pannel, call_data)

    Widget w;
    Widget pannel;
    caddr_t call_data;

{
    int n;
    Arg arg[10];
    char buf[10];

    ui_actualZvalue--;
    sprintf (buf, "%d", ui_actualZvalue);
    n = 0;
    XtSetArg (arg[n], XtNstring, buf); n++;
    XtSetValues (pannel, arg, n);
}





/*****************************************************************************
  FUNCTION : d3_createZvaluePannel

  PURPOSE  : creates the z-value pannel
  RETURNS  : 
  NOTES    : 

******************************************************************************/



void d3_createZvaluePannel (parent)

   Widget parent;

{

  static XtActionsRec  ActionRec [] = {{"d3_readZvalue", d3_readZvalue}};
  XtTranslations Translation;

  Widget pannel, label, button, dummy, up, down, name;
  int n;
  Arg arg[10];
  char buf[20];

  n = 0;

  XtSetArg(arg[n], XtNwidth, 250); n++;
  XtSetArg(arg[n], XtNleft  , XtChainLeft); n++;
  XtSetArg(arg[n], XtNright , XtChainLeft); n++;
  XtSetArg(arg[n], XtNtop   , XtChainTop); n++;
  XtSetArg(arg[n], XtNbottom, XtChainTop); n++;
  pannel = XtCreateManagedWidget("pannel", formWidgetClass, parent, arg, n);

  label = ui_xCreateLabelItem ("z-value ", pannel, d3_fontWidth * 7, NULL, NULL); 
  sprintf (buf, "%d", ui_actualZvalue);
  z_valueWidget = ui_xCreateDialogItem ("z_valueWidget", pannel, buf, d3_shortNumberWidth, label, NULL);

  button = d3_xCreateButtonItem ("ok", pannel, z_valueWidget, NULL);
  dummy = ui_xCreateLabelItem (" ", pannel, d3_fontWidth, button, NULL); 
  up = d3_xCreateButtonItem ("up", pannel, dummy, NULL);
  down = d3_xCreateButtonItem ("down", pannel, up, NULL);

  XtAddCallback (button, XtNcallback, d3_readZvalue, (Widget) z_valueWidget);
  XtAddCallback (up, XtNcallback, d3_incZvalue, (Widget) z_valueWidget);
  XtAddCallback (down, XtNcallback, d3_decZvalue, (Widget) z_valueWidget);

  XtAppAddActions (ui_appContext, ActionRec, XtNumber (ActionRec));
  Translation = XtParseTranslationTable ("<Key>Return: d3_readZvalue()");
  XtOverrideTranslations (z_valueWidget, Translation);

}

/* end of file */
/* lines: 186 */
