/*****************************************************************************
  FILE     : d3_zgraph.c
  SHORTNAME: zgraph.c

  PURPOSE  : z-buffer for the hidden line detection
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Ralf Huebner
  DATE     : 1.12.1991

             (c) 1992 by Ralf Huebner and the SNNS-Group
             
******************************************************************************/



#include <stdio.h>
#include <values.h>
#include <malloc.h>

#include "ui.h"
#include "d3_global.h"
#include "d3_zgraph.h"

extern int d3_displayXsize;
extern int d3_displayYsize;

extern bool d3_displayIsReady;


static float *zbuffer;

static bool zbuffer_isInit = FALSE;
static int zbuffer_xsize;
static int zbuffer_ysize;



/*****************************************************************************
  FUNCTION : d3_initZbuffer

  PURPOSE  : init and clear z-buffer
  RETURNS  : 
  NOTES    :

******************************************************************************/


int d3_initZbuffer ()

{
   d3_getRootSizes (&zbuffer_xsize, &zbuffer_ysize);

   if (!zbuffer_isInit) {
        zbuffer = (float *) malloc (zbuffer_xsize * zbuffer_ysize * sizeof (float));
        if (zbuffer == NULL) {
            fprintf (stderr, "Error allocating zbuffer");
            return (FALSE);
	}
        zbuffer_isInit = TRUE;
    }
    d3_clearZbuffer ();
    return (TRUE);
}




/*****************************************************************************
  FUNCTION : d3_clearZbuffer

  PURPOSE  : clear z-buffer
  RETURNS  : 
  NOTES    :

******************************************************************************/




void d3_clearZbuffer ()

{
  float  *zbuf_ptr, *limit;

  limit = zbuffer + d3_displayXsize * d3_displayYsize;
  for (zbuf_ptr = zbuffer; zbuf_ptr < limit; zbuf_ptr++)
    *zbuf_ptr = MAXFLOAT;
}






/*****************************************************************************
  FUNCTION : d3_readZbuffer

  PURPOSE  : read a value out of the z-buffer
  RETURNS  : 
  NOTES    :

******************************************************************************/


void d3_readZbuffer (x, y, z)

    int x, y;
    float *z;

{
    *z = *(zbuffer + y*d3_displayYsize + x);
}




/*****************************************************************************
  FUNCTION : d3_writeZbuffer

  PURPOSE  : write a value into the z-buffer
  RETURNS  : 
  NOTES    :

******************************************************************************/


void d3_writeZbuffer (x, y, z)

    int x, y;
    float z;

{
    *(zbuffer + y*d3_displayYsize + x) = z;
}




/*****************************************************************************
  FUNCTION : d3_freeZbuffer

  PURPOSE  : free the memory if the z-buffer is not longer used
  RETURNS  : 
  NOTES    :

******************************************************************************/




void d3_freeZbuffer ()

{
    if (zbuffer_isInit) {
        free (zbuffer);
        zbuffer_isInit = FALSE;
    }
}

/* end of file */
/* lines: 163 */
