/*****************************************************************************
  FILE     : ui_confirmer.c
  SHORTNAME: confirm.c

  PURPOSE  :
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Tilman Sommer
  DATE     : 6.7.1990

             (c) 1992 by Tilman Sommer and the SNNS-Group
             
******************************************************************************/

#include "ui.h"


#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

#include "ui_xWidgets.h"

#include "../iconsXgui/stopIcon.xbm"
#include "../iconsXgui/exclamation.xbm"

extern Display      *ui_display;        /* X display */
extern Widget        ui_toplevel;       /* toplevel widget of GUI */  
extern XtAppContext  ui_appContext;     /* X application context */
extern int           ui_screen;         /* X screen */


static int     ui_cf_answer;      /* which button was pressed to exit ? */
static Widget  ui_cf_popup;       /* shell widget containing the confirmer */
static Bool    ui_cf_exit = TRUE; /* to control the confirmer loop */



/*****************************************************************************
  FUNCTION :                   UI_CF_YESNOOK

  PURPOSE  : terminating of the confirmer
  RETURNS  : 
  NOTES    :
*****************************************************************************/

void
ui_cf_yesNoOk(widget, client_data, call_data)
     Widget    widget;		
     caddr_t   client_data, call_data;
{
    XtDestroyWidget(ui_cf_popup);
    ui_cf_answer = (int) client_data;
    ui_cf_exit   = TRUE;
}




/*****************************************************************************
  FUNCTION :                     UI_CONFIRM

  PURPOSE  : Built and display the confirmer, get a return value (which button
             was pressed, kill the window and return the value to the caller.
  RETURNS  : which button was pressed by the user.
  NOTES    : 
*****************************************************************************/

void
ui_confirm(message, ok_only)
     char *message;
     int  ok_only;
{
    Widget      form, picture, label;
    Arg		args[5];
    Widget	button;
    Cardinal	n;
    XEvent      event;


    /* Now create Popup */

    ui_cf_popup = 
	XtCreatePopupShell("confirmer", transientShellWidgetClass, ui_toplevel,
			   NULL, 0);
    form = 
	XtCreateManagedWidget("form", formWidgetClass, ui_cf_popup, NULL, 0);

    if (ok_only) {
	n = 0;
	XtSetArg(args[n], XtNborderWidth, 0); n++;
	XtSetArg(args[n], XtNbitmap, 
		 (Pixmap) XCreateBitmapFromData(ui_display, 
						XDefaultRootWindow(ui_display),
						exclamation_bits, exclamation_width,
						exclamation_height)); n++;
    	picture = 
	    XtCreateManagedWidget("exclamation", labelWidgetClass, form, 
				  args, n);     

	n = 0;
	XtSetArg(args[n], XtNfromHoriz, picture); n++;
	XtSetArg(args[n], XtNborderWidth, 0); n++;
	XtSetArg(args[n], XtNlabel,     message); n++;
	label = 
	    XtCreateManagedWidget("confirmerMsg", labelWidgetClass, form, args, n);
    
	button = ui_xCreateButtonItem("ok", form, picture, label);
	XtAddCallback(button, XtNcallback, ui_cf_yesNoOk, (Bool) TRUE);

    } else {
	n = 0;
	XtSetArg(args[n], XtNborderWidth, 0); n++;
	XtSetArg(args[n], XtNbitmap, 
		 (Pixmap) XCreateBitmapFromData(ui_display, 
						XDefaultRootWindow(ui_display),
						stopIcon_bits, stopIcon_width,
						stopIcon_height)); n++;
	picture =
	    XtCreateManagedWidget("stop", labelWidgetClass, form, 
				  args, n);


	n = 0;
	XtSetArg(args[n], XtNfromHoriz, picture); n++;
	XtSetArg(args[n], XtNborderWidth, 0); n++;
	XtSetArg(args[n], XtNlabel,     message); n++;
	label = 
	    XtCreateManagedWidget("confirmerNsg", labelWidgetClass, form, 
				  args, n);


	button = ui_xCreateButtonItem("yes", form, picture, label);
	XtAddCallback(button, XtNcallback, ui_cf_yesNoOk, (Bool) TRUE);

	button = ui_xCreateButtonItem("no", form, button, label);
	XtAddCallback(button, XtNcallback, ui_cf_yesNoOk, (Bool) FALSE);
    }
    XawFormDoLayout(form, True);
    XtRealizeWidget(ui_cf_popup);
    
    /* now move the popup to the middle of the screen */
    {
	Window root;
	int    x, y;
	unsigned int borderWidth, depth, width, height;
	XWindowChanges xChange;
	
	(void) XGetGeometry(ui_display, XtWindow(ui_cf_popup),
			    &root, &x, &y, &width, &height, &borderWidth, &depth);
	
	xChange.x = 
	    (int) ((XDisplayWidth(ui_display, ui_screen) - width) / 2);
	xChange.y =
	    (int) ((XDisplayHeight(ui_display, ui_screen) - height) / 2);
	xChange.stack_mode = (int) Above;
	XConfigureWindow(ui_display, XtWindow(ui_cf_popup), 
			 CWX BIT_OR CWY BIT_OR CWStackMode, &xChange);
    }

    XtPopup(ui_cf_popup, XtGrabExclusive);

    
    /* now enter the confirmer loop.
       Everthing behaves the same, because its an copy of XtAppMainLoop(), 
       but it stops UI from processing code from here back to the main loop.
       This is needed, because the confirmer should return values! */

    ui_cf_exit = FALSE;
    while (NOT ui_cf_exit) {
	XtAppNextEvent(ui_appContext, &event);
	(void) XtDispatchEvent(&event);
    }
}





/*****************************************************************************
  FUNCTION :                 UI_CONFIRMYES

  PURPOSE  : call the confirmer whith buttons NO and YES and STOP sign
  RETURNS  : TRUE, if the user pressed the YES button, else FALSE;
*****************************************************************************/


int 
ui_confirmYes(message)
     char    *message;
{
    ui_confirm(message, FALSE);
    return(ui_cf_answer);
}



/*****************************************************************************
  FUNCTION :                   UI_CONFIRMOK

  PURPOSE  : call the confirmer with button OK and a exclamation mark icon.
  RETURNS  : void.
  NOTES    : This routine is used to show important messages to the user.
             Don't use it to much, because the user will become nervous!
*****************************************************************************/

void 
ui_confirmOk(message)
     char    *message;
{
    ui_confirm(message, TRUE);
}









/* end of file */
/* lines: 225 */
