/*****************************************************************************
  FILE     : ui_display.c
  SHORTNAME: display.c

  PURPOSE  : contains routines to handle the list of all network displays
  FUNCTIONS: 
  NOTES    : 

  AUTHOR   : Tilman Sommer
  DATE     : 26.7.1990

             (c) 1992 by Tilman Sommer and the SNNS-Group
             
******************************************************************************/

#include <stdio.h>

#include "ui.h"
#include "ui_utilP.h"
#include "ui_display.h"   /* typdef, defines */


struct Ui_DisplayType *ui_currentDisplay;     /* current display */
struct Ui_DisplayType *ui_displ_listPtr;      /* pointer to first item */
struct Ui_DisplayType *ui_displ_freeListPtr;  /* pointer to first free item */

int            ui_displ_numberOfItems;       /* number of created items */




/*****************************************************************************
  FUNCTION : ui_displ_createItem

  PURPOSE  : allocate size for one item from the heap and set default values
  RETURNS  : pointer to that new item
*****************************************************************************/


struct Ui_DisplayType 
*ui_displ_createItem()
{
    struct Ui_DisplayType  *displPtr;

    displPtr = (struct Ui_DisplayType *) malloc(sizeof(struct Ui_DisplayType));
    if (displPtr != NULL) {
	(*displPtr).x            = 1;
	(*displPtr).y            = 1;
	(*displPtr).origin.x     = 0;
	(*displPtr).origin.y     = 0;
	(*displPtr).width        = 450;
	(*displPtr).height       = 300;
	(*displPtr).gridSize     = 37;
	(*displPtr).unitsInX     = (*displPtr).width  / (*displPtr).gridSize;
	(*displPtr).unitsInY     = (*displPtr).height / (*displPtr).gridSize;
	(*displPtr).frozen       = FALSE;
	(*displPtr).subNetNo     = 0;
	(*displPtr).layers       = 1;
	ui_set_initData(displPtr);
	(*displPtr).updateType   = UI_INTELLIGENT;
	(*displPtr).flags        = UI_CLOSED + 1; /*!*/ /* mapped */
	(*displPtr).nextPtr      = NULL;
	(*displPtr).displayNo    = ui_displ_numberOfItems;
    }
    return (displPtr);
}


/*****************************************************************************
  FUNCTION : ui_displ_initDisplayList

  PURPOSE  : initialize the Display list and Display counters
  RETURNS  : void
*****************************************************************************/

void
ui_displ_initDisplayList()
{
    ui_displ_numberOfItems          = 1;
    ui_displ_listPtr                = NULL;
    ui_displ_freeListPtr            = ui_displ_createItem();
    ui_currentDisplay               = ui_displ_listPtr;
    ui_displ_numberOfItems          = 0;
}




/*****************************************************************************
  FUNCTION : ui_displ_resetList  

  PURPOSE  : links all items in the free list and closes the displays 
  RETURNS  : 
*****************************************************************************/

void
ui_displ_resetList()
{
    struct Ui_DisplayType  *displPtr;

    while (ui_displ_listPtr != NULL) {
	displPtr = ui_displ_listPtr;
	ui_displayDone(NULL, displPtr, NULL);
	/* ui_displ_freeItem() is performed in ui_displayDone() ! */
    }
}
	
/*****************************************************************************
  FUNCTION : ui_displ_freeItem

  PURPOSE  : links the item in the free list
  RETURNS  : 
*****************************************************************************/

void
ui_displ_freeItem(displayPtr)
struct Ui_DisplayType  *displayPtr;
{
    struct Ui_DisplayType  *displPtr;
 
    if (ui_displ_listPtr == displayPtr) { /* is first element */
	ui_displ_listPtr     = displayPtr->nextPtr;
	displayPtr->nextPtr  = ui_displ_freeListPtr;
	ui_displ_freeListPtr = displayPtr;
	ui_displ_numberOfItems -= 1;
    } else { /* second, third, ... element */
	displPtr = ui_displ_listPtr;
	while ((displPtr->nextPtr != displayPtr) AND
	       (displPtr->nextPtr != NULL)) 
	    displPtr = displPtr->nextPtr;

	if (displPtr->nextPtr == displayPtr) { /* item was found */
	    displPtr->nextPtr    = displayPtr->nextPtr;
	    displayPtr->nextPtr  = ui_displ_freeListPtr;
	    ui_displ_freeListPtr = displayPtr;
	    ui_displ_numberOfItems -= 1;
	}
    }
}
	

/*****************************************************************************
  FUNCTION :                   UI_DISPL_GET FREE ITEM

  PURPOSE  : looks in the free list for an item. If no one is found, 
             ui_displ_createItem() is called to create a new one.
  RETURNS  : a pointer to a free item or NULL if malloc() fails
*****************************************************************************/

struct Ui_DisplayType
*ui_displ_getFreeItem()
{
    struct Ui_DisplayType  *displPtr;

    ui_displ_numberOfItems++;
    if (ui_displ_freeListPtr == NULL) { /* no free item */
	displPtr             = ui_displ_createItem(); /* create a new item */
    } else {
	displPtr             = ui_displ_freeListPtr;
	ui_displ_freeListPtr = displPtr->nextPtr;
    }
    if (displPtr != NULL) {
	/* link it in the list as the first element */
	(*displPtr).nextPtr = ui_displ_listPtr;
	ui_displ_listPtr    = displPtr;
    }
    return(displPtr);
}
	

/*****************************************************************************
  FUNCTION : ui_displ_getDisplayPtrViaDrawable

  PURPOSE  : search through the display list for a display with the specified
             drawable ID
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/

/*!*/ /* not used */
struct Ui_DisplayType
*ui_displ_getDisplayPtrViaDrawable(w)
Widget w;
{
    struct Ui_DisplayType *dPtr;

    dPtr = ui_displ_listPtr;
    while((dPtr != NULL) AND (dPtr->widget != w))
	dPtr = dPtr->nextPtr;

    return(dPtr);
}

/*****************************************************************************
  FUNCTION : ui_displ_getDisplayPtrViaFrameWidget

  PURPOSE  : search through the display list for a display with the specified
             frame widget
  NOTES    : 

  UPDATE   : 1.2.1990
******************************************************************************/

/*!*/ /* not used */
struct Ui_DisplayType
*ui_displ_getDisplayPtrViaFrameWidget(w)
Widget w;
{
    struct Ui_DisplayType *dPtr;

    dPtr = ui_displ_listPtr;
    while((dPtr != NULL) AND (dPtr->frameWidget != w))
	dPtr = dPtr->nextPtr;

    return(dPtr);
}



/*****************************************************************************
  FUNCTION : ui_displ_isSomeWhereToShowWeights

  PURPOSE  : Returns TRUE if there is to show the weights of links 
             in any display.
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/


Bool 
ui_displ_isSomeWhereToShowWeights()
{
    struct Ui_DisplayType *dPtr;

    dPtr = ui_displ_listPtr;
    while((dPtr != NULL)) {
	if (dPtr->setup.showWeightFlg) return(TRUE);
	dPtr = dPtr->nextPtr;
    }
    return(FALSE);
}





/*****************************************************************************
  FUNCTION : ui_displ_isSomeWhereToShowValues

  PURPOSE  : Returns TRUE if there is to show the unit value numerically 
             in any display.
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/


Bool 
ui_displ_isSomeWhereToShowValues()
{
    struct Ui_DisplayType *dPtr;

    dPtr = ui_displ_listPtr;
    while((dPtr != NULL)) {
	if (dPtr->setup.showValueFlg) return(TRUE);
	dPtr = dPtr->nextPtr;
    }
    return(FALSE);
}




/*****************************************************************************
  FUNCTION : ui_displ_freezeDisplay

  PURPOSE  : sets the freeze flag in the display structure
  RETURNS  : ---
  NOTES    : 
*****************************************************************************/

void
ui_displ_freezeDisplay(w, displayPtr, call_data)
     Widget                 w;
     struct Ui_DisplayType *displayPtr;
     caddr_t                call_data;
{
    displayPtr->frozen = NOT displayPtr->frozen;
    ui_net_completeRefresh(displayPtr, UI_LOCAL);
}









/* end of file */
/* lines: 301 */
