/*****************************************************************************
  FILE     : ui_inversion.h
  SHORTNAME: inversion.h

  PURPOSE  : Header file of correspondent '.c' file
  NOTES    :

  AUTHOR   : Guenter Mamier
  VERSION  : 1.0
  DATE     : 29.01.92

             (c) 1992 by Guenter Mamier and the SNNS-Group
             
******************************************************************************/


/* required functions that are declared elsewhere */
extern void                    ui_popupSetup();
extern void                    ui_refresh();
extern void                    ui_displ_resetList();
extern void                    krui_getUnitPosition();
extern FlintType               krui_getUnitActivation();
extern void                    ui_drawGrowingThing();
extern int                     krui_getFirstUnit();
extern int                     krui_getNextUnit();
extern int                     krui_getUnitTType();
extern struct PosType          ui_utilPixUpperLeft();
extern struct PosType          ui_utilPixLowerRight();
extern struct Ui_DisplayType  *ui_displ_getFreeItem();
extern struct SelectionType   *ui_sel_lookForItem();
extern void                    krui_inv_forwardPass();
extern double                  krui_inv_backwardPass();
extern krui_err                kr_mycheckUnitsOutput();
extern int                     krm_deletePattern();
extern int                     krm_setCurrentPattern();


/* required functions that are declared here */
void                           ui_inversion(),
                               ui_start_inversion(),
                               ui_stop_inversion(),
                               ui_closeDisplay(),
                               ui_set_IO_units(),
                               ui_invNew(),
                               ui_drawInput(),
                               ui_invSetup(),
                               ui_invEvent(),
                               ui_invHelp(),
                               ui_inv_helpDone(),
                               ui_inv_popupDone();
Boolean                        ui_do_inversion();


/* variables for Xlib */
extern GC              ui_gc;                      /* xgui graphic context       */
extern XGCValues       ui_gcValues;                /* initial gc values          */
extern XFontStruct     *ui_fontStruct;             /* available fonts            */
int                    inv_screen;                 /* X screen                   */
Display                *inv_display;               /* actual "setenv DISPLAY"    */


/* variables for X intrinsic */
extern Widget          ui_toplevel;
extern XtAppContext    ui_appContext;              /* application context        */


/* global variables for xgui */
extern unsigned long   ui_editColor[];             /* color definitions          */
extern int             ui_col_monochromeMode;      /* color definitions          */
extern unsigned long   ui_col_rangePixels[];       /* color definitions          */
extern int             ui_col_steps;               /* color definitions          */
extern TopoPtrArray    topo_ptr_array;
struct Ui_DisplayType  *displayPtr,                /* handle for all windows     */
                       *ui_displ_listPtr;
extern Display         *ui_display;                /* structure of the windows   */
extern int             MinUnitNo,MaxUnitNo;        /* begin/end field of above   */
extern int             NoOfPatternPairs;           /* # of loaded patterns       */



/* global variables for this file */
Widget                 ui_popCanvas;               /* root widget for inversion  */
Widget                 ui_invpop,                  /* setup widget               */
                       inPatW,                     /* dialog widget for input pat*/
                       etaW,                       /*   "      "    for eta      */
                       delta_maxW,                 /*   "      "    for delta    */
                       ratioW;                     /*   "      "    for 2nd appr.*/
typedef struct UnitList{
    int             no;               /* Unit number                              */
    FlintType       act;              /* Unit activation                          */
    FlintType       i_act;            /* Initial activation of unit               */
    FlintType       im_act;           /* pseudo activation, to put act in [0,1]   */
    struct PosType  gridPos;          /* position of the unit                     */
    struct UnitList *next;            /* next unit (not topological !!)           */
    struct UnitList *prev;            /* previous unit (not topological !!)       */
};
struct UnitList *inputs,                           /* handle for input units      */
                *outputs;                          /* handle for output units     */
static int      INVERS_CREATED = 0;                /* TRUE if display exists      */
static int      INV_NEW        = 1;                /* TRUE for restart            */
static int      INV_RUNNING    = 0;                /* TRUE while inv loops        */
static int      INV_cycle      = 0;                /* counts the inv. cycles      */
static int      INV_units      = 0;                /* counts faulty output units  */
static double   INV_error;                         /* counts net inv. error       */
float           INPUT_PAT      = 0.0;              /* stores UnitList.i_act       */
float           RATIO          = 0.5;              /* stores 2nd aprox. ratio     */
float           INV_delta_max  = 0.05;             /* maximum output unit error   */
float           INV_eta        = 2.0;              /* learn parameter             */
static XtWorkProcId  ui_workProcId = NULL;         /* work id of inversion        */
static FlagType      ui_workType;                  /* not used here               */

