/*****************************************************************************
  FILE     : ui_layer.c
  SHORTNAME: layer.c

  PURPOSE  : popups a window with all layers. It is possible to choose layers
             and to alter layer names as well.
  FUNCTIONS: 
  NOTES    : is called only during initialisation

  AUTHOR   : Tilman Sommer
  DATE     : 31.8.1990

  COPYRIGHT: (c) 1990 by Tilman Sommer and the SNNS-Group
             
******************************************************************************/



#include "ui.h"

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Cardinals.h>

#include "ui_xWidgets.h"

Widget    ui_layerPanel;  /* shell widget of layer panel */

/* widgets of input fields and buttons */
Widget    ui_layerNameWidgets[MAX_NO_LAYERS];
Widget    ui_layerButtonWidgets[MAX_NO_LAYERS];

/* array of layer names */
char      ui_layerNames[MAX_NO_LAYERS][MAX_NAME_LENGTH];

/* the value indicating the initial state of the buttons */
unsigned short ui_layerStartValue = 0;




/*****************************************************************************
  FUNCTION :                 UI_XCREATE LAYER PANEL

  PURPOSE  : create the panel
  RETURNS  : void
  NOTES    : the wigdet will be created in relative position to eachother
*****************************************************************************/


void
ui_xCreateLayerPanel(parent)
     Widget parent;      /* the parent widget of the new form widget */
{

    /* tabs for data fields and small buttons */


    Widget      oldLabel, nameLabel, nrLabel, label;

    int    i;
    char   buf[80];
    int    flagWord = ui_layerStartValue;
    int    bit = 1;
    
    int  fontWidth = 8;

    int  labelWidth  =  9 * fontWidth;
    int  nameWidth   = 25 * fontWidth;  



/***************************************************************************/

    ui_layerPanel = 
	XtCreateManagedWidget("lPanel", formWidgetClass, parent, NULL, ZERO);


/*****************************  HEAD LINE  *********************************/

    nrLabel =
	ui_xCreateLabelItem("layer", ui_layerPanel, labelWidth,  
			    NULL, NULL);
    ui_xSetResize(nrLabel, TRUE);

    label = nrLabel;

    nameLabel =
	ui_xCreateLabelItem("name", ui_layerPanel, nameWidth,  
			    nrLabel, NULL);

/*****************************  LINES  *************************************/

    for (i=0; i<MAX_NO_LAYERS; i++) {

	oldLabel = label;
	sprintf(buf,"%2d",i+1);
	label = 
	    ui_xCreateLabelItem(buf, ui_layerPanel, labelWidth, NULL, label); 
	ui_xSetResize(label, TRUE);

	ui_layerNameWidgets[i] =
	    ui_xCreateDialogItem("layerName", ui_layerPanel, 
				 ui_layerNames[i], nameWidth, 
				 nrLabel, oldLabel);

	ui_layerButtonWidgets[i] =
	    ui_xCreateToggleItem("on", ui_layerPanel, NULL, 
				 ui_layerNameWidgets[i], oldLabel);
	ui_xSetToggleState(ui_layerButtonWidgets[i], 
			   ui_utilIsSet(flagWord, bit));
	bit *= 2;
    }

/***************************************************************************/

    XawFormDoLayout(ui_layerPanel, True);
}









/* end of file */
/* lines: 132 */
