/*****************************************************************************
  FILE     : ui_layerP.c
  SHORTNAME: layerP.c

  PURPOSE  : 
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Tilman Sommer
  DATE     : 31.8.1990

             (c) 1992 by Tilman Sommer and the SNNS-Group
             
******************************************************************************/


#include "ui.h"
#include "ui_utilP.h"
#include "ui_xWidgets.h"

/* layer names */
extern char   ui_layerNames[MAX_NO_LAYERS][MAX_NAME_LENGTH];

/* widgets with all input fields and buttons in the layer panel */
extern Widget ui_layerNameWidgets[MAX_NO_LAYERS];
extern Widget ui_layerButtonWidgets[MAX_NO_LAYERS];

/* value indicating the state off all buttons in the layer panel */
unsigned short ui_layerReturnValue;



/*****************************************************************************
  FUNCTION : ui_layer_initLayerNames

  PURPOSE  : assign initial layer names
  NOTES    :

  UPDATE   : 31.8.1990
******************************************************************************/

void
ui_layer_initLayerNames()
{
    int i;

    for (i=0; i<MAX_NO_LAYERS; i++) {
	sprintf(ui_layerNames[i],"LAYER %2d",i+1);
    }
}


/*****************************************************************************
  FUNCTION : ui_layer_setLayerNames

  PURPOSE  : copy data from widgets to the name array
  NOTES    :

  UPDATE   : 31.8.1990
******************************************************************************/

void
ui_layer_setLayerNames()
{
    int   i;
    int   flagWord = 0;
    int   bit = 1;
    
    for (i=0; i<MAX_NO_LAYERS; i++) {
	ui_xStringFromAsciiWidget(ui_layerNameWidgets[i], 
				  ui_layerNames[i], MAX_NAME_LENGTH);
	if (ui_xGetToggleState(ui_layerButtonWidgets[i]))
	    ui_utilSetFlag(flagWord, bit);
	bit *= 2;
    }
    ui_layerReturnValue = (unsigned short) flagWord;
}    










/* end of file */
/* lines: 89 */
