/*****************************************************************************
  FILE     : ui_main.c
  SHORTNAME: main.c

  PURPOSE  : contains many widgets to manage xgui of the SNNS
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Tilman Sommer
  DATE     : 1.4.1990

             (c) 1992 by Tilman Sommer and the SNNS-Group

******************************************************************************/

#include "ui.h"

/* for getwd() */
#include <sys/param.h>

#include <X11/Shell.h>
#include <X11/cursorfont.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

#include "ui_main.h"
#include "ui_mainP.h"
#include "ui_print.h"
#include "ui_layerP.h"
#include "ui_xWidgets.h"
#include "ui_display.h"    /* init */
#include "ui_action.h"     /* init */
#include "ui_key.h"        /* init */
#include "ui_fileP.h"      /* init */
#include "ui_color.h"      /* init */

#include "bn_bignet.h"
#include "d3_pannels.h"
#include "o_graph.h"

extern char ui_filenameNET[MAX_NAME_LENGTH];

/* shell widgets of info and remote panel */
extern Widget                    ui_infoPanel, ui_remotePanel;

extern Bool                      ui_infoIsCreated; /* yes or no ? */

/******************************  GLOBALS  ***********************************/


XtAppContext ui_appContext;
Display      *ui_display; /* X display */
Widget       ui_toplevel;
Widget       ui_infoBox; /* frame widget (form) of info item */
Widget       ui_message; /* label widget */
/* label widgets of status info */
Widget       ui_stat_posWidget, ui_stat_selNoWidget, ui_stat_flagsWidget;

/* path name (see file panel). Initial value by getwd() */
#ifndef MAXPATHLEN
#define MAXPATHLEN  512
#endif
char         ui_pathname[MAXPATHLEN] = "\0";

/* called functions for display of weights and unit functions */

extern void ui_displFunc();
extern void ui_displWeights();
extern void ui_inversion();


/*****************************************************************************
  FUNCTION : ui_init

  PURPOSE  : do some intialization
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/



void ui_init()
{
    ui_sel_initSelectionList();    /* list of selected units */
    ui_displ_initDisplayList();    /* list of xgui displays  */
    ui_layer_initLayerNames();     /* initial layer names */
    ui_key_init();                 /* editor key automata */
    ui_action_init();              /* editor action routines */
    (void) getcwd( ui_pathname, MAXPATHLEN );

    XawSimpleMenuAddGlobalActions(ui_appContext); /* for editor menu */
}




/*****************************************************************************
  FUNCTION : ui_xCreatePanel

  PURPOSE  : create info panel
  NOTES    :

  UPDATE   : 27.7.1990
******************************************************************************/

void
ui_xCreatePanel()
{
    Widget      menuButton, menu, mItem, label;
    Arg		args[10];
    Cardinal	n;
    char        buf[40];
    
    /* action only, if the info panel is not already created */

    if (NOT ui_infoIsCreated) {

	/* Upper left corner will be in the center of the calling button */
	
	ui_infoBox = 
	    XtCreateManagedWidget("form", formWidgetClass, ui_toplevel, NULL, ZERO);
	ui_display  = XtDisplay(ui_infoBox);

	ui_xCreateInfoPanel(ui_infoBox); 

	n = 0;
	XtSetArg(args[n], XtNleft  , XtChainLeft);   n++;
	XtSetArg(args[n], XtNright , XtChainLeft);   n++;
	XtSetArg(args[n], XtNtop   , XtChainTop);    n++;
	XtSetArg(args[n], XtNbottom, XtChainTop);    n++;	
	XtSetValues(ui_infoPanel, args, n);
	

	menuButton = 
	    ui_xCreateMenuButtonItem("windows", ui_infoBox, 
				     NULL, ui_infoPanel);

	menu = 
	    XtCreatePopupShell("menu", simpleMenuWidgetClass, menuButton,
			       NULL, ZERO);

	sprintf(buf,"FILE");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);

	XtAddCallback(mItem, XtNcallback, ui_displayFilePanel, 
		      (Widget) menuButton);
	
	sprintf(buf,"DISPLAY");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, ui_displayGraphic, NULL);


	sprintf(buf,"3D VIEW");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, d3_displayGraphic, NULL);
#ifndef MASPAR_KERNEL
	sprintf(buf,"INVERSION");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu, NULL, ZERO);
        XtAddCallback(mItem, XtNcallback, ui_inversion, NULL);
#endif
	sprintf(buf,"WEIGHTS");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, ui_displWeights, NULL);

        sprintf(buf,"GRAPH");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, o_createOszi, NULL); 

	sprintf(buf,"REMOTE");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, ui_displayRemote, NULL); 

	sprintf(buf,"BIGNET");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, bn_createBignet, NULL); 

	sprintf(buf,"PRINT");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, ui_printNet, NULL);
 
	sprintf(buf,"HELP");
	mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, ui_displayText, NULL);

	sprintf(buf,"TEXT");
	/* mItem =
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu,
				     NULL, ZERO);
        */

	sprintf(buf,"QUIT");
	mItem = 
	    XtCreateManagedWidget(buf, smeBSBObjectClass, menu, 
				  NULL, ZERO);
	XtAddCallback(mItem, XtNcallback, ui_guiQuit, (XtPointer) ui_infoBox);

	
	ui_message = 
	    ui_xCreateLabelItem("manMsg", ui_infoBox, 60*8,
			       menuButton, ui_infoPanel);

	ui_display  = XtDisplay(ui_message);

	ui_stat_posWidget =
	    ui_xCreateLabelItem("*", ui_infoBox, 16*8, NULL, ui_message);

	label =
	    ui_xCreateLabelItem("noSel", ui_infoBox, 20 /* Icon */, 
				ui_stat_posWidget, ui_message);
	ui_stat_selNoWidget =
	    ui_xCreateLabelItem("*", ui_infoBox, 8*8, label, ui_message);

	label =
	    ui_xCreateLabelItem("flags", ui_infoBox, 20/* Icon */, 
				ui_stat_selNoWidget, ui_message);
	ui_stat_flagsWidget =
	    ui_xCreateLabelItem("*", ui_infoBox, 15*8, label, ui_message);

	XawFormDoLayout(ui_infoBox, True);
    }
}


/*****************************************************************************
  FUNCTION : banner

  PURPOSE  : display Title Page
  NOTES    :

  UPDATE   : 11.2..1992
******************************************************************************/

#include "snns.xbm"


void ui_clickEventProc (w, display, event)

    Widget w;
    Display *display;
    XEvent *event;

{
    switch (event->type) {
        case ButtonPress:
            if (event->xbutton.button == 1)
                 XtDestroyWidget (w);
            break;
    }
}


void ui_showBanner (parent)

    Widget parent;

{
     int n;
     Arg arg[10];
     Widget banner, frame;
     int xwsize = snns_width;
     int ywsize = snns_height;
     int xpos, ypos;
     unsigned int xsize, ysize;

     d3_getRootSizes (&xsize, &ysize);
     n = 0;

     XtSetArg (arg[n], XtNwidth, xwsize); n++;
     XtSetArg (arg[n], XtNheight, ywsize); n++;
     XtSetArg (arg[n], XtNx, (xsize - xwsize) / 2); n++;
     XtSetArg (arg[n], XtNy, (ysize - ywsize) / 2); n++;
     banner = XtCreatePopupShell ("banner", transientShellWidgetClass, 
                                  parent, arg, n);
     n = 0;
     XtSetArg (arg[n], XtNbitmap, 
                  (Pixmap) XCreateBitmapFromData (ui_display,
                   XDefaultRootWindow (ui_display), 
                   snns_bits, snns_width, snns_height)); n++;
     frame = XtCreateManagedWidget("", labelWidgetClass,
                                   banner, arg, n);
     XtAddEventHandler (banner, ButtonPressMask, 
                        FALSE, ui_clickEventProc, ui_display);
     XtPopup (banner, XtGrabNone);
}



/*****************************************************************************
  FUNCTION : main

  PURPOSE  : construct all widgets and windows, realize them 
  NOTES    :

  UPDATE   : 1.4.1990
******************************************************************************/



void 
main(argc, argv)
int argc;
char **argv;
{
    ui_toplevel = 
	XtAppInitialize(&ui_appContext, "Popup", NULL, ZERO,
			&argc, argv, fallback_resources, NULL, ZERO);

    ui_init(); 
    ui_parseCmdLine(ui_appContext, argc, argv);
    ui_colVar_init();
    ui_xCreatePanel();
    XtRealizeWidget(ui_toplevel);
    ui_xCreateGC(XtWindow(ui_toplevel));
    if (argc == 1)
        ui_showBanner (ui_toplevel);
    ui_col_init();
    d3_init_main ();
    ui_defaultPrinterValues();
    ui_loadFileFromCommandLine();
    XtAppMainLoop(ui_appContext);
}











/* end of file */
/* lines: 337 */
