/*****************************************************************************
  FILE     : ui_mainP.c
  SHORTNAME: mainP.c

  PURPOSE  : contains callback routines of the gui window 
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Tilman Sommer
  DATE     : 1.4.1990

             (c) 1992 by Tilman Sommer and the SNNS-Group
             
******************************************************************************/



#include <ctype.h>		   
#include <stdio.h>			/* For the Syntax message */

#include "ui.h"


#include <X11/Shell.h>

#include <X11/cursorfont.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/TextSrc.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>

#include "kr_ui.h"

#include "ui_info.h"
#include "ui_setup.h"
#include "ui_layer.h"
#include "ui_file.h"
#include "ui_fileP.h"
#include "ui_netGraph.h"
#include "ui_event.h"
#include "ui_key.h"
#include "ui_confirmer.h"
#include "ui_xWidgets.h"
#include "ui_lists.h"
#include "ui_display.h"
#include "ui_remoteP.h"
#include "ui_edit.h"
#include "ui_xGraphic.h"


/* Handles of popup shells. Used by ui_popupDone() */
Widget ui_popDummy, ui_popSetup, ui_popFile, ui_popEdit, ui_popWeights,
       ui_popCanvas, ui_popList, ui_popLayer, ui_popRemote, ui_popInit,
      ui_popResult;

/* message widget in the remote panel */
Widget ui_remoteMessageWidget;

/* frame widgets (form) of setup and file panel */
static Widget ui_setupBox, ui_fileBox;

/* widgets of edit panels */
Widget  ui_edit_ftypeNameWidget;
Widget  ui_edit_actFuncNameWidget, ui_edit_outFuncNameWidget;
Widget  ui_edit_siteNameWidget, ui_edit_siteFuncNameWidget;

/* widgets of init net */
Widget  ui_initParameterWidgets[UI_NO_INIT_PARAMS];

/* widgets of jog/random weights panel */
Widget  ui_highLimitWidget, ui_lowLimitWidget;

/* widget of message displayed when the bubble of a slider in the setup panel
   was moved */
Widget  ui_setupSliderMessage;


/* Widget  ui_help_messageWidget; not used */

/* list and free list of help windows */
struct HelpType *ui_help_listPtr     = NULL;
struct HelpType *ui_help_freeListPtr = NULL;

Bool  ui_noOfHelpsUp = 0;   /* number of help windows created */

Bool  ui_pop_exit = FALSE;  /* used, when popup window has its own 
			       event dispatching loop */

Bool  ui_filePannelPoppedUp = FALSE;  /* indicates that the file pannel 
                                         is popped up */

Bool  ui_helpOk = FALSE;   /* indicates that help.hdoc is ok */

/* load from command line */

Bool ui_loadNetbyInit = FALSE;
Bool ui_loadPatbyInit = FALSE;
Bool ui_loadCfgbyInit = FALSE;


GC             ui_gc;         /* xgui graphic context */
XGCValues      ui_gcValues;   /* initial gc values */
XFontStruct   *ui_fontStruct; 
int            ui_screen;     /* X screen */


/* true if font specified in command line */

static Bool hasCmdlineFont = FALSE;

char ui_fontName[255];

/* names of possible fonts  */

#define noOfFontNames 8

char *ui_fontNames[noOfFontNames] = {

   "6x12",
   "-*-fixed-medium-r-semicondensed-*-12-*-*-*-*-*-iso8859-*",
   "-*-fixed-medium-r-*-*-12-*-*-*-*-*-iso8859-*",
   "-*-*-medium-r-*-*-12-*-*-*-*-*-iso8859-*",
   "-*-*-*-r-*-*-12-*-*-*-*-*-iso8859-*",
   "-*-*-*-*-*-*-12-*-*-*-*-*-iso8859-*",
   "-*-*-*-*-*-*-*-*-*-*-*-*-iso8859-*",
   "*",
};


/* display for with the setup panel was displayed */
extern struct Ui_DisplayType  *ui_set_displayPtr; /* for xgui */

extern Display       *ui_display;    /* for X */
extern XtAppContext  ui_appContext;  /* X apllication context */


extern Widget  ui_toplevel;
extern Widget  ui_message;  /* message in the manager panel */
/* widgets in the file panel */
extern Widget  ui_filePAT, ui_fileNET, ui_fileCFG, ui_fileTXT;
/* shell widgets of info, remote, setup and file panel */
extern Widget  ui_infoPanel, ui_remotePanel, ui_filePanel, ui_setupPanel;
/* widgets in the setup panel */
extern Widget  ui_set_gridWidthWidget, ui_set_originXWidget;
extern Widget  ui_set_originYWidget;
extern Widget  ui_set_subnetWidget;
extern Widget  ui_set_zWidget;

/* panel created yes or no */
extern Bool    ui_infoIsCreated, ui_remoteIsCreated;
extern Bool    ui_setupIsCreated, ui_fileIsCreated;
extern Bool    ui_ResultIsCreated;

/* data displayed in the file panel */
extern char    ui_edit_siteName[MAX_NAME_LENGTH];
extern char    ui_edit_siteFuncName[MAX_NAME_LENGTH];
extern char    ui_edit_actFuncName[MAX_NAME_LENGTH];
extern char    ui_edit_outFuncName[MAX_NAME_LENGTH];
extern char    ui_edit_FTypeName[MAX_NAME_LENGTH];

/* filenames */
extern char   ui_pathname[];
extern char   ui_filenameNET[];
extern char   ui_filenamePAT[];
extern char   ui_filenameRES[];
extern char   ui_filenameCFG[];
extern char   ui_filenameTXT[];

/* index of list returned by a list panel */
extern int     ui_list_returnIndex;

/* parameters of init net */
extern float   ui_initParameters[];

extern void ui_drawFunction();
extern struct UnitAttributeType    ui_sourceUnit, ui_targetUnit;

/* current Z value */
extern short ui_actualZvalue;

/* for temp files */
extern char *ui_tmpDir, *ui_praefix;

/* flag, indicates to load cnf by command line */
extern Bool ui_loadCorrespondingCfg;

/* run xgui in monchrome mode on color displays */
extern Bool ui_monoOnColorScreen;

/*****************************************************************************
  FUNCTION : ui_createGC

  PURPOSE  : create the GC and load the graphic font
  NOTES    : window is any existing window of a widget on the screen used by
             xgui. 
  UPDATE   : 20.9.1990
******************************************************************************/

void
ui_xCreateGC(window)
     Window window;
{
    int i, count;
    char buf[255];
    char **fontList;

    if (hasCmdlineFont) {
        ui_fontStruct = XLoadQueryFont(ui_display, ui_fontName);
        if (ui_fontStruct == 0) {
             ui_tw_errorMessage("Can't find display font specified in command line");
             exit(1);
	}
    } else {
        for (i=0; i<noOfFontNames; i++) {
            ui_fontStruct = XLoadQueryFont(ui_display, ui_fontNames[i]);
            if (ui_fontStruct != 0) {
               fontList = XListFonts(ui_display, ui_fontNames[i], 1, &count);
               if (count != 0) { 
                   sprintf (buf, "Font %s loaded\n", *fontList);
                   ui_tw_printMessage(buf);
	       }
               XFreeFontNames(fontList);
               break;
	    }
        }
        if (ui_fontStruct == 0) {
            ui_tw_errorMessage("Can't find ISO 8859 Font");
            exit(1);
        }
    }

    ui_gcValues.line_width = 0;
    ui_gcValues.line_style = LineSolid;
    /* Set (or get) the next two attributes, because ui_drawUnit() 
       in the file ui_netGraphics.c need this information */
    ui_gc = 
	XCreateGC(ui_display, window, GCLineWidth | GCLineStyle, 
		  &ui_gcValues);
    XSetFunction(ui_display,ui_gc, GXcopy);
    XSetFont(ui_display, ui_gc, ui_fontStruct->fid);
}




/*****************************************************************************
  FUNCTION : ui_printMessage

  PURPOSE  : display a message in the manager panel 
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/

void ui_printMessage(msgString)
     char *msgString;
{
    ui_xSetLabel(ui_message, msgString);
    XFlush(ui_display);
}



/*****************************************************************************
  FUNCTION : ui_displayDone

  PURPOSE  : close a xgui display
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/


void 
ui_displayDone(widget, displayPtr, call_data)
     Widget	widget;		
     struct Ui_DisplayType  *displayPtr;
     caddr_t    call_data;
{
    XtDestroyWidget(XtParent(displayPtr->frameWidget));
    displayPtr->frameWidget = NULL;
    displayPtr->widget      = NULL;
    displayPtr->drawable    = 0;
    ui_displ_freeItem(displayPtr);
}
 



/*****************************************************************************
  FUNCTION : ui_helpDone

  PURPOSE  : close a xgui help window
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/

/*ARGSUSED*/
void 
ui_helpDone(widget, helpPtr, call_data)
     Widget	     widget;		
     struct HelpType *helpPtr;
     caddr_t         call_data;
{
    struct HelpType *listPtr;

    if (ui_help_listPtr == helpPtr) {
	ui_help_listPtr     = helpPtr->nextPtr;
	helpPtr->nextPtr    = ui_help_freeListPtr;
	ui_help_freeListPtr = helpPtr;
	XtDestroyWidget(helpPtr->shellWidget);
    } else {
	listPtr = ui_help_listPtr;
	while (listPtr->nextPtr != NULL AND listPtr->nextPtr != helpPtr) 
	    listPtr = listPtr->nextPtr;
	
	if (listPtr->nextPtr == helpPtr) {
	    listPtr->nextPtr    = helpPtr->nextPtr;
	    helpPtr->nextPtr    = ui_help_freeListPtr;
	    ui_help_freeListPtr = helpPtr;
	    XtDestroyWidget(helpPtr->shellWidget);
	}
    }
}

/*****************************************************************************
  FUNCTION : ui_listPopupDone

  PURPOSE  : close a list panel
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/

void 
ui_listPopupDone(widget, listDescriptorPtr, call_data)
     Widget	widget;		
     struct SimpleListType *listDescriptorPtr;
     caddr_t    call_data;
{
    int i;

    XtDestroyWidget(ui_popList);
    ui_pop_exit = TRUE; /* signal to leave temporary event loop */
    XFlush(ui_display);

    /* keep the allocated space of the array, but free all the space
       of valid strings */
    for (i = 1; i<= listDescriptorPtr->noOfItems; i++) 
	free((listDescriptorPtr->listPtr)[i-1]);
    listDescriptorPtr->noOfItems = 0;
}


/*****************************************************************************
  FUNCTION : ui_editPopupDone

  PURPOSE  : close a edit panel
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/

void 
ui_editPopupDone(widget, listDescriptorPtr, call_data)
     Widget	widget;		
     struct SimpleListType *listDescriptorPtr;
     caddr_t    call_data;
{
    int i;

    XtDestroyWidget(ui_popEdit);

    /* keep the allocated space of the array, but free all the space
       of valid strings */
    for (i = 1; i<= listDescriptorPtr->noOfItems; i++) 
	free((listDescriptorPtr->listPtr)[i-1]);
    listDescriptorPtr->noOfItems = 0;
}




/*****************************************************************************
  FUNCTION : ui_popupDone

  PURPOSE  : close other panels and windows
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/

/*ARGSUSED*/
void 
ui_popupDone(widget, client_data, call_data)
     Widget	widget;		
     int        client_data;
     caddr_t    call_data;
{
    char buf[80];
    int  gridSize;

    switch (client_data) {
      case UI_POPUP_DUMMY:
	XtDestroyWidget(ui_popDummy);
	break;
      case UI_POPUP_SETUP: 
	ui_setupIsCreated = FALSE;
	gridSize  = 
	    ui_xIntFromAsciiWidget(ui_set_gridWidthWidget);
	if (gridSize >= 1) 
	    ui_set_displayPtr->gridSize = gridSize;
	ui_set_displayPtr->origin.x  = 
	    ui_xIntFromAsciiWidget(ui_set_originXWidget);
	ui_set_displayPtr->origin.y  = 
	    ui_xIntFromAsciiWidget(ui_set_originYWidget);
	ui_set_displayPtr->subNetNo  = 
	    ui_xIntFromAsciiWidget(ui_set_subnetWidget);
	sprintf(buf,"snns-display %d - subnet: %d",
		ui_set_displayPtr->displayNo, 
		ui_set_displayPtr->subNetNo);
	ui_actualZvalue  =  ui_xIntFromAsciiWidget(ui_set_zWidget);
	XStoreName(ui_display, 
		   XtWindow(XtParent(ui_set_displayPtr->frameWidget)), 
		   buf);
	ui_net_completeRefresh(ui_set_displayPtr, UI_LOCAL);
	XtDestroyWidget(ui_popSetup);
	break;
      case UI_POPUP_FILE:   
	ui_fileIsCreated = FALSE;
        ui_filePannelPoppedUp = FALSE;
	XtDestroyWidget(ui_popFile);
	break;
      case UI_POPUP_LAYER:
	ui_layer_setLayerNames();
	XtDestroyWidget(ui_popLayer);
	ui_pop_exit = TRUE; /* signal to leave temporary loop */
	XFlush(ui_display);
	break;
      case UI_POPUP_REMOTE:
	ui_remoteIsCreated = FALSE;
	XtDestroyWidget(ui_popRemote);
	break;
      case UI_POPUP_WEIGHTS_DONE:
	XtDestroyWidget(ui_popInit);
	ui_pop_exit = TRUE; /* signal to leave temporary loop */
	break;
      case UI_POPUP_WEIGHTS_CANCEL:
	XtDestroyWidget(ui_popWeights);
	ui_pop_exit = TRUE; /* signal to leave temporary loop */
	XFlush(ui_display);
        break;
      case UI_POPUP_RESULT:
        XtDestroyWidget(ui_popResult);
        ui_ResultIsCreated = FALSE;
 	break;

    }
    ui_printMessage("");
}



/*****************************************************************************
  FUNCTION : ui_rem_initNet

  PURPOSE  : 
  NOTES    :

  UPDATE   : 18.3.1991
******************************************************************************/

void
ui_rem_initNet(button, randomType, call_data)
     Widget	button;		
     int        randomType;
     caddr_t    call_data;
{
    Widget      doneButton, form, label, title, sbutton;
    Arg		args[5];
    Position	x, y;
    Dimension	width, height;
    Cardinal	n;
    XEvent      event;
    char        buf[120];
    int         i;


    /* Upper left corner will be in the center of the calling button */

    ui_xGetDimensions(button, &width, &height);
    XtTranslateCoords(button, (Position) (width / 2), 
		      (Position) (height / 2),
		      &x, &y);
    
    n = 0;
    XtSetArg(args[n], XtNx, x);	n++;
    XtSetArg(args[n], XtNy, y);	n++;
    
    
    /* Now create Popup */
    
    ui_popInit = 
	XtCreatePopupShell("initialize net", transientShellWidgetClass, ui_toplevel,
			   args, n);
    
    form = 
	XtCreateManagedWidget("form", formWidgetClass, ui_popInit, 
			      NULL, ZERO);
 
    title =
	ui_xCreateLabelItem("Initialize net", form, 14*8, NULL, NULL);

    sprintf(buf,"using: %s", krui_getInitialisationFunc()); 
    title =
	ui_xCreateLabelItem("title", form, 10*8, NULL, title);
    ui_xSetResize(title, TRUE);
    ui_xSetLabel(title, buf);

    label =
	ui_xCreateLabelItem("parameters:", form, 11*8, NULL, title);
    
    for (i=0; i< UI_NO_INIT_PARAMS; i++) {
	sprintf(buf,"%9.3f", ui_initParameters[i]);
	ui_initParameterWidgets[i] =
	    ui_xCreateDialogItem("param", form, buf, 9*8, 
				 (i==0 OR i==3) ? label : 
				 ui_initParameterWidgets[i-1], 
				 i<3 ? title : ui_initParameterWidgets[0]);
    }

    doneButton = 
	ui_xCreateButtonItem("done", form, NULL, ui_initParameterWidgets[0]);
    XtAddCallback(doneButton, XtNcallback, ui_popupDone, UI_POPUP_WEIGHTS_DONE);
    /*!*/  /* constant name is meaningless ! */

    sbutton = 
	ui_xCreateButtonItem("init", form, doneButton, ui_initParameterWidgets[0]);
    XtAddCallback(sbutton, XtNcallback, ui_rem_doInitialization, NULL);
    
    XtPopup(ui_popInit, XtGrabExclusive);

    ui_pop_exit = FALSE;
    while (NOT ui_pop_exit) { /* exit after pressing the DONE button */
	XtAppNextEvent(ui_appContext, &event);
	(void) XtDispatchEvent(&event);
    }
}




/*****************************************************************************
  FUNCTION : ui_popupWeights

  PURPOSE  : popup of random/jog weights
  NOTES    :

  UPDATE   : 27.5.1990
******************************************************************************/

void
ui_popupWeights(button, randomType, call_data)
     Widget	button;		
     int        randomType;
     caddr_t    call_data;
{
    Widget      doneButton, form, label, title, sbutton;
    Arg		args[5];
    Position	x, y;
    Dimension	width, height;
    Cardinal	n;
    XEvent      event;


    /* Upper left corner will be in the center of the calling button */

    ui_xGetDimensions(button, &width, &height);
    XtTranslateCoords(button, (Position) (width / 2), 
		      (Position) (height / 2),
		      &x, &y);
    
    n = 0;
    XtSetArg(args[n], XtNx, x);	n++;
    XtSetArg(args[n], XtNy, y);	n++;
    
    
    /* Now create Popup */
    
    ui_popWeights = 
	XtCreatePopupShell("jog weights", transientShellWidgetClass, ui_toplevel,
			   args, n);
    
    form = 
	XtCreateManagedWidget("form", formWidgetClass, ui_popWeights, 
			      NULL, ZERO);

    title =
	ui_xCreateLabelItem("set link weights:", form, 20*8, NULL, NULL);
    ui_xSetResize(title, TRUE);

    label =
	ui_xCreateLabelItem("low  limit:", form, 11*8, NULL, title);

    ui_lowLimitWidget =
	ui_xCreateDialogItem("lowLimit", form, "-0.001", 9*8, label, title);

    label =
	ui_xCreateLabelItem("high limit:", form, 11*8, NULL, ui_lowLimitWidget);

    ui_highLimitWidget =
	ui_xCreateDialogItem("highLimit", form, "0.001", 9*8, label, ui_lowLimitWidget);

    doneButton = 
	ui_xCreateButtonItem("done", form, NULL, ui_highLimitWidget);
    XtAddCallback(doneButton, XtNcallback, ui_popupDone, UI_POPUP_WEIGHTS_CANCEL);

    sbutton = 
	ui_xCreateButtonItem("set", form, doneButton, ui_highLimitWidget);
    XtAddCallback(sbutton, XtNcallback, ui_rem_setRandomWeights, randomType);
    
    XtPopup(ui_popWeights, XtGrabExclusive);

    ui_pop_exit = FALSE;
    while (NOT ui_pop_exit) { /* exit after pressing the DONE button */
	XtAppNextEvent(ui_appContext, &event);
	(void) XtDispatchEvent(&event);
    }
}




/*****************************************************************************
  FUNCTION : ui_editPopup

  PURPOSE  : edit popup of f-types
  NOTES    :

  UPDATE   : 27.8.1990
******************************************************************************/

void
ui_editPopup(w, listDescriptorPtr, call_data)
     Widget                 w;	
     struct SimpleListType  *listDescriptorPtr;
     caddr_t                call_data;
{
    Widget      doneButton, abutton, form, actLabel, label, button;
    Arg		args[10];
    Position	x, y;
    Dimension	width, height;
    Cardinal	n;

    /* Upper left corner will be in the center of the calling button */

    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(listDescriptorPtr->widgetPtr, args, n);
    XtTranslateCoords(listDescriptorPtr->widgetPtr,
		      (Position) (width / 2), (Position) (height / 2),
		      &x, &y);

    n = 0;
    XtSetArg(args[n], XtNx, x);	n++;
    XtSetArg(args[n], XtNy, y);	n++;

    /* Now create Popup */

    ui_popEdit = 
	XtCreatePopupShell("edit f-types", transientShellWidgetClass, ui_toplevel,
			   args, n);

    form = 
	XtCreateManagedWidget("form", formWidgetClass, ui_popEdit, 
			      NULL, ZERO);

    
    label = 
	ui_xCreateLabelItem("msg", form, 14*8, NULL, NULL);
    ui_xSetLabel(label, "Edit f-type");
    ui_xSetResize(label, TRUE);

    ui_edit_ftypeNameWidget = 
	ui_xCreateDialogItem("name", form, "", 25*8, label, NULL);

    button =
	ui_xCreateButtonItem("select", form, NULL, label);
    XtAddCallback(button, XtNcallback, ui_edit_selectFunction, 
		  UI_EDIT_ACT_FUNC);

    actLabel = 
	ui_xCreateLabelItem("actFunc", form, 11*8, button, label);
    ui_xSetLabel(actLabel, "act. func.:");

    ui_edit_actFuncNameWidget = 
	ui_xCreateLabelItem("actFuncName", form, 25*8, actLabel, label);
    ui_xSetResize(ui_edit_actFuncNameWidget, TRUE);
    ui_xSetLabel(ui_edit_actFuncNameWidget,"");
	

    button =
	ui_xCreateButtonItem("select", form, NULL, actLabel);
    XtAddCallback(button, XtNcallback, ui_edit_selectFunction, 
		  UI_EDIT_OUT_FUNC);

    label = 
	ui_xCreateLabelItem("outFunc", form, 11*8, button, actLabel);
    ui_xSetLabel(label, "out. func.:");

    ui_edit_outFuncNameWidget = 
	ui_xCreateLabelItem("outFuncName", form, 25*8, label, actLabel);
    ui_xSetResize(label, TRUE);
    ui_xSetLabel(ui_edit_outFuncNameWidget,"");

	
/*    button =
	ui_xCreateMenuButtonItem("icon", form, NULL, label);
    label =
	ui_xCreateLabelItem("box", form, 11*8, button, label);
*/
    abutton =
	ui_xCreateButtonItem("add", form, NULL, label);
    XtAddCallback(abutton, XtNcallback, ui_edit_ftypeAddSite, 
		  (struct SimpleListType *) listDescriptorPtr);

    button =
	ui_xCreateButtonItem("delete", form, abutton, label);
    XtAddCallback(button, XtNcallback, ui_edit_ftypeDeleteSite, 
		  (struct SimpleListType *) listDescriptorPtr);
    

    n = 0; 
    XtSetArg(args[n], XtNfromHoriz, button ); n++;
    XtSetArg(args[n], XtNfromVert , label   ); n++;
    XtSetArg(args[n], XtNleft  , XtChainLeft); n++;
    XtSetArg(args[n], XtNright , XtChainLeft); n++;
    XtSetArg(args[n], XtNtop   , XtChainTop ); n++;
    XtSetArg(args[n], XtNbottom, XtChainTop ); n++;

    listDescriptorPtr->listWidget =
	XtCreateManagedWidget("list", listWidgetClass, form, args, n);
    ui_list_buildList(listDescriptorPtr);
    ui_xSetResize(listDescriptorPtr->listWidget, TRUE);
   /* XtAddCallback(listDescriptorPtr->listWidget, XtNcallback, 
		  ui_edit_listSetSite, UI_EDIT_FTYPE);
		  */
   
	
    doneButton = 
	ui_xCreateButtonItem("done", form, NULL, 
			     listDescriptorPtr->listWidget);
    XtAddCallback(doneButton, XtNcallback, ui_editPopupDone, 
		  (struct SimpleListType *) listDescriptorPtr);
 
    button =
	ui_xCreateButtonItem("choose", form, doneButton, 
			     listDescriptorPtr->listWidget);
    XtAddCallback(button, XtNcallback, ui_edit_chooseFType, 
		  (struct SimpleListType *) listDescriptorPtr);


    button =
	ui_xCreateButtonItem("set", form, button, 
			     listDescriptorPtr->listWidget);
    XtAddCallback(button, XtNcallback, ui_edit_setFType, 
		  (struct SimpleListType *) listDescriptorPtr);

    button =
	ui_xCreateButtonItem("new", form, button, 
			     listDescriptorPtr->listWidget);
    XtAddCallback(button, XtNcallback, ui_edit_newFType, 
		  (struct SimpleListType *) listDescriptorPtr);

    button =
	ui_xCreateButtonItem("delete", form, button, 
			     listDescriptorPtr->listWidget);
    XtAddCallback(button, XtNcallback, ui_edit_deleteFType, 
		  (struct SimpleListType *) listDescriptorPtr);


    ui_edit_displayFirstFType(listDescriptorPtr);

    XawFormDoLayout(form, True);
    XtPopup(ui_popEdit, XtGrabExclusive);
}





/*****************************************************************************
  FUNCTION : ui_editSitePopup

  PURPOSE  : edit popup (sites)
  NOTES    :

  UPDATE   : 27.9.1990
******************************************************************************/

void
ui_editSitePopup(w, listDescriptorPtr, call_data)
     Widget                 w;	
     struct SimpleListType  *listDescriptorPtr;
     caddr_t                call_data;
{
    Widget      doneButton, form, actLabel, label, button, sbutton;
    Arg		args[10];
    Position	x, y;
    Dimension	width, height;
    Cardinal	n;
    char        *name, *func;

    /* Upper left corner will be in the center of the calling button */

    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(listDescriptorPtr->widgetPtr, args, n);
    XtTranslateCoords(listDescriptorPtr->widgetPtr,
		      (Position) (width / 2), (Position) (height / 2),
		      &x, &y);

    n = 0;
    XtSetArg(args[n], XtNx, x);	n++;
    XtSetArg(args[n], XtNy, y);	n++;

    /* Now create Popup */

    ui_popEdit = 
	XtCreatePopupShell("edit sites", transientShellWidgetClass, ui_toplevel,
			   args, n);

    form = 
	XtCreateManagedWidget("form", formWidgetClass, ui_popEdit, 
			      NULL, ZERO);

    
    label = 
	ui_xCreateLabelItem("msg", form, 14*8, NULL, NULL);
    ui_xSetResize(label, TRUE);
    ui_xSetLabel (label, "Edit site");

    ui_edit_siteNameWidget = 
	ui_xCreateDialogItem("name", form, "", 25*8, label, NULL);

    button =
	ui_xCreateButtonItem("select", form, NULL, label);
    XtAddCallback(button, XtNcallback, ui_edit_selectFunction, UI_EDIT_SITE_FUNC);
       
    actLabel = 
	ui_xCreateLabelItem("SiteFunc", form, 11*8, button, label);
    ui_xSetLabel(actLabel, "site func.:");

    ui_edit_siteFuncNameWidget = 
	ui_xCreateLabelItem("name", form, 25*8, actLabel, label);
    ui_xSetResize(ui_edit_siteFuncNameWidget, TRUE);

    doneButton = 
	ui_xCreateButtonItem("done", form, NULL, button);
    XtAddCallback(doneButton, XtNcallback, ui_editPopupDone, 
		  (struct SimpleListType *) listDescriptorPtr);
 
    sbutton =
	ui_xCreateButtonItem("set", form, doneButton, button);
    XtAddCallback(sbutton, XtNcallback, ui_edit_setSite, 
		  (struct SimpleListType *) listDescriptorPtr);

    n = 0; 
    XtSetArg(args[n], XtNfromHoriz, NULL); n++;
    XtSetArg(args[n], XtNfromVert , sbutton);  n++;
    XtSetArg(args[n], XtNleft  , XtChainLeft); n++;
    XtSetArg(args[n], XtNright , XtChainLeft); n++;
    XtSetArg(args[n], XtNtop   , XtChainTop); n++;
    XtSetArg(args[n], XtNbottom, XtChainTop); n++;

    listDescriptorPtr->listWidget =
	XtCreateManagedWidget("list", listWidgetClass, form, args, n);
    ui_list_buildList(listDescriptorPtr);
    XtAddCallback(listDescriptorPtr->listWidget, XtNcallback, 
		  ui_edit_listSetSite, UI_EDIT_SITE);
    ui_xSetResize(listDescriptorPtr->listWidget, TRUE);
    
    if (krui_getFirstSiteTableEntry(&name, &func)) 
	XawListHighlight(listDescriptorPtr->listWidget, 1);
    /* name is NULL, if there is no first site ! */
    ui_edit_setCurrentSite(name);

    button =
	ui_xCreateButtonItem("new", form, listDescriptorPtr->listWidget, sbutton);
    XtAddCallback(button, XtNcallback, ui_edit_newSite, 
		  (struct SimpleListType *) listDescriptorPtr);

    button =
	ui_xCreateButtonItem("delete", form, button, sbutton);
    XtAddCallback(button, XtNcallback, ui_edit_deleteSite, 
		  (struct SimpleListType *) listDescriptorPtr);
    
    if (krui_getFirstSiteTableEntry(&name, &func)) {
	sprintf(ui_edit_siteName,"%s",name);
	sprintf(ui_edit_siteFuncName,"%s",func);
	ui_xSetLabel(ui_edit_siteFuncNameWidget, ui_edit_siteFuncName);
	ui_xSetString(ui_edit_siteNameWidget, ui_edit_siteName);
    }

    XtPopup(ui_popEdit, XtGrabExclusive);
}





/*****************************************************************************
  FUNCTION : ui_listPopup

  PURPOSE  : popup a list panel
  NOTES    :

  UPDATE   : 27.8.1990
******************************************************************************/

void
ui_listPopup(listDescriptorPtr, x,y)
     struct SimpleListType  *listDescriptorPtr;
     Position               x,y;
{
    Widget      doneButton, form, label;
    char        buf[80], title[80];
    Arg		args[5];
    Cardinal	n;
    XEvent      event;

    /* Upper left corner will be in the center of the calling button */

    n = 0;
    XtSetArg(args[n], XtNx, x);	n++;
    XtSetArg(args[n], XtNy, y);	n++;

    /* Now create Popup */

    sprintf (title, listDescriptorPtr->msg);
    title[0] = tolower(title[0]);  
    ui_popList = 
	XtCreatePopupShell(title, transientShellWidgetClass, ui_toplevel,
                           args, n);

    form = 
	XtCreateManagedWidget("form", formWidgetClass, ui_popList, 
			      NULL, ZERO);

    
    label = 
	ui_xCreateLabelItem("msg", form, 80*8, NULL, NULL);
    ui_xSetResize(label, TRUE);
    ui_xSetLabel(label, listDescriptorPtr->msg);

    if ((listDescriptorPtr->unitPtr != NULL) AND 
	(listDescriptorPtr->unitPtr->no != ZERO)) {
	label = 
	    ui_xCreateLabelItem("msg", form, 80*8, NULL, label);
	ui_xSetResize(label, TRUE);
	sprintf(buf,"unit #%d - %s", 
		listDescriptorPtr->unitPtr->no, 
		listDescriptorPtr->unitPtr->name);
	ui_xSetLabel(label, buf);
    }

    n = 0; 
    XtSetArg(args[n], XtNfromHoriz, NULL); n++;
    XtSetArg(args[n], XtNfromVert , label);  n++;
    XtSetArg(args[n], XtNleft  , XtChainLeft); n++;
    XtSetArg(args[n], XtNright , XtChainLeft); n++;
    XtSetArg(args[n], XtNtop   , XtChainTop); n++;
    XtSetArg(args[n], XtNbottom, XtChainTop); n++;

    listDescriptorPtr->listWidget =
	XtCreateManagedWidget("list", listWidgetClass, form, args, n);
    ui_list_buildList(listDescriptorPtr);
    XtAddCallback(listDescriptorPtr->listWidget, XtNcallback, 
		  ui_list_setUnitValue, 
		  (struct SimpleListType  *) listDescriptorPtr);
    ui_list_returnIndex = XAW_LIST_NONE;

/* NEW for Unitfunction Display */


    if ((listDescriptorPtr->unitPtr != NULL) AND 
	(listDescriptorPtr->unitPtr->no != ZERO)) {
      if( listDescriptorPtr->unitPtr->no == ui_sourceUnit.no){
        if(listDescriptorPtr->listType == UI_LIST_ACT_FUNC){
	  XtAddCallback(listDescriptorPtr->listWidget, XtNcallback, 
		        ui_drawFunction,"Source Act");
        }else if(listDescriptorPtr->listType == UI_LIST_OUT_FUNC){
	  XtAddCallback(listDescriptorPtr->listWidget, XtNcallback, 
		        ui_drawFunction,"Source Out");
        }
      }else {
        if(listDescriptorPtr->listType == UI_LIST_ACT_FUNC){
	  XtAddCallback(listDescriptorPtr->listWidget, XtNcallback, 
		        ui_drawFunction,"Target Act");
        }else if(listDescriptorPtr->listType == UI_LIST_OUT_FUNC){
	  XtAddCallback(listDescriptorPtr->listWidget, XtNcallback, 
		        ui_drawFunction,"Target Out");
        }
      }
    }


/*end New */



    doneButton = 
	ui_xCreateButtonItem("done", form, NULL, listDescriptorPtr->listWidget);
    XtAddCallback(doneButton, XtNcallback, ui_listPopupDone, 
		  (struct SimpleListType  *) listDescriptorPtr);

    XtPopup(ui_popList, XtGrabExclusive);

    ui_pop_exit = FALSE;
    while (NOT ui_pop_exit) { /* exit after pressing the DONE button */
	XtAppNextEvent(ui_appContext, &event);
	(void) XtDispatchEvent(&event);
    }
}



/*****************************************************************************
  FUNCTION : ui_popupSetup

  PURPOSE  : popup a setup panel
  NOTES    :

  UPDATE   : 27.5.1990
******************************************************************************/

void
ui_popupSetup(button, displayPtr, call_data)
     Widget	            button;		
     struct Ui_DisplayType  *displayPtr;
     caddr_t                call_data;
{
    Widget      doneButton;
    Arg		args[5];
    Position	x, y;
    Dimension	width, height;
    Cardinal	n;


    /* Upper left corner will be in the center of the calling button */


    if (NOT ui_setupIsCreated) {

	n = 0;
	XtSetArg(args[0], XtNwidth, &width); n++;
	XtSetArg(args[1], XtNheight, &height); n++;
	XtGetValues(button, args, n);
	XtTranslateCoords(button, (Position) (width / 2), 
			  (Position) (height / 2),
			  &x, &y);

	n = 0;
	XtSetArg(args[n], XtNx, x);	n++;
	XtSetArg(args[n], XtNy, y);	n++;


	/* Now create Popup */

	ui_popSetup = 
	    XtCreatePopupShell("setup", transientShellWidgetClass, 
			       ui_toplevel, args, n);

	ui_setupBox = 
	    XtCreateManagedWidget("form", formWidgetClass, ui_popSetup, 
				  NULL, ZERO);

	ui_xCreateSetupPanel(ui_setupBox, displayPtr);

	doneButton = 
	    ui_xCreateButtonItem("done", ui_setupBox, NULL, ui_setupPanel);
	XtAddCallback(doneButton, XtNcallback, ui_popupDone, UI_POPUP_SETUP);
	ui_setupSliderMessage = 
	    ui_xCreateLabelItem("", ui_setupBox, 30*8, 
				doneButton, ui_setupPanel);
	XtPopup(ui_popSetup, XtGrabExclusive);
    }
}




/*****************************************************************************
  FUNCTION : ui_displayFilePanel

  PURPOSE  : popup the file panel
  NOTES    :

  UPDATE   : 22.5.1990
******************************************************************************/

void
ui_displayFilePanel(w, button, call_data)
     Widget    w;		
     Widget    button;
     caddr_t   call_data;
{
    Widget      doneButton;
    Arg		args[5];
    Position	x, y;
    Dimension	width, height;
    Cardinal	n;


    if (ui_filePannelPoppedUp)
        return;
    ui_filePannelPoppedUp = TRUE;

    /* Upper left corner will be in the center of the calling button */

    n = 0;
    XtSetArg(args[0], XtNwidth, &width); n++;
    XtSetArg(args[1], XtNheight, &height); n++;
    XtGetValues(button, args, n);

    XtTranslateCoords(button, (Position) 0, (Position) (height),
		      &x, &y);

    n = 0;
    XtSetArg(args[n], XtNx, x);	n++;
    XtSetArg(args[n], XtNy, y);	n++;


    /* Now create Popup */

    ui_popFile = 
	XtCreatePopupShell("file browser", transientShellWidgetClass, button,
			   args, n);

    ui_fileBox = 
	XtCreateManagedWidget("box", boxWidgetClass, ui_popFile, NULL, ZERO);

    ui_xCreateFilePanel(ui_fileBox);


    doneButton = 
	ui_xCreateButtonItem("done", ui_fileBox, NULL, ui_filePanel);
    XtAddCallback(doneButton, XtNcallback, ui_popupDone, UI_POPUP_FILE);
    ui_fileIsCreated = TRUE;
    XtPopup(ui_popFile, XtGrabNone);
}




/*****************************************************************************
  FUNCTION : ui_displayLayerPanel

  PURPOSE  : popup the layer panel
  NOTES    :

  UPDATE   : 22.5.1990
******************************************************************************/

void
ui_displayLayerPanel(x,y)
     Position	x, y;
{
    Widget      doneButton, layerBox;
    Arg		args[5];
    Cardinal	n;
    XEvent      event;

    /* Upper left corner will be in the center of the calling button */

    n = 0;
    XtSetArg(args[n], XtNx, x);	n++;
    XtSetArg(args[n], XtNy, y);	n++;
    ui_popLayer = 
	XtCreatePopupShell("layers", transientShellWidgetClass, ui_toplevel,
			   args, n);

    layerBox = 
	XtCreateManagedWidget("box", boxWidgetClass, ui_popLayer, NULL, ZERO);

    ui_xCreateLayerPanel(layerBox);


    doneButton = 
	ui_xCreateButtonItem("done", layerBox, NULL, NULL);
    XtAddCallback(doneButton, XtNcallback, ui_popupDone, UI_POPUP_LAYER);

    XtPopup(ui_popLayer, XtGrabExclusive);

    ui_pop_exit = FALSE;
    while (NOT ui_pop_exit) { /* exit after pressing the DONE button */
	XtAppNextEvent(ui_appContext, &event);
	(void) XtDispatchEvent(&event);
    }
}




/*****************************************************************************
  FUNCTION : ui_refresh

  PURPOSE  : Refresh of a network graphic window case of an expose event
  NOTES    :

  UPDATE   : 15.5.1990
******************************************************************************/


void ui_refresh(w, displayPtr, event)
     Widget   w;
     struct Ui_DisplayType  *displayPtr;
     XEvent   *event;
{
    switch ((*event).type) {
      case Expose:
	if (event->xexpose.count == 0) {

	    ui_xGetDimensions(displayPtr->widget, 
			      &(displayPtr->width), 
			      &(displayPtr->height));
    
	    displayPtr->unitsInX = 
		displayPtr->width  / displayPtr->gridSize;
	    displayPtr->unitsInY = 
		displayPtr->height / displayPtr->gridSize;
	    ui_net_completeRefresh(displayPtr, UI_LOCAL); 
	}
	break;
      case ConfigureNotify:
	ui_xGetDimensions(displayPtr->widget, 
			  &(displayPtr->width), 
			  &(displayPtr->height));
	displayPtr->unitsInX = 
	    displayPtr->width  / displayPtr->gridSize;
	displayPtr->unitsInY = 
	    displayPtr->height / displayPtr->gridSize;
	break;
    }
}




/*****************************************************************************
  FUNCTION : ui_displayGraphic

  PURPOSE  : display a graphic window
  NOTES    :

  UPDATE   : 1.4.1990
******************************************************************************/

void
ui_displayGraphic(button, displPtr, call_data)
     Widget	button;		
     struct Ui_DisplayType  *displPtr;
     caddr_t    call_data;
{
    Widget         fbutton;
    Arg		   args[10];
    Cardinal	   n;
    char           buf[40];
    XtTranslations trans;
   
    struct Ui_DisplayType  *displayPtr;

    if (displPtr == NULL) {
	/* call from the GUI menue */
	if ((displayPtr = ui_displ_getFreeItem()) == NULL) {
	    ui_confirmOk("No more memory for displays available!");
	    return;
	}
    } else
	/* call from ui_cfg_load() */
	displayPtr = displPtr;

    sprintf(buf,"snns-display %d - subnet: %d",
	    displayPtr->displayNo, displayPtr->subNetNo);

    n = 0;
    if (displPtr != NULL) {
	/* give window manager hints */
    }

    ui_popCanvas = 
	XtCreatePopupShell(buf, topLevelShellWidgetClass, ui_toplevel,
			   args, n);

    ui_display  = XtDisplay(ui_popCanvas);
    ui_screen   = DefaultScreen(ui_display);

    /* now create the display structure to held data */

    displayPtr->frameWidget = 
	XtCreateManagedWidget("form", formWidgetClass, ui_popCanvas, 
			      NULL, ZERO);

    fbutton = ui_xCreateButtonItem("done", displayPtr->frameWidget, NULL, NULL);
    XtAddCallback(fbutton, XtNcallback, ui_displayDone, 
		  (struct Ui_DisplayType  *) displayPtr);

    fbutton = ui_xCreateButtonItem("setup", displayPtr->frameWidget, fbutton, NULL);
    XtAddCallback(fbutton, XtNcallback, ui_popupSetup, 
		  (struct Ui_DisplayType *) displayPtr);

    fbutton = ui_xCreateToggleItem("freeze", displayPtr->frameWidget, NULL, fbutton, NULL);
    ui_xSetToggleState(fbutton, displayPtr->frozen);
    XtAddCallback(fbutton, XtNcallback, ui_displ_freezeDisplay, 
		  (struct Ui_DisplayType *) displayPtr);

    n = 0;
    XtSetArg(args[n], XtNwidth,  displayPtr->width); n++;
    XtSetArg(args[n], XtNheight, displayPtr->height); n++;
    XtSetArg(args[n], XtNfromVert, fbutton); n++;
    XtSetArg(args[n], XtNleft  , XtChainLeft); n++;
    XtSetArg(args[n], XtNright , XtChainRight); n++;
    XtSetArg(args[n], XtNtop   , XtChainTop); n++;
    XtSetArg(args[n], XtNbottom, XtChainBottom); n++;
    displayPtr->widget = 
	XtCreateManagedWidget("display", boxWidgetClass, 
			      displayPtr->frameWidget, args, n);
    trans =
	XtParseTranslationTable("Ctrl<Btn1Down>: XawPositionSimpleMenu(popmenu) MenuPopup(popmenu)");
    
    XtAugmentTranslations(displayPtr->widget, trans);                     
    

    XtAddEventHandler(displayPtr->widget, ExposureMask, GraphicsExpose, 
		      ui_refresh, (struct Ui_DisplayType *) displayPtr);
    XtAddEventHandler(ui_popCanvas, StructureNotifyMask | SubstructureNotifyMask, FALSE, 
		      ui_refresh, (struct Ui_DisplayType *) displayPtr);
    XtAddEventHandler(displayPtr->widget, 
		      ButtonPressMask | ButtonMotionMask | ButtonReleaseMask 
		      | EnterWindowMask | LeaveWindowMask,
		      FALSE, ui_mw_eventProc, 
		      (struct Ui_DisplayType *) displayPtr);
    XtAddEventHandler(displayPtr->widget, 
		      KeyPressMask, FALSE, ui_can_KEventProc, 
		      (struct Ui_DisplayType *) displayPtr);
    XtAddEventHandler(ui_popCanvas, StructureNotifyMask,
		      FALSE, ui_can_MapEventProc, 
		      (struct Ui_DisplayType *) displayPtr);

    XtPopup(ui_popCanvas, XtGrabNone);

    displayPtr->drawable = XtWindow(displayPtr->widget);

    ui_xToggleBackingStore(TRUE, ui_display, displayPtr->drawable);

    XSelectInput(ui_display, displayPtr->drawable, 
		 ExposureMask | PointerMotionMask |
		 ButtonPressMask | ButtonMotionMask | ButtonReleaseMask |
		 KeyPressMask | EnterWindowMask | LeaveWindowMask);

    XGrabButton(ui_display, AnyButton, AnyModifier, displayPtr->drawable, TRUE,
		ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
		GrabModeAsync, GrabModeAsync, displayPtr->drawable,	
		XCreateFontCursor(ui_display, XC_crosshair));
    

}




/*****************************************************************************
  FUNCTION : ui_textLook

  PURPOSE  : callback. Called when clicked on the LOOK button 
  NOTES    :

  UPDATE   : 1.5.1990
******************************************************************************/


void 
ui_textLook(widget, client_data, call_data)
     Widget	widget;		
     XtPointer  client_data, call_data;	
{
    Widget           w, src;
    XawTextBlock     textBlock;
    XawTextPosition  start, end, found; /* int ! */
    char             buf[80], sWord[SEARCH_WORD_MAXLEN+1];
    Cardinal         n;
    Arg              args[5];

    w = (Widget) client_data; 
    
    XawTextGetSelectionPos(w, &start, &end);

    if (start != end) {
	if ((end-start+1) > SEARCH_WORD_MAXLEN) 
	    end = start + SEARCH_WORD_MAXLEN;

	n = 0;
	XtSetArg(args[n], XtNtextSource, &src); n++;
	XtGetValues(w, args, n);
	 
	found = XawTextSourceRead(src, (int) start, &textBlock, (int) (end-start));

	textBlock.firstPos = 0;
	textBlock.length   = end - start;
	textBlock.format   = FMT8BIT;
	

	XawTextSetInsertionPoint(w, 0);
	found = XawTextSearch(w, XawsdRight, &textBlock);
	if (found > 0) {
	    strncpy(sWord, textBlock.ptr, (int) (end - start));
	    sWord[end-start] = '\0';
#ifdef DEBUG
	    sprintf(buf, "Found: <%s>", sWord);
	    ui_printMessage(buf);
#endif
	    XawTextSetInsertionPoint(w, (int) (found + textBlock.length));
	    XawTextSetSelection(w, (int) found, 
				(int) (found + textBlock.length));
	    XawTextInvalidate(w, (int) found, 
			      (int) (found + textBlock.length));
	}
    }	
}



/*****************************************************************************
  FUNCTION : ui_textMore

  PURPOSE  : callback. Called when clicked on the MORE button
  NOTES    :

  UPDATE   : 1.5.1990
******************************************************************************/


void 
ui_textMore(widget, client_data, call_data)
     Widget	widget;		
     XtPointer  client_data, call_data;	
{
    Widget           w, src;
    XawTextBlock     textBlock;
    XawTextPosition  start, end, found; /* int ! */
    char             buf[80], sWord[SEARCH_WORD_MAXLEN+1];
    Cardinal         n;
    Arg              args[5];

    w = (Widget) client_data; 
    
    XawTextGetSelectionPos(w, &start, &end);

    if (start != end) {
	if ((end-start+1) > SEARCH_WORD_MAXLEN) 
	    end = start + SEARCH_WORD_MAXLEN;

	n = 0;
	XtSetArg(args[n], XtNtextSource, &src); n++;
	XtGetValues(w, args, n);
	 
	found = XawTextSourceRead(src, (int) start, &textBlock, 
				  (int) (end-start));

	textBlock.firstPos = 0;
	textBlock.length   = end - start;
	textBlock.format   = FMT8BIT;
	

	/* XawTextSetInsertionPoint(w, 0); */
	found = XawTextSearch(w, XawsdRight, &textBlock);
	if (found > 0) {
	    strncpy(sWord, textBlock.ptr, (int) (end - start));
	    sWord[end-start] = '\0';
#ifdef DEBUG
  	    sprintf(buf, "Found: <%s>", sWord);
	    ui_printMessage(buf);
#endif
	    XawTextSetInsertionPoint(w, (int) (found + textBlock.length));
	    XawTextSetSelection(w, (int) found, 
				(int) (found + textBlock.length));

	    XawTextInvalidate(w, (int) found, 
			      (int) (found + textBlock.length));
	}	
    }
}


/*****************************************************************************
  FUNCTION : ui_textKey

  PURPOSE  : searches in the specified ascii widget for a key string
  NOTES    :

  UPDATE   : 1.5.1990
******************************************************************************/


void 
ui_textKey(w, key)
     Widget	w;		
     char       *key;
{
    XawTextBlock     textBlock;
    XawTextPosition  found; /* int ! */
    char             buf[80];
    Cardinal         n;
    Arg              args[5];


    if (strlen(key) < 1) return;

    textBlock.ptr      = key;
    textBlock.firstPos = 0;
    textBlock.length   = strlen(key);
    textBlock.format   = FMT8BIT;
	
    XawTextSetInsertionPoint(w, 0);
    found = XawTextSearch(w, XawsdRight, &textBlock);
    if (found > 0) {
#ifdef DEBUG
	sprintf(buf, "Found: <%s>", key);
	ui_printMessage(buf);
#endif
	XawTextSetInsertionPoint(w, (int) (found + textBlock.length));
	XawTextSetSelection(w, (int) found, 
			    (int) (found + textBlock.length));
	XawTextInvalidate(w, (int) found, 
			  (int) (found + textBlock.length));
    }	
}



/*****************************************************************************
  FUNCTION : ui_textTopics

  PURPOSE  : callback. Called when clicked on the TOPICS button
  NOTES    :

  UPDATE   : 1.5.1990
******************************************************************************/


void 
ui_textTopics(widget, client_data, call_data)
     Widget	widget, client_data;
     caddr_t    call_data;	
{
    ui_textKey(client_data, "* TOPICS");
}
    


/*****************************************************************************
  FUNCTION : ui_displayRemote

  PURPOSE  : display remote-panel
  NOTES    :

  UPDATE   : 26.9.1990
******************************************************************************/

void
ui_displayRemote(w, client_data, call_data)
     Widget   w;
     caddr_t  client_data, call_data;
{
    Widget      doneButton, form;

    if (ui_remoteIsCreated) {
	ui_confirmOk("Remote panel is already created!");
	return;
    }
	
    ui_popRemote = 
	XtCreatePopupShell("snns-remote", topLevelShellWidgetClass, ui_toplevel,
			   NULL, ZERO);

    form =   
	XtCreateManagedWidget("form", formWidgetClass, ui_popRemote, 
			      NULL, ZERO);
 
    ui_xCreateRemotePanel(form); 
    
 /*   n = 0;
    XtSetArg(args[n], XtNfromHoriz, NULL);       n++;
    XtSetArg(args[n], XtNfromVert , ui_stat_selNoWidget); n++;
    XtSetArg(args[n], XtNleft  , XtChainLeft);   n++;
    XtSetArg(args[n], XtNright , XtChainLeft);   n++;
    XtSetArg(args[n], XtNtop   , XtChainTop);    n++;
    XtSetArg(args[n], XtNbottom, XtChainTop);    n++;	
    XtSetValues(ui_remotePanel, args, n);
    */


    doneButton = 
	ui_xCreateButtonItem("done", form, NULL, ui_remotePanel);
    XtAddCallback(doneButton, XtNcallback, ui_popupDone, UI_POPUP_REMOTE);

    ui_remoteMessageWidget =
	ui_xCreateLabelItem("message",form, 10*8, 
			    doneButton, ui_remotePanel); 
    ui_xSetResize(ui_remoteMessageWidget, TRUE);
    ui_xSetLabel(ui_remoteMessageWidget, "");

    XawFormDoLayout(form, True);
    XtPopup(ui_popRemote, XtGrabNone);
    ui_file_updateShellLabels();
}



/*****************************************************************************
  FUNCTION : ui_displayText

  PURPOSE  : display a help window
  NOTES    : returns false if no help.hdoc found

  UPDATE   : 1.5.1990
******************************************************************************/

void
ui_displayText(button, client_data, call_data)
     Widget	button;		
     caddr_t    client_data, call_data;
{
    Widget      doneButton, lookButton, moreButton, topicsButton, form;
    Arg		args[12];
    Cardinal	n;
    char        buf[20];
    char        hdoc[MAX_NAME_LENGTH];


    struct HelpType *listPtr;


    sprintf(hdoc, "help.hdoc");
    if (NOT ui_fileExist(hdoc,0)) {
	if (getenv("XGUILOADPATH") != NULL) 
	    sprintf(hdoc, "%s/help.hdoc", getenv("XGUILOADPATH"));
	if (NOT ui_fileExist(hdoc,0)) {
	    ui_confirmOk("Can't display help. <help.hdoc> not found.");
            ui_helpOk = FALSE;
	    return;
	}
    }

    /* first get a free help item */
    if (ui_help_freeListPtr == NULL) { /* no free item */
	listPtr = (struct HelpType *) (malloc(sizeof(struct HelpType)));
	if (listPtr == NULL) {
	    ui_confirmOk("No memory available to display a new help window!");
            ui_helpOk = FALSE;
	    return;
	}		
	listPtr->no = ++ui_noOfHelpsUp;
    } else {
	listPtr = ui_help_freeListPtr;
	ui_help_freeListPtr = listPtr->nextPtr;
    }
    /* link it in normal list */
    listPtr->nextPtr = ui_help_listPtr;
    ui_help_listPtr  = listPtr;

    sprintf(buf,"snns-help %d",listPtr->no);
    listPtr->shellWidget = 	XtCreatePopupShell(buf, topLevelShellWidgetClass, ui_toplevel,
			   NULL, ZERO);

    form =   
	XtCreateManagedWidget("form", formWidgetClass, listPtr->shellWidget, 
			      NULL, ZERO);


    doneButton = 
	ui_xCreateButtonItem("done", form, NULL, NULL);
    XtAddCallback(doneButton, XtNcallback, ui_helpDone, 
		  (struct HelpType *) listPtr); 

    lookButton = 
	ui_xCreateButtonItem("look", form,   doneButton, NULL);

    moreButton = 
	ui_xCreateButtonItem("more", form,   lookButton, NULL);

    topicsButton = 
	ui_xCreateButtonItem("topics", form, moreButton, NULL);

    /* ui_help_messageWidget =
       ui_xCreateLabelItem("", form, 80*8, topicsButton, NULL);
       ui_xSetResize(ui_help_messageWidget, TRUE);
    */
    
    n = 0;
    XtSetArg(args[n], XtNwidth,  575); n++;
    XtSetArg(args[n], XtNheight, 400); n++;
    XtSetArg(args[n], XtNtype, XawAsciiFile); n++;
    XtSetArg(args[n], XtNstring, hdoc); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
    XtSetArg(args[n], XtNfromVert , doneButton);  n++;
    XtSetArg(args[n], XtNfromHoriz, NULL);  n++;
    XtSetArg(args[n], XtNleft  , XtChainLeft);   n++;
    XtSetArg(args[n], XtNright , XtChainLeft);   n++;
    XtSetArg(args[n], XtNtop   , XtChainTop);    n++;
    XtSetArg(args[n], XtNbottom, XtChainTop);    n++;	
    listPtr->textWidget = 
	XtCreateManagedWidget("textWin", asciiTextWidgetClass, form, args, n);

    XtAddCallback(lookButton,   XtNcallback, ui_textLook,   
		  (XtPointer) listPtr->textWidget);
    XtAddCallback(moreButton,   XtNcallback, ui_textMore,   
		  (XtPointer) listPtr->textWidget);
    XtAddCallback(topicsButton, XtNcallback, ui_textTopics, 
		  (XtPointer) listPtr->textWidget);

    XawFormDoLayout(form, True);
    XtPopup(listPtr->shellWidget, XtGrabNone);
    ui_helpOk = TRUE;
}

/*****************************************************************************
  FUNCTION : ui_displayHelp

  PURPOSE  : show a help window and the first position where the key string
             was found
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/


void  ui_displayHelp(key)
     char *key;
{
    if (ui_help_listPtr != NULL) {
	/* there are help windows opened */
	/* get one, which is not iconified */
	/* struct HelpType *listPtr;
	   listOtr = ui_help_listPtr;
	   while ((listPtr != NULL) AND listPtr->unmapped)
	   listPtr = listPtr->nextPtr;
	   if (listPtr == NULL) {
	   } else
	   */
	XMapRaised(ui_display, XtWindow(ui_help_listPtr->shellWidget));
	ui_textKey(ui_help_listPtr->textWidget, key);
    } else {
	ui_displayText(NULL, NULL, NULL); /* popup a window */
        if (ui_helpOk)
	     ui_textKey(ui_help_listPtr->textWidget, key);
    }
}


/*****************************************************************************
  FUNCTION : ui_guiQuit()

  PURPOSE  : leave XGUI
  NOTES    : erases all temp files

  UPDATE   : 15.5.1992
******************************************************************************/

/*ARGSUSED*/
void 
ui_guiQuit(widget, client_data, call_data)
     Widget	widget;		
     XtPointer  client_data, call_data;
{
    char cmdLine[200];

    if (ui_confirmYes("Do you really want to quit?")) {
	krui_deleteNet();
        sprintf (cmdLine, "/bin/rm -f %s/%s* > /dev/null", ui_tmpDir, ui_praefix); 
        system (cmdLine);

 /* free all memory used by the kernel */
	XtDestroyApplicationContext(XtWidgetToApplicationContext(widget));
	exit(0);
    }
}




/*****************************************************************************
  FUNCTION : ui_syntax

  PURPOSE  :
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/


void 
ui_syntax(app_con, call)
     XtAppContext app_con;
     char *call;
{
    XtDestroyApplicationContext(app_con);
    fprintf(stderr, "Usage: %s\n", call);
    exit(1);
}



/*****************************************************************************
  FUNCTION : ui_loadFileFromCommandLine

  PURPOSE  : load files from command line
  NOTES    : load default if no cfg specified

  UPDATE   : 15.6.1992
******************************************************************************/

void
ui_loadFileFromCommandLine()

{
    if (ui_loadNetbyInit) 
       ui_file_loadNet(ZERO, NULL, NULL);
    if (ui_loadPatbyInit) 
       ui_file_loadPatterns(ZERO, NULL, NULL);

    if (ui_loadCfgbyInit) 
       ui_file_loadConfiguration(ZERO, NULL, NULL);
    else
        ui_file_loadDefaultConfiguration(ui_pathname);
}






/*****************************************************************************
  FUNCTION : ui_chkExt

  PURPOSE  : check extention for a given filename
  NOTES    :

  UPDATE   : 15.6.1992
******************************************************************************/

int
ui_chkFileName(s1, s2)

    char *s1, *s2;

{
    return (!strcmp(s1+strlen(s1)-4, s2));
}


/*****************************************************************************
  FUNCTION : ui_showHelpMsg

  PURPOSE  : displays a help message
  NOTES    :

  UPDATE   : 15.6.1992
******************************************************************************/

void
ui_showHelpMsg(call)

    char *call;

{
    fprintf(stderr, "\n\n       Stuttgart Neural Network Simulator  V 2.1\n\n");
    fprintf(stderr, "  usage  %s [netfile] [patternfile] [configuration] [options]\n\n", call);
    fprintf(stderr, "  where options are -font <name>   font for the simulator\n");  
    fprintf(stderr, "                    -dfont <name>  font for the displays\n");  
    fprintf(stderr, "                    -mono          black & white on color screens \n");  
    fprintf(stderr, "                    -help          this help\n");  
    fprintf(stderr, "\n\n");
}




/*****************************************************************************
  FUNCTION : ui_parseCmdLine

  PURPOSE  : parse command line
  NOTES    : sets options and filenames

  UPDATE   : 15.6.1992
******************************************************************************/



void
ui_parseCmdLine(app_con, noParams, params)

     XtAppContext app_con;
     int noParams;
     char *params[];

{
     int i;
     char *call;

     call = *params;

     i = 0;
     while(++i != noParams) {
         if (*params[i] == '-') {
             if ((strcmp(params[i], "-dfont")) == 0) {
                 strcpy (ui_fontName, params[++i]);
                 hasCmdlineFont = TRUE;
	     } else {
                 if ((strcmp(params[i], "-mono")) == 0) {
                     ui_monoOnColorScreen = TRUE;
	         } else {
                     if ((strcmp(params[i], "-help") == 0) 
                       OR (strcmp(params[i], "-h") == 0)) {
                         ui_showHelpMsg(call);
                         exit(1);
                     }
		 }
	     }
         } else {
             if (ui_chkFileName(params[i], ".net")) {
                 strncpy(ui_filenameNET, params[i], strlen(params[i])-4);
                 ui_loadNetbyInit = TRUE;
	     } else {
                 if (ui_chkFileName(params[i], ".pat")) {
                     strncpy(ui_filenamePAT, params[i], strlen(params[i])-4);
                     ui_loadPatbyInit = TRUE;
   	         } else {
                    if (ui_chkFileName(params[i], ".cfg")) {
                        strncpy(ui_filenameCFG, params[i], strlen(params[i])-4);
                        ui_loadCfgbyInit = TRUE;
                        ui_loadCorrespondingCfg = FALSE;
		    }
		 }
	     }
         }


     }
}





/* end of file */
/* lines: 1705 */
