/* ui_maspar.c */

/* Interface to MasPar */

#include "ui.h"



#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>


#include "ui_xWidgets.h"
#include "ui_textP.h"



static Widget connect, disconnect, standard, feedforward;

static int err;

#ifdef MASPAR_KERNEL


static void connect_MasPar ()

{ 
    err = krui_MasPar (MASPAR_CONNECT);
    if (err == KRERR_NO_ERROR) {
        ui_xSetToggleState (connect, TRUE);
        ui_xSetToggleState (disconnect, FALSE);
    } else {
        ui_tw_errorMessage (krui_error (err));
        ui_xSetToggleState (connect, FALSE);
    }
}



static void disconnect_MasPar ()

{ 
    err = krui_MasPar (MASPAR_DISCONNECT);
    if (err == KRERR_NO_ERROR) {
        ui_xSetToggleState (disconnect, TRUE);
        ui_xSetToggleState (connect, FALSE);
    } else {
        ui_tw_errorMessage (krui_error (err));
        ui_xSetToggleState (disconnect, FALSE);
    }
}



static void standard_Net ()

{
    err = krui_setSpecialNetworkType (NET_TYPE_GENERAL);
    if (err == KRERR_NO_ERROR) {
        ui_xSetToggleState (standard, TRUE);
        ui_xSetToggleState (feedforward, FALSE);
    } else {
        ui_tw_errorMessage (krui_error (err));
        ui_xSetToggleState (standard, FALSE);
    }
}



static void feedforward_Net ()

{
    err = krui_setSpecialNetworkType (NET_TYPE_FF1);
    if (err == KRERR_NO_ERROR) {
        ui_xSetToggleState (standard, FALSE);
        ui_xSetToggleState (feedforward, TRUE);
    } else {
        ui_tw_errorMessage (krui_error (err));
        ui_xSetToggleState (feedforward, FALSE);
    }
}



static void closeMasparPannel (w, pannel, call_data)

    Widget w;
    Widget pannel;
    caddr_t call_data;

{
    XtDestroyWidget (pannel);
}



void ui_masparPannel (w, button, call_data)

    Widget w;
    Widget button;
    caddr_t call_data;
    
{
    int n;
    Arg arg[10];
    char buf[20];
    Position xPos, yPos;
    Dimension width, height;
    Widget masparPannel, border, pannel, label0, label1, test1, done;

    n = 0;
    XtSetArg (arg[n], XtNwidth, &width); n++;
    XtSetArg (arg[n], XtNheight, &height); n++;
    XtGetValues (button, arg, n);
    XtTranslateCoords (button, (Position) (width / 2), (Position) (height / 2), 
                       &xPos, &yPos);

    n = 0;
    XtSetArg(arg[n], XtNx, xPos); n++;
    XtSetArg(arg[n], XtNy, yPos); n++;
    masparPannel = XtCreatePopupShell ("MasPar", transientShellWidgetClass, 
                                       button, arg, n);
    border = XtCreateManagedWidget ("border", boxWidgetClass, 
                                     masparPannel, NULL, ZERO);
    pannel = XtCreateManagedWidget ("pannel", formWidgetClass, 
                                     border, NULL, ZERO);

    label0 = ui_xCreateLabelItem ("MasPar          ", pannel, 
                                  16 * 8, NULL, NULL); 
    connect = ui_xCreateToggleItem ("connect", pannel, NULL, label0, NULL);
    disconnect = ui_xCreateToggleItem ("disconnect", pannel, NULL, connect, NULL);

    label1 = ui_xCreateLabelItem ("Network Topology", pannel, 
                                  16 * 8, NULL, label0); 
    standard = ui_xCreateToggleItem ("standard", pannel, NULL, label1, label0);
    feedforward = ui_xCreateToggleItem ("feedforward", pannel, NULL, 
                                  standard, label0);

    done = ui_xCreateButtonItem ("done", border, NULL, label1);

    XtAddCallback (done, XtNcallback, closeMasparPannel, (Widget) masparPannel);
    XtAddCallback (connect, XtNcallback, connect_MasPar, NULL);
    XtAddCallback (disconnect, XtNcallback, disconnect_MasPar, NULL);
    XtAddCallback (standard, XtNcallback, standard_Net, NULL);
    XtAddCallback (feedforward, XtNcallback, feedforward_Net, NULL);

    XtPopup (masparPannel, XtGrabNone);
}


#endif

/* end of file */
/* lines: 161 */
