/*****************************************************************************
  FILE     : ui_status.c
  SHORTNAME: status.c

  PURPOSE  : display and refresh of status information in graphic windows
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Tilman Sommer
  DATE     : 27.8.1990

             (c) 1992 by Tilman Sommer and the SNNS-Group
             
******************************************************************************/


#include "ui.h"
#include "ui_utilP.h"
#include "ui_xWidgets.h"

extern Bool    ui_safetyFlg;                  /* status of safety (editor) */
extern int     ui_sel_numberOfSelectedItems;  /* no of selected units */
/* widgets displaying the status info in the manager panel */
extern Widget  ui_stat_posWidget, ui_stat_selNoWidget, ui_stat_flagsWidget;

struct PosType ui_stat_oldPos; /* current displayed position */
int            ui_stat_oldNumberOfSelectedItems = 0; /* current number ... */
FlagType       ui_stat_oldFlags = 0;                 /* current flags */


/*****************************************************************************
  FUNCTION :                  UI_STAT_DISPLAY STATUS

  PURPOSE  : display status information.
  RETURNS  : alteration of the status panel
  NOTES    : Except the current raster position, which is taken from the
             parameter, all information is got out from global variables.
*****************************************************************************/

void
ui_stat_displayStatus(gridPos)
    struct PosType  gridPos;
{
    char   string[40];

    if (ui_stat_oldFlags != ui_safetyFlg) {
	if (ui_safetyFlg)
	    sprintf(string,": safe");
	else
	    sprintf(string,": -   ");
	ui_xSetLabel(ui_stat_flagsWidget,string);
	ui_stat_oldFlags = ui_safetyFlg;
    }

    if (ui_stat_oldNumberOfSelectedItems != ui_sel_numberOfSelectedItems) {
	sprintf(string,": %-4d", ui_sel_numberOfSelectedItems);
	ui_xSetLabel(ui_stat_selNoWidget,string);
	ui_stat_oldNumberOfSelectedItems = ui_sel_numberOfSelectedItems;
    }

    if (ui_utilAreDifferentPositions(gridPos, ui_stat_oldPos)) {
	sprintf(string,"x:%-6d  y:%-6d",gridPos.x, gridPos.y);
	ui_xSetLabel(ui_stat_posWidget,string);
	ui_stat_oldPos = gridPos;
    }
}









/* end of file */
/* lines: 77 */
