/*****************************************************************************
  FILE     : ui_textP.c
  SHORTNAME: textP.c

  PURPOSE  :
  FUNCTIONS: 
  NOTES    :

  AUTHOR   : Tilman Sommer
  DATE     : 1.2.1990

             (c) 1992 by Tilman Sommer and the SNNS-Group
             
******************************************************************************/

#include "ui.h"
#include "ui_confirmer.h"
#include <stdio.h>
#include <string.h>

extern FILE   *ui_textFilePtr;  /* file ptr of log file */



/*****************************************************************************
  FUNCTION : ui_tw_errorMessage()

  PURPOSE  : prints error messages into a confirmer
  NOTES    :

  UPDATE   : 10.12.1991
******************************************************************************/


void
ui_tw_errorMessage(message)
    char message[];
{
    char error[512];
    char *cptr, *temp;
    int max_len = 40;
    int best_len, str_len, i;

    strcpy (error, message);
    str_len = strlen(error);
    if (str_len == 0)
        return;
    best_len = str_len div (((str_len - 1) div max_len) + 1);
    cptr = error;
    i = 0;
    while (*cptr != '\0') {
       cptr++;
       i++;
       if (i == best_len) {
           temp = cptr;
           while (*temp != ' ')
               temp--;
           *temp = '\n';
           i = (int) (cptr - temp);
       }
    }
    ui_confirmOk (error);
    if (ui_textFilePtr != NULL) {
	fprintf(ui_textFilePtr, "%s\n", message);
	fflush(ui_textFilePtr);
    }
}




/*****************************************************************************
  FUNCTION : ui_tw_printMessage()

  PURPOSE  :
  NOTES    :

  UPDATE   : 1.2.1990
******************************************************************************/



void
ui_tw_printMessage(message)
     char message[];
{
    printf(message);
    if (ui_textFilePtr != NULL) {
	fprintf(ui_textFilePtr, message);
	fflush(ui_textFilePtr);
    }
}









/* end of file */
/* lines: 103 */
