/*********************** definitions **********************************/

#include <stdio.h>
#include <math.h>

#ifdef hp
#include <starbase.c.h>
#endif

/* seconds/epochs */
#define time_params 0		/* 1 = phaseends, snapshots in seconds */
#if time_params
#define counter time(0)
#else
#define counter epoch
#endif
#define toks 0                 /* tokens / no */
#define hidrepstep 5           /* this must divide the number of hidden units*/
#define inpunitstep 4          /* this must divide the number of output units*/
#define snapshotend 999999999  /* this is the last in the list of snapshots */

/* max table dimensions */
#define maxrep 50              /* maximum size of the representations */
#define maxsents 2000          /* maximum number of sentences */
#define maxwordl 20            /* maximum length of input words (chars) */
#define maxinpas 9             /* maximum number of input assemblies */
#define maxoutas 9             /* maximum number of output assemblies */
#define maxsnaps 50            /* maximum number of snapshots */
#define maxphase 5             /* maximum number of phases */
#define maxwords 100           /* maximum number of lexicon entries */

/* graphics parameters */
#define frame_color 0          /* 0 = red in color, black in bw */
#define dis_color 0            /* 0 = red in color, black in bw */
#define data_color 1           /* 1 = green in color, black in bw */
#define clear_color (cmapsize-1) /*   = black in color, white in bw */
#define unitcolors 0           /* chooses bryw colorscale */
#define weightcolors 1         /* chooses gbr colorscale */
#define smsep 0.005
#define lgsep 0.01
#define charsize 0.02
#define legendwidth 0.0725
#define marg (legendwidth+lgsep)
#define titleboxy 0.97
#define ratio 0.25

/* graphics dimensions */
float uwidth, ruwidth, uhght, ruhght, wwidth, whght, titley, inpy, wihy,
  hidy, whoy, outy, tchy, hsp, columns, left, rleft, right, rright,
  low, rlow, high, rhigh;

/* simulation parameters */
int fildes, displaying, continuing, testing, nextsnapshot,
  nphase, startepoch, epoch,
  seed, cmapsize, shuffletable[maxsents];
float colors[256][3], etas[maxphase], eta, deltasum; 
long deltanum, phaseends[maxphase], snapshots[maxsnaps];

/* actual table dimensions used */
int ninpas, noutas, ninprep, noutrep, nhidrep, nwords, nwordrep, nsents;

/* representation indeces */
int inpnums[maxsents][maxinpas], tchnums[maxsents][maxoutas];

/* units and weights */
float inprep[maxinpas][maxrep], outrep[maxoutas][maxrep],
  tchrep[maxoutas][maxrep],  hidrep[maxrep],
  wih[maxinpas][maxrep][maxrep],  who[maxoutas][maxrep][maxrep];

/* file names */
char simufile[100], wordfile[100], inputfile[100],
  cmapfile[100], sb_outdev[100], sb_outdriver[100];
FILE *fp;

/* lexicon */
struct lexicon {
  char chars[maxwordl];
  float rep[maxrep];
} wordarray[maxwords+1],*words;

/* random number functions */
double drand48();
void srand48();
long lrand48();
