#include "fgrepdefs.h"
/***************   display routines   *******************************/
 
#ifdef hp
display_init()
{
  char s[40];
  register int i;

  fildes=gopen(sb_outdev,OUTDEV,sb_outdriver,INIT);

  fp=fopen(cmapfile, "r");
  for(i=0; fscanf(fp,"%f%f%f",&colors[i][0],&colors[i][1],&colors[i][2])!=EOF; i++);
  fclose(fp);
  cmapsize=i;
  define_color_table(fildes,0,cmapsize,colors);
  
  mapping_mode(fildes,DISTORT);
  background_color_index(fildes,clear_color);
  clear_view_surface(fildes);
  perimeter_color_index(fildes,frame_color);
  interior_style(fildes, INT_HOLLOW, TRUE);
  text_color_index(fildes, data_color);

  display_init_net(0.0, 0.0, 0.9, 1.0);
  display_init_reps(0.9, 0.0, 1.0, 1.0);

  make_picture_current(fildes);
}


display_init_net(leftp, lowp, rightp, highp)
float leftp, lowp, rightp, highp;
{
  init_display_params(leftp, lowp, rightp, highp);
  display_labels(titleboxy-charsize, "SUBJECT", "VERB", "OBJECT", "WITH", "");
  display_labels(smsep, "AGENT", "ACT", "PATIENT", "INSTRUMENT", "MODIFIER");
  display_legend();
  display_title();
}  


display_init_reps(leftp, lowp, rightp, highp)
float leftp, lowp, rightp, highp;
{
  register int i;
  rleft=leftp;
  rlow=lowp;
  rright=rightp;
  rhigh=highp;
  ruhght= (1.0-(nwords+1)*smsep-lgsep)/nwords;
  ruwidth= (0.75-2*5*lgsep)/nwordrep;
  set_p1_p2(fildes, FRACTIONAL, rleft, rlow, 0.0,
	    rright, rhigh, 0.0);
  make_picture_current(fildes);
  for(i=0; i<nwords; i++)
    display_word(0.75, 1.0-lgsep-ruhght-i*(smsep+ruhght),
		 0.49, i, charsize/2.0);
  hollow_rectangle(0.0, 0.0, 1.0, 1.0, dis_color);
}


display_rep(index)
int index;
{
  display_rep_assembly(5*lgsep, 1.0-lgsep-ruhght-index*(smsep+ruhght),
		   words[index].rep, nwordrep);
}


init_display_params(leftp, lowp, rightp, highp)
float leftp, lowp, rightp, highp;
{
  float fmax();
  int imax();
  left=leftp;
  low=lowp;
  right=rightp;
  high=highp;
  columns = imax(ninpas, noutas);
  /* compute display object dimensions */
  uhght = (titleboxy-4*charsize-6*smsep-2*lgsep)
    /(4+2*nhidrep*ratio);
  uwidth = (1.0-marg-columns*lgsep)
    /(columns*imax(ninprep,noutrep));
  wwidth = uwidth;
  whght = ratio*uhght;
  hsp = (1.0-marg)/columns;
  titley = titleboxy+lgsep;
  inpy = titleboxy-2*(charsize+smsep)-uhght;
  wihy = inpy-smsep-nhidrep*whght;
  hidy = wihy-lgsep-uhght;
  whoy = hidy-lgsep-nhidrep*whght;
  outy = whoy-smsep-uhght;
  tchy = outy-smsep-uhght;
}


display_legend()
{
  /* legend */
  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0,
	    right, high, 0.0);
  hollow_rectangle(0.0, 0.0, legendwidth, titleboxy, dis_color);
  character_height(fildes, charsize);
  text2d(fildes, smsep, titley, "Current:", VDC_TEXT, FALSE);
  text2d(fildes, smsep, inpy+uhght/2, "Input", VDC_TEXT, FALSE);
  text2d(fildes, smsep, hidy+uhght/2, "Hidden", VDC_TEXT, FALSE);
  text2d(fildes, smsep, outy+uhght/2, "Output", VDC_TEXT, FALSE);
  text2d(fildes, smsep, tchy+uhght/2, "Teach", VDC_TEXT, FALSE);
  text2d(fildes, smsep, wihy+nhidrep/2.0*whght,
	 "Input", VDC_TEXT, FALSE);
  text2d(fildes, smsep, wihy+nhidrep/2.0*whght-charsize,
	 "Weights", VDC_TEXT, FALSE);
  text2d(fildes, smsep, whoy+nhidrep/2.0*whght,
	 "Output", VDC_TEXT, FALSE);
  text2d(fildes, smsep, whoy+nhidrep/2.0*whght-charsize,
	 "Weights", VDC_TEXT, FALSE);
  make_picture_current(fildes);
}


display_title()
{
  /* size on screen */
  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0,
	    right, high, 0.0);

  /* title info */
  hollow_rectangle(0.0, titleboxy, 1.0, 1.0, dis_color);
  character_height(fildes, charsize);
  text2d(fildes, marg, titley, "CumEr", VDC_TEXT, FALSE);
  text2d(fildes, marg+6.75*charsize, titley, "Epoch", VDC_TEXT, FALSE);
  text2d(fildes, marg+10.75*charsize, titley, "Item", VDC_TEXT, FALSE);
  make_picture_current(fildes);
}


display_labels(stalabely, t1, t2, t3, t4, t5)
float stalabely;
char t1[maxwordl],t2[maxwordl],t3[maxwordl],t4[maxwordl],t5[maxwordl];
{
  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0,
	    right, high, 0.0);
  hollow_rectangle(0.0, 0.0, 1.0, titleboxy, dis_color);
  character_height(fildes, charsize);
  text2d(fildes, marg, stalabely, t1, VDC_TEXT, FALSE);
  text2d(fildes, marg+hsp, stalabely, t2, VDC_TEXT, FALSE);
  text2d(fildes, marg+2*hsp, stalabely, t3, VDC_TEXT, FALSE);
  text2d(fildes, marg+3*hsp, stalabely, t4, VDC_TEXT, FALSE);
  text2d(fildes, marg+4*hsp, stalabely, t5, VDC_TEXT, FALSE);
  make_picture_current(fildes);
}  


display_cume( cume)
float cume;
{
  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0,
	    right, high, 0.0);
  display_float(marg+2.5*charsize, titley, cume);
  make_picture_current(fildes);
}


display_input(senti)
register int senti;
{
  register int i;
  char s[maxwordl*maxinpas];
  character_height(fildes, charsize);
  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0,
	    right, high, 0.0);

  /* epoch and sentence number */
  display_int(marg+9.25*charsize, titley, epoch);
  display_int(marg+13.25*charsize, titley, senti);

  /* input layer */
  for(i=0; i<ninpas; i++)
    display_word(marg+i*hsp, titleboxy-2*(charsize+smsep), hsp-smsep,
	    inpnums[senti][i], charsize);
  display_layer(ninpas, inprep, inpy, ninprep);

  /* teaching layer */
  for(i=0; i<noutas; i++)
    display_word(marg+i*hsp, tchy-charsize, hsp-smsep,
	    tchnums[senti][i], charsize);
  display_layer(noutas, tchrep, tchy, noutrep);

  make_picture_current(fildes);
}


display_layer(nas, layer, layery, nrep)
int nas, nrep;
float layer[][maxrep],layery;
{
  register int i;
  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0,
	    right, high, 0.0);
  for(i=0; i<nas; i++)
    display_assembly(marg+i*hsp, layery, layer[i], nrep);
  make_picture_current(fildes);
}	


display_assembly(startx, starty, assembly, nrep)
float startx, starty, assembly[];
int nrep;
{
  register int i;
  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0,
	    right, high, 0.0);
  for(i=0; i<nrep; i++)
    fill_rectangle(startx+i*uwidth, starty,
		   startx+(i+1)*uwidth, starty+uhght,
		   assembly[i], unitcolors);
  hollow_rectangle(startx, starty,
		   startx+nrep*uwidth, starty+uhght,
		   dis_color);
  make_picture_current(fildes);
}  


display_rep_assembly(startx, starty, assembly, nrep)
float startx, starty, assembly[];
int nrep;
{
  register int i;
  set_p1_p2(fildes, FRACTIONAL, rleft, rlow, 0.0,
	    rright, rhigh, 0.0);
  for(i=0; i<nrep; i++)
    fill_rectangle(startx+i*ruwidth, starty,
		   startx+(i+1)*ruwidth, starty+ruhght,
		   assembly[i], unitcolors);
  hollow_rectangle(startx, starty,
		   startx+nrep*ruwidth, starty+ruhght,
		   dis_color);
  make_picture_current(fildes);
}  


display_all_weights()
{
  register int  i;
  display_weight_layer(whoy,who,noutas,
		       nhidrep,noutrep);
  display_weight_layer(wihy,wih[0],ninpas,
		       nhidrep,ninprep);
  for(i=0; i<nwords; i++)
    display_rep(i);
}


display_weight_layer(weighty,weights,nboxes,nrows,ncolumns)
int nboxes,nrows,ncolumns;
float weighty,weights[][maxrep][maxrep];
{
  register int i;
  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0,
	    right, high, 0.0);
  for(i=0; i<nboxes; i++)
    display_weightbox( marg+i*hsp, weighty,
		      weights[i], nrows, ncolumns);
  make_picture_current(fildes);
}	


display_weightbox(weightx, weighty, weightbox, nrows, ncolumns)
float weightbox[][maxrep], weightx, weighty;
int nrows, ncolumns;
{
  register int i,j;
  set_p1_p2(fildes, FRACTIONAL, left, low, 0.0,
	    right, high, 0.0);
  for(i=0; i<ncolumns; i++)
    for(j=0; j<nrows; j++)
      fill_rectangle(weightx+i*wwidth, weighty+j*whght,
		     weightx+(i+1)*wwidth, weighty+(j+1)*whght,
		     weightbox[i][j], weightcolors);
  hollow_rectangle(weightx, weighty,
		   weightx+ncolumns*wwidth, weighty+nrows*whght,
		   dis_color);
  make_picture_current(fildes);
}


display_int(x, y, num)
float x, y;
int num;
{
  char s[30];
  clear_rectangle(x, y, x+charsize, y+charsize-smsep);
  character_height(fildes, charsize);
  sprintf(s,"%d",num);
  text2d(fildes, x, y, s, VDC_TEXT, FALSE);
}


display_float(x, y, num)
float x, y, num;
{
  char s[30];
  clear_rectangle(x, y, x+3.5*charsize, y+charsize-smsep);
  character_height(fildes, charsize);
  sprintf(s,"%f",num);
  text2d(fildes, x, y, s, VDC_TEXT, FALSE);
}


display_word(x, y, length, index, size)
float x, y, length, size;
int index;
{
  char s[maxwordl+1];
  clear_rectangle(x, y, x+length, y+size);
  character_height(fildes, size);
  if (index>=0)
    text2d(fildes, x, y+smsep, words[index].chars, VDC_TEXT, FALSE);
}


fill_rectangle(left, low, right, high, value, map)
float left,low,right,high,value;
int map;
{
  interior_style(fildes, INT_SOLID, FALSE);
  fill_color_index(fildes, trans_to_color(value,map));
  rectangle(fildes, left, low, right, high);
}  

clear_rectangle(left, low, right, high)
float left,low,right,high;
{
  interior_style(fildes, INT_SOLID, FALSE);
  fill_color_index(fildes,clear_color);
  rectangle(fildes, left, low, right, high);
}  

hollow_rectangle(left, low, right, high, color)
float left,low,right,high;
int color;
{
  interior_style(fildes, INT_HOLLOW, TRUE);
  perimeter_color_index(fildes, color);
  rectangle(fildes, left, low, right, high);
}  

trans_to_color(value,map)
float value;
int map;
{
  if (map==0)
    /* map the number [0,1] to corresponding color */
    return(2.0+(3.0*cmapsize/4.0-3.0)*(1.0-value));
  else
    {
      /* map [-1,1] to corresponding color, clip <-1 to -1, >1 to 1 */
      if (value<-1.0) return(cmapsize-2);
      else if (value > 1.0) return(cmapsize/2.0);
      else return(cmapsize/2.0+(cmapsize/2.0-2)*(0.5-value/2.0));
    }
}

#endif
