
/**********************************************************************
 * $Id: bm.h,v 1.3 92/11/30 11:53:51 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		       Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute,  and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided  that the above copyright notice  appears in all copies and
 * that both the copyright notice and this permission notice  appear in
 * supporting documentation, and  that  the  name of The University  of
 * Toronto  not  be used  in advertising   or publicity pertaining   to
 * distribution  of   the software   without  specific, written   prior
 * permission.  The  University  of Toronto  makes   no representations
 * about the  suitability  of  this software  for  any purpose.   It is
 * provided "as is" without express or implied warranty.
 *
 * THE  UNIVERSITY OF  TORONTO DISCLAIMS ALL WARRANTIES  WITH REGARD TO
 * THIS SOFTWARE,  INCLUDING ALL  IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT  SHALL THE UNIVERSITY  OF TORONTO BE LIABLE
 * FOR ANY SPECIAL,  INDIRECT OR CONSEQUENTIAL  DAMAGES  OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF  USE, DATA OR PROFITS,  WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE  OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF OR  IN  CONNECTION   WITH  THE  USE OR  PERFORMANCE  OF THIS
 * SOFTWARE.
 **********************************************************************/

 /*********************************************************************
 *    
 *  MFT/FEM/Boltzmann Modules written by     Evan W. Steeg
 *                                           Dept. of Computer Science
 *  August 1991                              Univ. of Toronto
 *
 **********************************************************************/

#ifndef BM_H
#define BM_H

/* The following structures must be defined, even if you don't
 * need them in you simulator
 */
typedef struct NetExtensionRec {	/* BIND */
  int   annealMethod ;          /* netParam: */
  int   numSamplingSweeps ;     /* netParam: */
  int   numRelaxations ;        /* netParam: */
  int   noAnnealInPosPhase ;    /* netParam: */
  Real	zeroErrorRadius ;	/* netParam: */
  Real	tMax ;			/* netParam: */
  Real	tMin ;			/* netParam: */
  Real	tDecay ;		/* netParam: */
  Real	temperature ;
  int   synchronousUpdate ;     /* netParam: */
  int   numExamples ;
  int   delayCount  ;           /* netParam: */
  int   relaxSweepCount ;   
  Real  relaxSweepCountAve ;   
  Boolean	running ;
} NetExtensionRec ;

typedef struct GroupExtensionRec {	/* BIND */
  int	foo ;
  ProcPtr unitPlusCorrUpdateProc;  
  ProcPtr unitMinusCorrUpdateProc;  
} GroupExtensionRec ;

typedef struct UnitExtensionRec {	/* BIND */
  int	foo ;
  Real  old ;
} UnitExtensionRec ;

typedef struct LinkExtensionRec {	/* BIND */
  Real	plusCorr ;
  Real	minusCorr ;
  Real  corrCount ; 
} LinkExtensionRec ;

typedef struct ExampleExtensionRec {	/* BIND */
  int	foo ;
} ExampleExtensionRec ;


extern struct TRACE     inRelaxation ; /* BIND */
extern Real		square ARGS((double  x)) ;


/* For choosing the anealing method option.  Only two built in.  */
#define METROPOLIS 0
#define HEATBATH 1


/* macros for getting at extension fields */
#define MannealMethod(net)		((net)->extension->annealMethod)
#define MnumSamplingSweeps(net)		((net)->extension->numSamplingSweeps)
#define MnumRelaxations(net)		((net)->extension->numRelaxations)
#define MnoAnnealInPosPhase(net)	((net)->extension->noAnnealInPosPhase)
#define MzeroErrorRadius(net)		((net)->extension->zeroErrorRadius)

#define MtMax(net)			((net)->extension->tMax)
#define MtMin(net)			((net)->extension->tMin)
#define Mtemp(net)			((net)->extension->temperature)
#define MtDecay(net)			((net)->extension->tDecay)

#define MsynchronousUpdate(net)		((net)->extension->synchronousUpdate)
#define MnumExamples(net)      		((net)->extension->numExamples)
#define MrelaxSweepCount(net)   	((net)->extension->relaxSweepCount)
#define MrelaxSweepCountAve(net) 	((net)->extension->relaxSweepCountAve)
#define Mrunning(net)			((net)->extension->running)

#define MplusCorr(link)		((link)->extension->plusCorr)
#define MminusCorr(link)	((link)->extension->minusCorr)
#define McorrCount(link)	((link)->extension->corrCount)

#define Moutput(unit)		((unit)->output)

#define USE_METROPOLIS(net)	((net)->extension->annealMethod == METROPOLIS)
#define USE_HEATBATH(net)	((net)->extension->annealMethod == HEATBATH)

/* useful macros */
#define T_MAX		5.0
#define T_MIN		1.0
#define T_DECAY		0.9

#define MIN(x, y)	((x) < (y) ? (x) : (y))
#define MAX(x, y)	((x) > (y) ? (x) : (y))

/* Macros to calculate the sigmoid */
#define simpleSigmoid(x) (1.0/(1.0+exp(-(x))))
#define sigmoid(x)       ((x) > 30 ? 			\
			  (1.0) : ((x) < -30 ? (0.0) : simpleSigmoid(x)))
#define sigmoidDeriv(x)	((x)*(1.0 - (x)))


/* Insert your favorite [0,1] random number generator here, if you don't like
   the drand48() function.                                                   */

#define MRANDOM()	    (drand48())
#define MSEEDRAND(longval)  (srand48(32459L))

extern double	drand48 ARGS((void)) ;

#endif				/* BM_H */
