
/**********************************************************************
 * $Id: help.h,v 1.3 92/11/30 11:53:52 drew Exp $
 **********************************************************************/

/**********************************************************************
 *   Copyright 1990,1991,1992,1993 by The University of Toronto,
 *		      Toronto, Ontario, Canada.
 * 
 *			 All Rights Reserved
 * 
 * Permission to use, copy, modify, distribute, and sell this software
 * and its  documentation for  any purpose is  hereby granted  without
 * fee, provided that the above copyright notice appears in all copies
 * and  that both the  copyright notice  and   this  permission notice
 * appear in   supporting documentation,  and  that the  name  of  The
 * University  of Toronto  not  be  used in  advertising or  publicity
 * pertaining   to  distribution   of  the  software without specific,
 * written prior  permission.   The  University of   Toronto makes  no
 * representations  about  the  suitability of  this software  for any
 * purpose.  It  is    provided   "as is"  without express or  implied
 * warranty.
 *
 * THE UNIVERSITY OF TORONTO DISCLAIMS  ALL WARRANTIES WITH REGARD  TO
 * THIS SOFTWARE,  INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TORONTO  BE LIABLE
 * FOR ANY  SPECIAL, INDIRECT OR CONSEQUENTIAL  DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR  PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT  OF  OR  IN  CONNECTION WITH  THE  USE  OR PERFORMANCE  OF THIS
 * SOFTWARE.
 *
 **********************************************************************/

/**********************************************************************
 * These help strings will be automatically registered 
 * and made available to the "whatis" command and "Help"
 * buttons on the GUI
 *
 * THIS FILE SHOULD ONLY BE INCLUDED BY THE FILE "bm.c"
 * ANY OTHER FILE INCLUDING IT WILL CAUSE NAME CONFLICTS
 *
 **********************************************************************/

#ifndef bm_help_h
#define bm_help_h

/*********************************************************************/
char	*helpString_annealMethod[] = {
  "Whether to use Metropolis (set to 0) or Heatbath (set to 1)",
  "stochastic state change method.",
  NULL } ;
/*********************************************************************/
char	*helpString_delayCount[] = {
  "Degree of relaxation slowdown used for viewing the details of",
  "network relaxation.  Basically, a trivial loop from 1 to",
  "delayCount*1000 is used between network relaxation sweeps.  This may",
  "be used while viewing the \"testing\" of cases (e.g. \"clicking\" on",
  "them in the \"Activations\" window) and only while the \"inRelaxation\"",
  "updating option is turned on in the Activations window. When",
  "viewing, try setting the var to 100 or 1000; performance and ease of",
  "viewing will vary depending on your machine's speed (\"raw\" CPU",
  "speed, memory access speed, screen update speed, etc.), of course.",
  NULL } ;
/*********************************************************************/
char	*helpString_noAnnealInPosPhase[] = {
  "Whether to do a simple 1-step relaxation in the positive clamped",
  "phase of learning, instead of a full annealing.  If the net has only",
  "one hidden layer, and no interconnections between hidden units, then",
  "the annealing is unnecessary because all of the units to which each",
  "hidden unit is connected remain unchanged throughout the relaxation.",
  "Setting this param to 1 when appropriate can cut the training time",
  "in half.",
  NULL } ;
/*********************************************************************/
char	*helpString_numRelaxations[] = {
  "Number of times to relax the net in the positive and negative",
  "phases for each training example. See the sman page for further",
  "explanation.",
  NULL } ;
/*********************************************************************/
char	*helpString_numSamplingSweeps[] = {
  "Number of sweeps through the network at low-temperature",
  "\"equilibrium\" to gather the <Si*Sj> samples.  See the sman page for",
  "further explanation.",
  NULL } ;
/*********************************************************************/
char	*helpString_relasSweepCount[] = {
  "The *average* number of relaxation sweeps per example per training",
  "loop.",
  NULL } ;
/*********************************************************************/
char	*helpString_synchronousUpdate[] = {
  "Whether to update the units synchronously (set var to 1) or",
  "asynchronously (set to 0) in the relaxation.  Asynch is considered",
  "much better in the vast majority of cases.  Also note that random",
  "order traversal is used in asynch case, and \"standard\" or \"row",
  "major\" order of traversing the units is used in the synch case.",
  NULL } ;
/*********************************************************************/
char	*helpString_tDecay[] = {
  "Factor by which to lower temperature at each annealing step.",
  "Something between .80 (fast annealing) and .99 (very slow annealing)",
  "is typical.",
  NULL } ;
/*********************************************************************/
char	*helpString_temperature[] = {
  "Current network temperature in annealing process.",
  NULL } ;
/*********************************************************************/
char	*helpString_tMax[] = {
  "Maximum temperature in annealing.  Usually something between 5 and",
  "30 is considered reasonable.",
  NULL } ;
/*********************************************************************/
char	*helpString_tMin[] = {
  "Minimum temperature in annealing.  Typically set to 1.0 .",
  NULL } ;
/*********************************************************************/
char	*helpString_weightCost[] = {
  "Cost associated with magnitude of weights.  It is sometimes useful",
  "to limit the absolute magnitude of weights in this way, in order to",
  "improve the trained net's \"generalization\" capabilities.",
  NULL } ;
/*********************************************************************/
char	*helpString_zeroErrorRadius[] = {
  "Interval of acceptance for agreement between desired output and",
  "target output of a unit.  The degree to which a \"near miss\" will",
  "count as a \"hit\".",
  NULL } ;
/*********************************************************************/

#endif				/* bm_help_h */
