/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "string_table.h"

#include "code_area.h"
#include "errors.h"
#include "index.h"
#include "instructions.h"
#include "pc.h"
#include "query_code.h"

global	code	*code_area;
global	natural	code_area_size = DEFAULT_CODE_AREA_SIZE;
global	code	*top_of_code_area;


/*----------------------------------------------------------------------------
    allocate memory for the code area. Set the ptr to the top of the code
    area to 1 past the beginning. The first byte is ignored for the
    predicate table (so we dont get 0 values for the offset).
----------------------------------------------------------------------------*/

extern size_t fread (void *, size_t, size_t, FILE *);
extern offset lookup_predicate_table (offset string_offset, unsigned int arity, offset code_offset, int insert);

global 	void
initialise_code_area(void)
{
	if ((code_area = (code *) malloc(Kwords_to_chars(code_area_size +
							 query_code_size)))
		== NULL)
		fatal("not enough memory for code area %d K and query code %d K",
		    code_area_size, query_code_size);
	query_code = (code *)(((char *)code_area) +
				Kwords_to_chars(code_area_size));
	top_of_code_area = code_area+1;
	reinitialise_query_code();
}


/*----------------------------------------------------------------------------
	+-------+
	|string#|
	+-------+
	| arity	|
	+-------+
	|  size	|
	+-------+
	|  c	|
	|  o	|
	|  d	|
	|  e	|
	+-------+
    read the first 3 values into temporary variables, and map the string
    number (field 1) into a new offset into the combined string table,
    place all of the code into the code area. The pointer pc is used to
    position the code in the code area.
----------------------------------------------------------------------------*/
global	void
add_procedure(index *object_index, FILE *object_file, char *filename)
{
	offset	string_num = 0;
	natural	arity = 0;
	natural	procedure_size = 0;
	code	*pc_save;
	boolean	insert;

	char	*string_ptr1;
	char	*string_ptr2;
	char	*string_ptr3;

	insert = TRUE;

	string_ptr1 = (char *) &string_num;
	string_ptr1 += 2;
	string_ptr2 = (char *) &arity;
	string_ptr2 += 3;
	string_ptr3 = (char *) &procedure_size;

	if (fread(string_ptr1, SizeOfOffset, 1, object_file) != 1)
		if (feof(object_file))
			return;
		else
			fatal("invalid file format for object file %s",
				filename);
	if (fread(string_ptr2, SizeOfNumber, 1, object_file) != 1 ||
	    fread(string_ptr3, SizeOfConstant, 1, object_file) != 1)
		fatal("invalid file format for object file %s", filename);
	pc_save = pc;
	PutOffset(object_index->string_map[string_num]);
	PutNumber(arity);
	PutConstant(procedure_size);
	pc_save = pc = code_area + lookup_predicate_table(
		object_index->string_map[string_num],
		arity, (pc_save - code_area), insert);
	if ((pc + procedure_size) > (code_area +
				     Kwords_to_chars(code_area_size)))
		fatal("Out of space in code area %d K %d", code_area_size, procedure_size);
	if (procedure_size > 0)
	{
		if (fread((char *)pc, (int)procedure_size, 1, object_file) !=
		    1)
			fatal("invalid file format for object file %s",
				filename);
		pc += procedure_size;
	}
}
