/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include <string.h>

#include "name_table.h"
#include "cells.h"
#include "defs.h"
#include "errors.h"
#include "indexing.h"
#include "instructions.h"
#include "string_table.h"

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
global	void
insert_constant_table(cell constant, offset address, code *table, unsigned int size)
{
reg	natural	i;
reg	natural	incr;
reg	natural	table_size;
reg	cell	value;
reg	code	*pc;

	table_size = TableSize(size);
	incr = 1;
	for (i = (IsInteger(constant) ? IntOf(constant) % table_size :
				hash_string(String(constant), table_size)),
			pc = table + i * SizeOfConstantTableEntry,
			GetConstant(value);
	     value != NULL;
	     i = (i+incr)%table_size,
			pc = table + i * SizeOfConstantTableEntry,
			GetConstant(value))
		;
	UnGetConstant();
	PutConstant(constant);
	PutOffset(address);
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
global	offset
lookup_constant_table(cell constant, code *table, unsigned int size)
{
reg	natural	i;
reg	natural	incr;
reg	natural	table_size;
reg	cell	value;
reg	code	*pc;
	offset	address;

	table_size = TableSize(size);
	incr = 1;
	for (i = (IsInteger(constant) ? IntOf(constant) % table_size :
				hash_string(String(constant), table_size)),
			pc = table + i * SizeOfConstantTableEntry,
			GetConstant(value);
	     value != NULL;
	     i = (i+incr)%table_size,
			pc = table + i * SizeOfConstantTableEntry,
			GetConstant(value))
	{
		if (value == constant)
		{
			GetOffset(address);
			return(address);
		}
	}
	GetOffset(address);
	return(address);
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
global	void
insert_structure_table(cell functor, unsigned int arity, offset address, code *table, unsigned int size)
{
reg	natural	i;
reg	natural	incr;
reg	natural	table_size;
reg	cell	value;
reg	code	*pc;
	char	*fn;
	char	arityfn[INDEXSIZE + 1];

	table_size = TableSize(size);
	fn = String(functor);
	if ((strlen(fn) + 1) > INDEXSIZE || arity > INDEXSIZE)
		fatal("%s/%d too big for indexing", fn, arity);
	arityfn[0] = (char) arity;
	strcpy(&arityfn[1], fn);
	incr = 1;
	for (i = hash_string(arityfn, table_size),
			pc = table + i * SizeOfStructureTableEntry,
			GetConstant(value);
	     value != NULL;
	     i = (i+incr)%table_size,
			pc = table + i * SizeOfStructureTableEntry,
			GetConstant(value))
		;
	UnGetConstant();
	PutConstant(functor);
	PutNumber(arity);
	PutOffset(address);
}

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
global	offset
lookup_structure_table(cell functor, unsigned int arity, code *table, unsigned int size)
{
reg	natural	i;
reg	natural	incr;
reg	natural	table_size;
reg	cell	value;
reg	natural	n;
reg	code	*pc;
	char	*fn;
	char	arityfn[INDEXSIZE + 1];
	offset	address;

	table_size = TableSize(size);
	fn = String(functor);
	if ((strlen(fn) + 1) > INDEXSIZE || arity > INDEXSIZE)
		fatal("%s/%d too big for indexing", fn, arity);
	arityfn[0] = (char) arity;
	strcpy(&arityfn[1], fn);
	incr = 1;
	for (i = hash_string(arityfn, table_size),
			pc = table + i * SizeOfStructureTableEntry,
			GetConstant(value);
	     value != NULL;
	     i = (i+incr)%table_size,
			pc = table + i * SizeOfStructureTableEntry,
			GetConstant(value))
	{
		GetNumber(n);
		if (value == functor && n == arity)
		{
			GetOffset(address);
			return(address);
		}
	}
	SkipNumber();
	GetOffset(address);
	return(address);
}
