/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	INSTRUCTIONS_H
#define	INSTRUCTIONS_H

/* data size */

#define SizeOfConstant		4
#define SizeOfRegister		1
#define SizeOfNumber		1
#define SizeOfAddress		4
#define SizeOfOffset		2
#define SizeOfPredAtom		3

/* Instruction argument retrieval */

#define Get1stByte(i)		((i) = *pc++)
#define GetByte(i)		(((i) <<= 8), ((i) |= *pc++))

#define Get1Byte(i)		(Get1stByte(i))
#define Get2Byte(i)		(Get1Byte(i), GetByte(i))
#define Get3Byte(i)		(Get2Byte(i), GetByte(i))
#define Get4Byte(i)		(Get3Byte(i), GetByte(i))

#define GetConstant(c)		(Get4Byte(c))
#define GetRegister(i)		(Get1Byte(i))
#define GetNumber(n)		(Get1Byte(n))
#define GetAddress(a)		(Get4Byte(a))
#define GetOffset(o)		(Get2Byte(o))
#define GetPredAtom(a)		(Get3Byte(a))
#define GetInstruction(i)	(Get1Byte(i))

/* Instruction argument unretrieval */

#define UnGetByte()		(pc--)

#define UnGet1Byte()		(UnGetByte())
#define UnGet2Byte()		(UnGet1Byte(), UnGetByte())
#define UnGet3Byte()		(UnGet2Byte(), UnGetByte())
#define UnGet4Byte()		(UnGet3Byte(), UnGetByte())

#define UnGetConstant()		(UnGet4Byte())
#define UnGetRegister()		(UnGet1Byte())
#define UnGetNumber()		(UnGet1Byte())
#define UnGetAddress()		(UnGet4Byte())
#define UnGetOffset()		(UnGet2Byte())
#define UnGetPredAtom()		(UnGet3Byte())
#define UnGetInstruction()	(UnGet1Byte())

/* Instruction store */

#define	Byte1Mask		0x000000ff
#define	Byte2Mask		0x0000ff00
#define	Byte3Mask		0x00ff0000
#define	Byte4Mask		0xff000000

#define Put1Byte(i)		(*pc++ = ((i) & Byte1Mask))
#define Put2Byte(i)		((*pc++ = ((i) & Byte2Mask) >> 8), \
				 Put1Byte(i))
#define Put3Byte(i)		((*pc++ = ((i) & Byte3Mask) >> 16), \
				 Put2Byte(i))
#define Put4Byte(i)		((*pc++ = ((i) & Byte4Mask) >> 24), \
				 Put3Byte(i))

#define PutConstant(n)		(Put4Byte(n))
#define PutRegister(i)		(Put1Byte(i))
#define PutNumber(n)		(Put1Byte(n))
#define PutAddress(a)		(Put4Byte(a))
#define PutOffset(o)		(Put2Byte(o))
#define PutPredAtom(a)		(Put3Byte(a))
#define PutInstruction(n)	(Put1Byte(n))

/* Skip Instructions */

#define	SkipByte()		(pc++)

#define Skip1Byte()		(SkipByte())
#define Skip2Byte()		(Skip1Byte(), SkipByte())
#define Skip3Byte()		(Skip2Byte(), SkipByte())
#define Skip4Byte()		(Skip3Byte(), SkipByte())

#define SkipConstant()		(Skip4Byte())
#define SkipRegister()		(Skip1Byte())
#define SkipNumber()		(Skip1Byte())
#define SkipAddress()		(Skip4Byte())
#define SkipOffset()		(Skip2Byte())
#define SkipPredAtom()		(Skip3Byte())

/* Update call / execute instruction */

#define	UpdateCallInstruction(p) (pc_save = p,				\
				 UnGetNumber(),				\
				 UnGetNumber(), UnGetPredAtom(),	\
				 UnGetInstruction(),			\
				 PutInstruction(CALL_ADDRESS),		\
				 PutAddress(pc_save - code_area),	\
				 SkipNumber(),				\
				 pc_save)
#define	UpdateExecuteInstruction(p)	(pc_save = p,			  \
					 UnGetNumber(), UnGetPredAtom(),  \
					 UnGetInstruction(),		  \
					 PutInstruction(EXECUTE_ADDRESS), \
					 PutAddress(pc_save - code_area), \
					 pc_save)

#endif	/* INSTRUCTIONS_H */
