/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include <string.h>

#include "code_area.h"
#include "errors.h"
#include "index.h"
#include "instructions.h"	/* debugging */
#include "load.h"
#include "pc.h"
#include "query_code.h"
#include "string_map.h"
#include "string_table.h"

global code * bliff;
/*----------------------------------------------------------------------------

Format of a .qo file
--------------------

	+-------+
	| size	|
	+-------+
	|   s	|	} ignore 1st byte
	|   t	|	}
	|   r	|	} size bytes
	|   i	|	}
	|   n	|	}
	|   g	|	}
	|   s	|	}
	+-------+
	| size	|
	+-------+
	| q  c	|	}
	| u  o	|	}
	| e  d	|	} size bytes
	| r  e	|	}
	| y	|	}
	+-------+
	|string#|			}
	+-------+			}
	| arity	|			}
	+-------+			}
	| size	|			} repeat for each predicate
	+-------+			}
	|  c	|	}		}
	|  o	|	} size bytes	}
	|  d	|	}		}
	|  e	|	}		}
	+-------+

pass 1:
	for each object file do
		merge strings into name table building a map table of 
		old and new string table offsets
		append query code to query
		for each predicate do
			add code
			insert entry into predicate table

pass 2: (see link.c)
	complete pass through code table, updating references to strings
	& predicates.
----------------------------------------------------------------------------*/

extern int fclose (FILE *);

global	void
load_object_file(char *filename, index *object_index)
{
	FILE	*object_file;

	if ((object_file = fopen(filename, "r")) == NULL)
		fatal("Could not open %s", filename);

	object_index->string_map = top_of_string_map;
	if ((top_of_string_map += merge_strings(object_index->string_map,
					   object_file, filename)) >
	    ((offset *)(((char *)string_map) +
			 Kwords_to_chars(string_map_size))))
		fatal("Out of space in string map %d K", string_map_size);

	object_index->obj_query_code_start = pc = top_of_query_code;
	add_query_code(object_file, filename);
	object_index->obj_query_code_top = top_of_query_code = pc;

	object_index->obj_code_area_start = pc = top_of_code_area;
	while (!feof(object_file))
		add_procedure(object_index, object_file, filename);
	object_index->obj_code_area_top = top_of_code_area = pc;

	fclose(object_file);
}
