/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	NAME_TABLE_H
#define	NAME_TABLE_H

#include "defs.h"
#include "primitives.h"
#include "cells.h"



typedef struct
{
	offset   nameN;
        cell     valueN;
} NAME;

#define	DEFAULT_NAME_TABLE_SIZE	  10007
#define NAME_TABLE_TAGMASK        0x80000000
#define VARIABLE_W                0x80000000
#define ATOM_W                    0x00000000
#define PtrToName(c)              ((Location(c))[1])
#define NameT(c)                  (c.nameN)
#define NamePtrToEntry(c)	  ((c)->nameN)
#define NameOffset(c)             (RestOfNameTableCell(NameT(c)))
#define NamePtrToOffset(c)	  (RestOfNameTableCell(NamePtrToEntry(c)))
#define ValueOfName(c)            (c.valueN)
#define Named(c)                  ((NAME *)(PtrToName(c)))
#define String3(c)                (String4(Named(c)))
#define String4(c)                (String2(NamePtrToOffset(c))) 
#define OldName(c)                (c.old_name)
#define NewName(c)                (c.new_name)
#define NameTableTag(c)           (NameT(c)&NAME_TABLE_TAGMASK) 
#define RestOfNameTableCell(c)    ((c)&~NAME_TABLE_TAGMASK) 

#define IsVariableW(c)            (NameTableTag(NameT(c)) == VARIABLE_W) 

global	NAME	 *name_table; /* The name table which contains structures 
                                 describing atoms and variables.The structures
				 are tagged to distinguish between atoms and
				 variables. 
                                 The structures consist of a name - i.e. 
                                 pointer to the string table, and a value.
				 For atoms, the value can be nil or a pointer
				 to a term.For variables, the value can be
				 nil or a pointer to a variable.         */ 
global	natural	nil_in_name_table;
global	natural	cons_in_name_table;
global	natural	dollar_in_name_table; 
extern	natural	name_table_size;
extern	void	initialise_name_table(void);
extern	natural	lookup_name_table(char *s, int name_table_tag);
extern	natural	hash_string(char *s, unsigned int table_size);

#endif	/* NAME_TABLE_H */
