/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	OPCODES_H
#define	OPCODES_H

#define PUT_CONSTANT 1
#define PUT_NIL 2
#define PUT_CONS 3
#define PUT_APPLY 4
#define PUT_PAIR 5
#define PUT_QUANTIFIER 6
#define PUT_X_VARIABLE 7
#define PUT_Y_VARIABLE 8
#define PUT_X_VALUE 9
#define PUT_Y_VALUE 10
#define PUT_UNSAFE_VALUE 11
#define PUT_X_OBJECT_VARIABLE 12
#define PUT_Y_OBJECT_VARIABLE 13
#define PUT_X_OBJECT_VALUE 14
#define PUT_Y_OBJECT_VALUE 15
#define PUT_SUBSTITUTION_OPERATOR 16
#define PUT_EMPTY_SUBSTITUTION 17
#define PUT_SUBSTITUTION 18
#define PUT_PARALLEL_SUBSTITUTION 19
#define PUT_PARALLEL_SUBSTITUTION_PAIR 20
#define SET_OBJECT_PROPERTY 21
#define DETERMINE_PROPERTY 22
#define GET_CONSTANT 23
#define GET_NIL 24
#define GET_CONS 25
#define GET_APPLY 26
#define GET_PAIR 27
#define GET_QUANTIFIER 28
#define GET_X_VARIABLE 29
#define GET_Y_VARIABLE 30
#define GET_X_VALUE 31
#define GET_Y_VALUE 32
#define GET_X_OBJECT_VARIABLE 33
#define GET_Y_OBJECT_VARIABLE 34
#define GET_X_OBJECT_VALUE 35
#define GET_Y_OBJECT_VALUE 36
#define CALL_PREDICATE 37
#define CALL_ADDRESS 38
#define EXECUTE_PREDICATE 39
#define EXECUTE_ADDRESS 40
#define PROCEED 41
#define GOTO 42
#define ESCAPE 43
#define FAIL 44
#define CUT 45
#define DO_DELAYED_PROBLEMS 46
#define NOT_FREE_IN 47
#define ALLOCATE 48
#define DEALLOCATE 49
#define TRY_ME_ELSE 50
#define RETRY_ME_ELSE 51
#define TRUST_ME_ELSE_FAIL 52
#define TRY 53
#define RETRY 54
#define TRUST 55
#define SWITCH_ON_TERM 56
#define SWITCH_ON_CONSTANT 57
#define SWITCH_ON_STRUCTURE 58
#define SWITCH_ON_QUANTIFIER 59
#define COMMIT 60
#define BACK_TO 61
#define COMMIT_STAGE 62

#endif	/* OPCODES_H */
