/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef OPTIONS_H
#define OPTIONS_H
/*
 *	Option processing.
 *
 *	Conforms to intro(1) in System V.
 *
 *	Typical layout:
 *
 *		OPTIONS ("-b -t c -f file -w N file ...")
 *			FLAG	('b', flag)
 *			CHAR	('t', tab_ch)
 *			STRING	('f', filename)
 *				f = fopen(filename, "r");
 *			NUMBER	('w', width)
 *		ENDOPTS
 */
/* 
 * Modified Tue Aug 13 14:00:58 EST 1991 by Dan Hazel
 * ** leaves unrecognised arguments in argv
 *
 */
/* having a maximum number of args here is a time bug
   fix later */
#define MAX_ARGS 200
char	*O_name, *O_usage, *O_save[MAX_ARGS], **O_step;

void
usage()
{
	/*
	 * Poor man's version of:
	 *
	 *	fprintf(stderr, "Usage: %s %s\n", O_name, O_usage);
	 */
	write(2, "Usage: ", 7);
	write(2, O_name, strlen(O_name));
	write(2, " ", 1);
	write(2, O_usage, strlen(O_usage));
	write(2, "\n", 1);
	exit(1);
}

/*
 *	An argument "-" is interpreted as a program argument and stops
 *	option processing.
 *
 *	An argument "--" stops option processing and is discarded.
 *
 *	An option which takes an argument uses either the rest of the
 *	the current argument, or, if at the end of an argument, the
 *	next argument.
 */

#define Reset_arg {*argv = O_step;}

#define OPTIONS(usage)							\
	O_usage = usage;						\
	O_name = argv[0];						\
	O_save[0] = argv[0];						\
	O_step = O_save;						\
	while ((*++O_step = *++argv) && **argv == '-' && argv[0][1]) {	\
		register int O_cont = 1;				\
									\
		argc--;							\
		if (argv[0][1] == '-' && argv[0][2] == '\0') {		\
			argv++;						\
			break;						\
		}							\
		while (O_cont)						\
			switch (*++*argv) {				\
			case '\0':					\
				O_cont = 0;				\
				O_step--;

#define FLAG(c,flag)	break;						\
			case c:						\
				flag = 1;

#define ISNUMBER(s)	((s) && (*s) >= '0' && (*s) <= '9')
#define NUMBER(c,num)	break;						\
			case c:						\
				if (*++*argv == '\0') {			\
					if (--argc == 0)		\
						usage();		\
					{				\
					char *number = *++argv;		\
					if(!ISNUMBER(number))		\
						*++O_step = *argv;	\
					}				\
				}					\
				if(ISNUMBER(*argv)){			\
				    num = atoi(*argv);			\
				    O_step--;				\
				}					\
				O_cont = 0;

#define STRING(c,str)	break;						\
			case c:						\
				if (*++*argv == '\0') {			\
					if (--argc == 0)		\
						usage();		\
					argv++;				\
				}					\
				str = *argv;				\
				O_step--;				\
				O_cont = 0;

#define CHAR(c,ch)	break;						\
			case c:						\
				if (*++*argv == '\0') {			\
					if (--argc == 0)		\
						usage();		\
					argv++;				\
				}					\
				ch = **argv;				\
				O_step--;				\
				O_cont = 0;

#define ENDOPTS		break;						\
			default:					\
			    while ((argc-1) && **(argv+1) != '-'){	\
				--argc;					\
				*++O_step = *++argv;			\
			    }						\
			    O_cont = 0;					\
			break;						\
			}						\
	}								\
	while(argc--)							\
	    *++O_step = *++argv;					\
	*O_step = (char *)0;						\
	argv = O_save;							\
	argc = (int)(O_step - O_save - 1);

#endif /* OPTIONS_H */
