/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	STRING_TABLE_H
#define	STRING_TABLE_H

#include "defs.h"
#include "primitives.h"

#define DEFAULT_STRING_TABLE_SIZE	10

extern	char	*string_table;
extern	natural	string_table_size;
extern	char	*top_of_string_table;
extern	void	initialise_string_table(void);
extern	void	insert_defaults_in_string_table(void);
extern	natural	add_name_string_hash(char *s, int name_table_tag);
extern	offset	add_name_string_offset(char *s, int name_table_tag);
extern	offset	add_new_string(char *s);
extern	int	merge_strings(offset *string_map, FILE *object_file, char *filename);

#endif	/* STRING_TABLE_H */
