/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include <stdio.h>
#include "errors.h"
#include "defs.h"
#include "io.h"

char	*input_filename=DEFAULT_INPUT_FILENAME;
char	*output_filename=DEFAULT_OUTPUT_FILENAME;
FILE	*input_stream=stdin;
FILE	*output_stream=stdout;
int	outputfd=1;


extern int fprintf (FILE *, const char *, ...);
extern int fclose (FILE *);
extern size_t fwrite (const void *, size_t, size_t, FILE *);

int
initialize_input(void)
{
	if(strcmp(input_filename, DEFAULT_INPUT_FILENAME))
		/* open input stream */
		if(freopen(input_filename, "r", stdin) == NULL)
			fatal("Can't open input file: %s", input_filename);
	fprintf(stderr, "assembling %s ",input_filename);
	}
void
close_input(void)
{
	fclose(input_stream);
	}

int
initialize_output(void)
{
	if(strcmp(output_filename, DEFAULT_OUTPUT_FILENAME))
		/* open output stream */
		if(freopen(output_filename, "w+", stdout) == NULL)
			fatal("Can't open output file: %s", output_filename);
	fprintf(stderr, "to %s\n", output_filename);
	}

void
close_output(void)
{
	fclose(output_stream);
	}

int
write_integer(int i)
{
	return (NULL != fwrite((char *)(&i), sizeof(int), 1, output_stream));
	}

int
write_byte(char c)
{
	return (NULL != fwrite(&c, 1, 1, output_stream));
	}

/* dump a lump of size s bytes pointed to by p */
int
write_block(char *p, int s)
{
	return (NULL != fwrite(p, s, 1, output_stream));
	}
